#ifndef _RHEO_MESHPOINT_H
#define _RHEO_MESHPOINT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// Subdivision tree on a mesh with grid stump 
// and octree-like embranching. 
// 
// author: jocelyn.etienne@imag.fr
//
// date: 14 Feb 2002
// 
#include "rheolef/point.h"
#include "rheolef/geo_element.h"
namespace rheolef { 

//! A meshpoint is a point which is known by a mesh element it belongs to 
//! and its coordinates in the appropriate reference element

class meshpoint 
 {
public:
	
	typedef geo_element::size_type size_type;

	// allocators/deallocators
	
	meshpoint () {};

	meshpoint (size_type e, const point& x_hat) 
	 { element_=e; x_hat_=x_hat; };

	meshpoint (const point& x_hat, size_type e) 
	 { element_=e; x_hat_=x_hat; };

	// affectation: copy
	meshpoint& operator = (const meshpoint& m)
	 { 
	 	x_hat_ = m.x_hat_; 
		element_ = m.element_;
	 	return *this; 
	 }

	// accessors

	//! Coordinates in reference element
	point
	hat() const;

	friend
	bool
	operator== (const meshpoint& x, const meshpoint& y);

	//! Container element
	size_type
	element() const;

private:

 	size_type element_;

	point x_hat_;
 };

inline
meshpoint::size_type
meshpoint::element() const
 { return element_; }

inline
point
meshpoint::hat() const
 { return x_hat_; }

inline
bool
operator== (const meshpoint& x, const meshpoint& y)
 { return ( (x.element_==y.element_) && (x.x_hat_==y.x_hat_) ); }

inline
bool
operator!= (const meshpoint& x, const meshpoint& y)
 { return (!(x==y)); }

}// namespace rheolef
#endif // MESHPOINT_H
