#!/bin/bash
echo "checking for non-ascii sequences in source files..."
top_srcdir=${1-"."}
cd $top_srcdir

h=`find . -name "*.h"`
c=`find . -name "*.cc"`
a=`find . -name "*.am"`
d=`find . -name "*.ac"`
m=`find . -name "*.m4"`
t=`find . -name "*.tex"`
p=`find . -name "*.plot"`
f=`find . -name "*.fig"`
L="$h $c $a $d $m $t $p $f"
status=0
for x in $L; do
 if test -h $x; then continue; fi ; # symb link
 iconv -f UTF-8 -t US-ASCII < $x > tmp.txt
 st=$?
 if test $st -ne 0; then
  echo "$x: iconv failed"
  status=1
 fi
 if diff $x tmp.txt >/dev/null; then
  true
 else
  echo "$x: non US-ASCII"
  status=1
 fi
done 
exit $status
