#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style,utf8strings
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(object):
  def getSyncState(self, authenticationToken):
    """
    Asks the NoteStore to provide information about the status of the user
    account corresponding to the provided authentication token.

    Parameters:
     - authenticationToken
    """
    pass

  def getSyncStateWithMetrics(self, authenticationToken, clientMetrics):
    """
    Asks the NoteStore to provide information about the status of the user
    account corresponding to the provided authentication token.
    This version of 'getSyncState' allows the client to upload coarse-
    grained usage metrics to the service.

    @param clientMetrics  see the documentation of the ClientUsageMetrics
      structure for an explanation of the fields that clients can pass to
      the service.

    Parameters:
     - authenticationToken
     - clientMetrics
    """
    pass

  def getSyncChunk(self, authenticationToken, afterUSN, maxEntries, fullSyncOnly):
    """
    DEPRECATED - use getFilteredSyncChunk.

    Parameters:
     - authenticationToken
     - afterUSN
     - maxEntries
     - fullSyncOnly
    """
    pass

  def getFilteredSyncChunk(self, authenticationToken, afterUSN, maxEntries, filter):
    """
    Asks the NoteStore to provide the state of the account in order of
    last modification.  This request retrieves one block of the server's
    state so that a client can make several small requests against a large
    account rather than getting the entire state in one big message.
    This call gives fine-grained control of the data that will
    be received by a client by omitting data elements that a client doesn't
    need. This may reduce network traffic and sync times.

    @param afterUSN
      The client can pass this value to ask only for objects that
      have been updated after a certain point.  This allows the client to
      receive updates after its last checkpoint rather than doing a full
      synchronization on every pass.  The default value of "0" indicates
      that the client wants to get objects from the start of the account.

    @param maxEntries
      The maximum number of modified objects that should be
      returned in the result SyncChunk.  This can be used to limit the size
      of each individual message to be friendly for network transfer.

    @param filter
      The caller must set some of the flags in this structure to specify which
      data types should be returned during the synchronization.  See
      the SyncChunkFilter structure for information on each flag.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "afterUSN" - if negative
      </li>
      <li> BAD_DATA_FORMAT "maxEntries" - if less than 1
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - afterUSN
     - maxEntries
     - filter
    """
    pass

  def getLinkedNotebookSyncState(self, authenticationToken, linkedNotebook):
    """
    Asks the NoteStore to provide information about the status of a linked
    notebook that has been shared with the caller, or that is public to the
    world.
    This will return a result that is similar to getSyncState, but may omit
    SyncState.uploaded if the caller doesn't have permission to write to
    the linked notebook.

    This function must be called on the shard that owns the referenced
    notebook.  (I.e. the shardId in /shard/shardId/edam/note must be the
    same as LinkedNotebook.shardId.)

    @param authenticationToken
      This should be an authenticationToken for the guest who has received
      the invitation to the share.  (I.e. this should not be the result of
      NoteStore.authenticateToSharedNotebook)

    @param linkedNotebook
      This structure should contain identifying information and permissions
      to access the notebook in question.

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    pass

  def getLinkedNotebookSyncChunk(self, authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly):
    """
    Asks the NoteStore to provide information about the contents of a linked
    notebook that has been shared with the caller, or that is public to the
    world.
    This will return a result that is similar to getSyncChunk, but will only
    contain entries that are visible to the caller.  I.e. only that particular
    Notebook will be visible, along with its Notes, and Tags on those Notes.

    This function must be called on the shard that owns the referenced
    notebook.  (I.e. the shardId in /shard/shardId/edam/note must be the
    same as LinkedNotebook.shardId.)

    @param authenticationToken
      This should be an authenticationToken for the guest who has received
      the invitation to the share.  (I.e. this should not be the result of
      NoteStore.authenticateToSharedNotebook)

    @param linkedNotebook
      This structure should contain identifying information and permissions
      to access the notebook in question.  This must contain the valid fields
      for either a shared notebook (e.g. shareKey)
      or a public notebook (e.g. username, uri)

    @param afterUSN
      The client can pass this value to ask only for objects that
      have been updated after a certain point.  This allows the client to
      receive updates after its last checkpoint rather than doing a full
      synchronization on every pass.  The default value of "0" indicates
      that the client wants to get objects from the start of the account.

    @param maxEntries
      The maximum number of modified objects that should be
      returned in the result SyncChunk.  This can be used to limit the size
      of each individual message to be friendly for network transfer.
      Applications should not request more than 256 objects at a time,
      and must handle the case where the service returns less than the
      requested number of objects in a given request even though more
      objects are available on the service.

    @param fullSyncOnly
      If true, then the client only wants initial data for a full sync.
      In this case, the service will not return any expunged objects,
      and will not return any Resources, since these are also provided
      in their corresponding Notes.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "afterUSN" - if negative
      </li>
      <li> BAD_DATA_FORMAT "maxEntries" - if less than 1
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "LinkedNotebook" - if the provided information doesn't match any
        valid notebook
      </li>
      <li> "LinkedNotebook.uri" - if the provided public URI doesn't match any
        valid notebook
      </li>
      <li> "SharedNotebook.id" - if the provided information indicates a
         shared notebook that no longer exists
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
     - afterUSN
     - maxEntries
     - fullSyncOnly
    """
    pass

  def listNotebooks(self, authenticationToken):
    """
    Returns a list of all of the notebooks in the account.

    Parameters:
     - authenticationToken
    """
    pass

  def getNotebook(self, authenticationToken, guid):
    """
    Returns the current state of the notebook with the provided GUID.
    The notebook may be active or deleted (but not expunged).

    @param guid
      The GUID of the notebook to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Notebook" - private notebook, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getDefaultNotebook(self, authenticationToken):
    """
    Returns the notebook that should be used to store new notes in the
    user's account when no other notebooks are specified.

    Parameters:
     - authenticationToken
    """
    pass

  def createNotebook(self, authenticationToken, notebook):
    """
    Asks the service to make a notebook with the provided name.

    @param notebook
      The desired fields for the notebook must be provided on this
      object.  The name of the notebook must be set, and either the 'active'
      or 'defaultNotebook' fields may be set by the client at creation.
      If a notebook exists in the account with the same name (via
      case-insensitive compare), this will throw an EDAMUserException.

    @return
      The newly created Notebook.  The server-side GUID will be
      saved in this object's 'guid' field.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Notebook.stack" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Publishing.uri" - if publishing set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "Publishing.publicDescription" - if too long
      </li>
      <li> DATA_CONFLICT "Notebook.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Publishing.uri" - if URI already in use
      </li>
      <li> DATA_REQUIRED "Publishing.uri" - if publishing set but uri missing
      </li>
      <li> LIMIT_REACHED "Notebook" - at max number of notebooks
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebook
    """
    pass

  def updateNotebook(self, authenticationToken, notebook):
    """
    Submits notebook changes to the service.  The provided data must include
    the notebook's guid field for identification.

    @param notebook
      The notebook object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Notebook.stack" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Publishing.uri" - if publishing set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "Publishing.publicDescription" - if too long
      </li>
      <li> DATA_CONFLICT "Notebook.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Publishing.uri" - if URI already in use
      </li>
      <li> DATA_REQUIRED "Publishing.uri" - if publishing set but uri missing
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebook
    """
    pass

  def expungeNotebook(self, authenticationToken, guid):
    """
    Permanently removes the notebook from the user's account.
    After this action, the notebook is no longer available for undeletion, etc.
    If the notebook contains any Notes, they will be moved to the current
    default notebook and moved into the trash (i.e. Note.active=false).
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the notebook to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.guid" - if the parameter is missing
      </li>
      <li> LIMIT_REACHED "Notebook" - trying to expunge the last Notebook
      </li>
      <li> PERMISSION_DENIED "Notebook" - private notebook, user doesn't own
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def listTags(self, authenticationToken):
    """
    Returns a list of the tags in the account.  Evernote does not support
    the undeletion of tags, so this will only include active tags.

    Parameters:
     - authenticationToken
    """
    pass

  def listTagsByNotebook(self, authenticationToken, notebookGuid):
    """
    Returns a list of the tags that are applied to at least one note within
    the provided notebook.  If the notebook is public, the authenticationToken
    may be ignored.

    @param notebookGuid
       the GUID of the notebook to use to find tags

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - notebook not found by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebookGuid
    """
    pass

  def getTag(self, authenticationToken, guid):
    """
    Returns the current state of the Tag with the provided GUID.

    @param guid
      The GUID of the tag to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - private Tag, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def createTag(self, authenticationToken, tag):
    """
    Asks the service to make a tag with a set of information.

    @param tag
      The desired list of fields for the tag are specified in this
      object.  The caller must specify the tag name, and may provide
      the parentGUID.

    @return
      The newly created Tag.  The server-side GUID will be
      saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Tag.parentGuid" - malformed GUID
      </li>
      <li> DATA_CONFLICT "Tag.name" - name already in use
      </li>
      <li> LIMIT_REACHED "Tag" - at max number of tags
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.parentGuid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - tag
    """
    pass

  def updateTag(self, authenticationToken, tag):
    """
    Submits tag changes to the service.  The provided data must include
    the tag's guid field for identification.  The service will apply
    updates to the following tag fields:  name, parentGuid

    @param tag
      The tag object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Tag.parentGuid" - malformed GUID
      </li>
      <li> DATA_CONFLICT "Tag.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Tag.parentGuid" - can't set parent: circular
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
      <li> "Tag.parentGuid" - parent not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - tag
    """
    pass

  def untagAll(self, authenticationToken, guid):
    """
    Removes the provided tag from every note that is currently tagged with
    this tag.  If this operation is successful, the tag will still be in
    the account, but it will not be tagged on any notes.

    This function is not indended for use by full synchronizing clients, since
    it does not provide enough result information to the client to reconcile
    the local state without performing a follow-up sync from the service.  This
    is intended for "thin clients" that need to efficiently support this as
    a UI operation.

    @param guid
      The GUID of the tag to remove from all notes.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the guid parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def expungeTag(self, authenticationToken, guid):
    """
    Permanently deletes the tag with the provided GUID, if present.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the tag to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the guid parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def listSearches(self, authenticationToken):
    """
    Returns a list of the searches in the account.  Evernote does not support
    the undeletion of searches, so this will only include active searches.

    Parameters:
     - authenticationToken
    """
    pass

  def getSearch(self, authenticationToken, guid):
    """
    Returns the current state of the search with the provided GUID.

    @param guid
      The GUID of the search to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - private Tag, user doesn't own
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def createSearch(self, authenticationToken, search):
    """
    Asks the service to make a saved search with a set of information.

    @param search
      The desired list of fields for the search are specified in this
      object. The caller must specify the name and query for the
      search, and may optionally specify a search scope.
      The SavedSearch.format field is ignored by the service.

    @return
      The newly created SavedSearch.  The server-side GUID will be
      saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "SavedSearch.query" - invalid length
      </li>
      <li> DATA_CONFLICT "SavedSearch.name" - name already in use
      </li>
      <li> LIMIT_REACHED "SavedSearch" - at max number of searches
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - search
    """
    pass

  def updateSearch(self, authenticationToken, search):
    """
    Submits search changes to the service. The provided data must include
    the search's guid field for identification. The service will apply
    updates to the following search fields: name, query, and scope.

    @param search
      The search object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "SavedSearch.query" - invalid length
      </li>
      <li> DATA_CONFLICT "SavedSearch.name" - name already in use
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - search
    """
    pass

  def expungeSearch(self, authenticationToken, guid):
    """
    Permanently deletes the saved search with the provided GUID, if present.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the search to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.guid" - if the guid parameter is empty
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def findNotes(self, authenticationToken, filter, offset, maxNotes):
    """
    DEPRECATED. Use findNotesMetadata.

    Parameters:
     - authenticationToken
     - filter
     - offset
     - maxNotes
    """
    pass

  def findNoteOffset(self, authenticationToken, filter, guid):
    """
    Finds the position of a note within a sorted subset of all of the user's
    notes. This may be useful for thin clients that are displaying a paginated
    listing of a large account, which need to know where a particular note
    sits in the list without retrieving all notes first.

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The list of criteria that will constrain the notes to be returned.

    @param guid
      The GUID of the note to be retrieved.

    @return
      If the note with the provided GUID is found within the matching note
      list, this will return the offset of that note within that list (where
      the first offset is 0).  If the note is not found within the set of
      notes, this will return -1.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "offset" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "maxNotes" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - guid
    """
    pass

  def findNotesMetadata(self, authenticationToken, filter, offset, maxNotes, resultSpec):
    """
    Used to find the high-level information about a set of the notes from a
    user's account based on various criteria specified via a NoteFilter object.
    <p/>
    Web applications that wish to periodically check for new content in a user's
    Evernote account should consider using webhooks instead of polling this API.
    See http://dev.evernote.com/documentation/cloud/chapters/polling_notification.php
    for more information.

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The list of criteria that will constrain the notes to be returned.

    @param offset
      The numeric index of the first note to show within the sorted
      results.  The numbering scheme starts with "0".  This can be used for
      pagination.

    @param maxNotes
      The mximum notes to return in this query.  The service will return a set
      of notes that is no larger than this number, but may return fewer notes
      if needed.  The NoteList.totalNotes field in the return value will
      indicate whether there are more values available after the returned set.

    @param resultSpec
      This specifies which information should be returned for each matching
      Note. The fields on this structure can be used to eliminate data that
      the client doesn't need, which will reduce the time and bandwidth
      to receive and process the reply.

    @return
      The list of notes that match the criteria.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "offset" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "maxNotes" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - offset
     - maxNotes
     - resultSpec
    """
    pass

  def findNoteCounts(self, authenticationToken, filter, withTrash):
    """
    This function is used to determine how many notes are found for each
    notebook and tag in the user's account, given a current set of filter
    parameters that determine the current selection.  This function will
    return a structure that gives the note count for each notebook and tag
    that has at least one note under the requested filter.  Any notebook or
    tag that has zero notes in the filtered set will not be listed in the
    reply to this function (so they can be assumed to be 0).

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The note selection filter that is currently being applied.  The note
      counts are to be calculated with this filter applied to the total set
      of notes in the user's account.

    @param withTrash
      If true, then the NoteCollectionCounts.trashCount will be calculated
      and supplied in the reply. Otherwise, the trash value will be omitted.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - withTrash
    """
    pass

  def getNote(self, authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    """
    Returns the current state of the note in the service with the provided
    GUID.  The ENML contents of the note will only be provided if the
    'withContent' parameter is true.  The service will include the meta-data
    for each resource in the note, but the binary contents of the resources
    and their recognition data will be omitted.
    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).  The applicationData
    fields are returned as keysOnly.

    @param guid
      The GUID of the note to be retrieved.

    @param withContent
      If true, the note will include the ENML contents of its
      'content' field.

    @param withResourcesData
      If true, any Resource elements in this Note will include the binary
      contents of their 'data' field's body.

    @param withResourcesRecognition
      If true, any Resource elements will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withResourcesAlternateData
      If true, any Resource elements in this Note will include the binary
      contents of their 'alternateData' fields' body, if an alternate form
      is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - withContent
     - withResourcesData
     - withResourcesRecognition
     - withResourcesAlternateData
    """
    pass

  def getNoteApplicationData(self, authenticationToken, guid):
    """
    Get all of the application data for the note identified by GUID,
    with values returned within the LazyMap fullMap field.
    If there are no applicationData entries, then a LazyMap
    with an empty fullMap will be returned. If your application
    only needs to fetch its own applicationData entry, use
    getNoteApplicationDataEntry instead.

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getNoteApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Get the value of a single entry in the applicationData map
    for the note identified by GUID.

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - note not found, by GUID</li>
      <li> "NoteAttributes.applicationData.key" - note not found, by key</li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    pass

  def setNoteApplicationDataEntry(self, authenticationToken, guid, key, value):
    """
    Update, or create, an entry in the applicationData map for
    the note identified by guid.

    Parameters:
     - authenticationToken
     - guid
     - key
     - value
    """
    pass

  def unsetNoteApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Remove an entry identified by 'key' from the applicationData map for
    the note identified by 'guid'. Silently ignores an unset of a
    non-existing key.

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    pass

  def getNoteContent(self, authenticationToken, guid):
    """
    Returns XHTML contents of the note with the provided GUID.
    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the note to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getNoteSearchText(self, authenticationToken, guid, noteOnly, tokenizeForIndexing):
    """
    Returns a block of the extracted plain text contents of the note with the
    provided GUID.  This text can be indexed for search purposes by a light
    client that doesn't have capabilities to extract all of the searchable
    text content from the note and its resources.

    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the note to be retrieved.

    @param noteOnly
      If true, this will only return the text extracted from the ENML contents
      of the note itself.  If false, this will also include the extracted text
      from any text-bearing resources (PDF, recognized images)

    @param tokenizeForIndexing
      If true, this will break the text into cleanly separated and sanitized
      tokens.  If false, this will return the more raw text extraction, with
      its original punctuation, capitalization, spacing, etc.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - noteOnly
     - tokenizeForIndexing
    """
    pass

  def getResourceSearchText(self, authenticationToken, guid):
    """
    Returns a block of the extracted plain text contents of the resource with
    the provided GUID.  This text can be indexed for search purposes by a light
    client that doesn't have capability to extract all of the searchable
    text content from a resource.

    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getNoteTagNames(self, authenticationToken, guid):
    """
    Returns a list of the names of the tags for the note with the provided
    guid.  This can be used with authentication to get the tags for a
    user's own note, or can be used without valid authentication to retrieve
    the names of the tags for a note in a public notebook.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def createNote(self, authenticationToken, note):
    """
    Asks the service to make a note with the provided set of information.

    @param note
      A Note object containing the desired fields to be populated on
      the service.

    @return
      The newly created Note from the service.  The server-side
      GUIDs for the Note and any Resources will be saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.title" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Note.content" - invalid length for ENML content
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> BAD_DATA_FORMAT "NoteAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> DATA_CONFLICT "Note.deleted" - deleted time set on active note
      </li>
      <li> DATA_REQUIRED "Resource.data" - resource data body missing
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> LIMIT_REACHED "Note" - at max number per account
      </li>
      <li> LIMIT_REACHED "Note.size" - total note size too large
      </li>
      <li> LIMIT_REACHED "Note.resources" - too many resources on Note
      </li>
      <li> LIMIT_REACHED "Note.tagGuids" - too many Tags on Note
      </li>
      <li> LIMIT_REACHED "Resource.data.size" - resource too large
      </li>
      <li> LIMIT_REACHED "NoteAttribute.*" - attribute string too long
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Note.notebookGuid" - NB not owned by user
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
      <li> BAD_DATA_FORMAT "Tag.name" - Note.tagNames was provided, and one
        of the specified tags had an invalid length or pattern
      </li>
      <li> LIMIT_REACHED "Tag" - Note.tagNames was provided, and the required
        new tags would exceed the maximum number per account
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.notebookGuid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - note
    """
    pass

  def updateNote(self, authenticationToken, note):
    """
    Submit a set of changes to a note to the service.  The provided data
    must include the note's guid field for identification. The note's
    title must also be set.

    @param note
      A Note object containing the desired fields to be populated on
      the service. With the exception of the note's title and guid, fields
      that are not being changed do not need to be set. If the content is not
      being modified, note.content should be left unset. If the list of
      resources is not being modified, note.resources should be left unset.

    @return
      The metadata (no contents) for the Note on the server after the update

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.title" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Note.content" - invalid length for ENML body
      </li>
      <li> BAD_DATA_FORMAT "NoteAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> DATA_CONFLICT "Note.deleted" - deleted time set on active note
      </li>
      <li> DATA_REQUIRED "Resource.data" - resource data body missing
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> LIMIT_REACHED "Note.tagGuids" - too many Tags on Note
      </li>
      <li> LIMIT_REACHED "Note.resources" - too many resources on Note
      </li>
      <li> LIMIT_REACHED "Note.size" - total note size too large
      </li>
      <li> LIMIT_REACHED "Resource.data.size" - resource too large
      </li>
      <li> LIMIT_REACHED "NoteAttribute.*" - attribute string too long
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
      <li> PERMISSION_DENIED "Note.notebookGuid" - user doesn't own destination
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
      <li> BAD_DATA_FORMAT "Tag.name" - Note.tagNames was provided, and one
        of the specified tags had an invalid length or pattern
      </li>
      <li> LIMIT_REACHED "Tag" - Note.tagNames was provided, and the required
        new tags would exceed the maximum number per account
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - note not found, by GUID
      </li>
      <li> "Note.notebookGuid" - if notebookGuid provided, but not found
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - note
    """
    pass

  def deleteNote(self, authenticationToken, guid):
    """
    Moves the note into the trash. The note may still be undeleted, unless it
    is expunged.  This is equivalent to calling updateNote() after setting
    Note.active = false

    @param guid
      The GUID of the note to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't have permission to
             update the note.
      </li>
    </ul>

    @throws EDAMUserException <ul>
      <li> DATA_CONFLICT "Note.guid" - the note is already deleted
      </li>
    </ul>
    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def expungeNote(self, authenticationToken, guid):
    """
    Permanently removes a Note, and all of its Resources,
    from the service.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the note to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def expungeNotes(self, authenticationToken, noteGuids):
    """
    Permanently removes a list of Notes, and all of their Resources, from
    the service.  This should be invoked with a small number of Note GUIDs
    (e.g. 100 or less) on each call.  To expunge a larger number of notes,
    call this method multiple times.  This should also be used to reduce the
    number of Notes in a notebook before calling expungeNotebook() or
    in the trash before calling expungeInactiveNotes(), since these calls may
    be prohibitively slow if there are more than a few hundred notes.
    If an exception is thrown for any of the GUIDs, then none of the notes
    will be deleted.  I.e. this call can be treated as an atomic transaction.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param noteGuids
      The list of GUIDs for the Notes to remove.

    @return
      The account's updateCount at the end of this operation

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuids
    """
    pass

  def expungeInactiveNotes(self, authenticationToken):
    """
    Permanently removes all of the Notes that are currently marked as
    inactive.  This is equivalent to "emptying the trash", and these Notes
    will be gone permanently.
    <p/>
    This operation may be relatively slow if the account contains a large
    number of inactive Notes.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @return
       The number of notes that were expunged.

    Parameters:
     - authenticationToken
    """
    pass

  def copyNote(self, authenticationToken, noteGuid, toNotebookGuid):
    """
    Performs a deep copy of the Note with the provided GUID 'noteGuid' into
    the Notebook with the provided GUID 'toNotebookGuid'.
    The caller must be the owner of both the Note and the Notebook.
    This creates a new Note in the destination Notebook with new content and
    Resources that match all of the content and Resources from the original
    Note, but with new GUID identifiers.
    The original Note is not modified by this operation.
    The copied note is considered as an "upload" for the purpose of upload
    transfer limit calculation, so its size is added to the upload count for
    the owner.

    @param noteGuid
      The GUID of the Note to copy.

    @param toNotebookGuid
      The GUID of the Notebook that should receive the new Note.

    @return
      The metadata for the new Note that was created.  This will include the
      new GUID for this Note (and any copied Resources), but will not include
      the content body or the binary bodies of any Resources.

    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "Note" - at max number per account
      </li>
      <li> PERMISSION_DENIED "Notebook.guid" - destination not owned by user
      </li>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - toNotebookGuid
    """
    pass

  def listNoteVersions(self, authenticationToken, noteGuid):
    """
    Returns a list of the prior versions of a particular note that are
    saved within the service.  These prior versions are stored to provide a
    recovery from unintentional removal of content from a note. The identifiers
    that are returned by this call can be used with getNoteVersion to retrieve
    the previous note.
    The identifiers will be listed from the most recent versions to the oldest.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
    """
    pass

  def getNoteVersion(self, authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    """
    This can be used to retrieve a previous version of a Note after it has been
    updated within the service.  The caller must identify the note (via its
    guid) and the version (via the updateSequenceNumber of that version).
    to find a listing of the stored version USNs for a note, call
    listNoteVersions.
    This call is only available for notes in Premium accounts.  (I.e. access
    to past versions of Notes is a Premium-only feature.)

    @param noteGuid
      The GUID of the note to be retrieved.

    @param updateSequenceNum
      The USN of the version of the note that is being retrieved

    @param withResourcesData
      If true, any Resource elements in this Note will include the binary
      contents of their 'data' field's body.

    @param withResourcesRecognition
      If true, any Resource elements will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withResourcesAlternateData
      If true, any Resource elements in this Note will include the binary
      contents of their 'alternateData' fields' body, if an alternate form
      is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
      <li> PERMISSION_DENIED "updateSequenceNum" -
        The account isn't permitted to access previous versions of notes.
        (i.e. this is a Free account.)
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
      <li> "Note.updateSequenceNumber" - the Note doesn't have a version with
         the corresponding USN.
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - updateSequenceNum
     - withResourcesData
     - withResourcesRecognition
     - withResourcesAlternateData
    """
    pass

  def getResource(self, authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData):
    """
    Returns the current state of the resource in the service with the
    provided GUID.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).  Only the
    keys for the applicationData will be returned.

    @param guid
      The GUID of the resource to be retrieved.

    @param withData
      If true, the Resource will include the binary contents of the
      'data' field's body.

    @param withRecognition
      If true, the Resource will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withAttributes
      If true, the Resource will include the attributes

    @param withAlternateData
      If true, the Resource will include the binary contents of the
      'alternateData' field's body, if an alternate form is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - withData
     - withRecognition
     - withAttributes
     - withAlternateData
    """
    pass

  def getResourceApplicationData(self, authenticationToken, guid):
    """
    Get all of the application data for the Resource identified by GUID,
    with values returned within the LazyMap fullMap field.
    If there are no applicationData entries, then a LazyMap
    with an empty fullMap will be returned. If your application
    only needs to fetch its own applicationData entry, use
    getResourceApplicationDataEntry instead.

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getResourceApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Get the value of a single entry in the applicationData map
    for the Resource identified by GUID.

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - Resource not found, by GUID</li>
      <li> "ResourceAttributes.applicationData.key" - Resource not found, by key</li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    pass

  def setResourceApplicationDataEntry(self, authenticationToken, guid, key, value):
    """
    Update, or create, an entry in the applicationData map for
    the Resource identified by guid.

    Parameters:
     - authenticationToken
     - guid
     - key
     - value
    """
    pass

  def unsetResourceApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Remove an entry identified by 'key' from the applicationData map for
    the Resource identified by 'guid'.

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    pass

  def updateResource(self, authenticationToken, resource):
    """
    Submit a set of changes to a resource to the service.  This can be used
    to update the meta-data about the resource, but cannot be used to change
    the binary contents of the resource (including the length and hash).  These
    cannot be changed directly without creating a new resource and removing the
    old one via updateNote.

    @param resource
      A Resource object containing the desired fields to be populated on
      the service.  The service will attempt to update the resource with the
      following fields from the client:
      <ul>
         <li>guid:  must be provided to identify the resource
         </li>
         <li>mime
         </li>
         <li>width
         </li>
         <li>height
         </li>
         <li>duration
         </li>
         <li>attributes:  optional.  if present, the set of attributes will
              be replaced.
         </li>
      </ul>

    @return
      The Update Sequence Number of the resource after the changes have been
      applied.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - resource
    """
    pass

  def getResourceData(self, authenticationToken, guid):
    """
    Returns binary data of the resource with the provided GUID.  For
    example, if this were an image resource, this would contain the
    raw bits of the image.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getResourceByHash(self, authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData):
    """
    Returns the current state of a resource, referenced by containing
    note GUID and resource content hash.

    @param noteGuid
      The GUID of the note that holds the resource to be retrieved.

    @param contentHash
      The MD5 checksum of the resource within that note. Note that
      this is the binary checksum, for example from Resource.data.bodyHash,
      and not the hex-encoded checksum that is used within an en-media
      tag in a note body.

    @param withData
      If true, the Resource will include the binary contents of the
      'data' field's body.

    @param withRecognition
      If true, the Resource will include the binary contents of the
      'recognition' field's body.

    @param withAlternateData
      If true, the Resource will include the binary contents of the
      'alternateData' field's body, if an alternate form is present.

    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "Note.guid" - noteGuid param missing
      </li>
      <li> DATA_REQUIRED "Note.contentHash" - contentHash param missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note" - not found, by guid
      </li>
      <li> "Resource" - not found, by hash
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - contentHash
     - withData
     - withRecognition
     - withAlternateData
    """
    pass

  def getResourceRecognition(self, authenticationToken, guid):
    """
    Returns the binary contents of the recognition index for the resource
    with the provided GUID.  If the caller asks about a resource that has
    no recognition data, this will throw EDAMNotFoundException.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource whose recognition data should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
      <li> "Resource.recognition" - resource has no recognition
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getResourceAlternateData(self, authenticationToken, guid):
    """
    If the Resource with the provided GUID has an alternate data representation
    (indicated via the Resource.alternateData field), then this request can
    be used to retrieve the binary contents of that alternate data file.
    If the caller asks about a resource that has no alternate data form, this
    will throw EDAMNotFoundException.

    @param guid
       The GUID of the resource whose recognition data should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
      <li> "Resource.alternateData" - resource has no recognition
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getResourceAttributes(self, authenticationToken, guid):
    """
    Returns the set of attributes for the Resource with the provided GUID.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource whose attributes should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def getPublicNotebook(self, userId, publicUri):
    """
    <p>
    Looks for a user account with the provided userId on this NoteStore
    shard and determines whether that account contains a public notebook
    with the given URI.  If the account is not found, or no public notebook
    exists with this URI, this will throw an EDAMNotFoundException,
    otherwise this will return the information for that Notebook.
    </p>
    <p>
    If a notebook is visible on the web with a full URL like
    http://www.evernote.com/pub/sethdemo/api
    Then 'sethdemo' is the username that can be used to look up the userId,
    and 'api' is the publicUri.
    </p>

    @param userId
       The numeric identifier for the user who owns the public notebook.
       To find this value based on a username string, you can invoke
       UserStore.getPublicUserInfo

    @param publicUri
       The uri string for the public notebook, from Notebook.publishing.uri.

    @throws EDAMNotFoundException <ul>
      <li>"Publishing.uri" - not found, by URI</li>
    </ul>

    @throws EDAMSystemException <ul>
      <li> TAKEN_DOWN "PublicNotebook" - The specified public notebook is
        taken down (for all requesters).</li>
      <li> TAKEN_DOWN "Country" - The specified public notebook is taken
        down for the requester because of an IP-based country lookup.</li>
    </ul>

    Parameters:
     - userId
     - publicUri
    """
    pass

  def createSharedNotebook(self, authenticationToken, sharedNotebook):
    """
    Used to construct a shared notebook object. The constructed notebook will
    contain a "share key" which serve as a unique identifer and access token
    for a user to access the notebook of the shared notebook owner.

    @param sharedNotebook
      A shared notebook object populated with the email address of the share
      recipient, the notebook guid and the access permissions. All other
      attributes of the shared object are ignored. The SharedNotebook.allowPreview
      field must be explicitly set with either a true or false value.

    @return
      The fully populated SharedNotebook object including the server assigned
      share id and shareKey which can both be used to uniquely identify the
      SharedNotebook.

    @throws EDAMUserException <ul>
      <li>BAD_DATA_FORMAT "SharedNotebook.email" - if the email was not valid</li>
      <li>BAD_DATA_FORMAT "requireLogin" - if the SharedNotebook.allowPreview field was
          not set, and the SharedNotebook.requireLogin was also not set or was set to
          false.</li>
      <li>PERMISSION_DENIED "SharedNotebook.recipientSettings" - if
          recipientSettings is set in the sharedNotebook.  Only the recipient
          can set these values via the setSharedNotebookRecipientSettings
          method.
      </li>
      </ul>
    @throws EDAMNotFoundException <ul>
      <li>Notebook.guid - if the notebookGuid is not a valid GUID for the user.
      </li>
      </ul>

    Parameters:
     - authenticationToken
     - sharedNotebook
    """
    pass

  def updateSharedNotebook(self, authenticationToken, sharedNotebook):
    """
    Update a SharedNotebook object.

    @param authenticationToken
      Must be an authentication token from the owner or a shared notebook
      authentication token or business authentication token with sufficient
      permissions to change invitations for a notebook.

    @param sharedNotebook
     The SharedNotebook object containing the requested changes.
     The "id" of the shared notebook must be set to allow the service
     to identify the SharedNotebook to be updated. In addition, you MUST set
     the email, permission, and allowPreview fields to the desired values.
     All other fields will be ignored if set.

    @return
     The Update Serial Number for this change within the account.

    @throws EDAMUserException <ul>
      <li>UNSUPPORTED_OPERATION "updateSharedNotebook" - if this service instance does not support shared notebooks.</li>
      <li>BAD_DATA_FORMAT "SharedNotebook.email" - if the email was not valid.</li>
      <li>DATA_REQUIRED "SharedNotebook.id" - if the id field was not set.</li>
      <li>DATA_REQUIRED "SharedNotebook.privilege" - if the privilege field was not set.</li>
      <li>DATA_REQUIRED "SharedNotebook.allowPreview" - if the allowPreview field was not set.</li>
      </ul>
    @throws EDAMNotFoundException <ul>
      <li>SharedNotebook.id - if no shared notebook with the specified ID was found.
      </ul>

    Parameters:
     - authenticationToken
     - sharedNotebook
    """
    pass

  def setSharedNotebookRecipientSettings(self, authenticationToken, sharedNotebookId, recipientSettings):
    """
    Set values for the recipient settings associated with a shared notebook.  Having
    update rights to the shared notebook record itself has no effect on this call;
    only the recipient of the shared notebook can can the recipient settings.

    If you do <i>not</i> wish to, or cannot, change one of the reminderNotifyEmail or
    reminderNotifyInApp fields, you must leave that field unset in recipientSettings.
    This method will skip that field for updates and leave the existing state as
    it is.

    @return The update sequence number of the account to which the shared notebook
      belongs, which is the account from which we are sharing a notebook.

    @throws EDAMNotFoundException "sharedNotebookId" - Thrown if the service does not
      have a shared notebook record for the sharedNotebookId on the given shard.  If you
      receive this exception, it is probable that the shared notebook record has
      been revoked or expired, or that you accessed the wrong shard.

    @throws EDAMUserException <ul>
      <li>PEMISSION_DENIED "authenticationToken" - If you do not have permission to set
          the recipient settings for the shared notebook.  Only the recipient has
          permission to do this.
      <li>DATA_CONFLICT "recipientSettings.reminderNotifyEmail" - Setting whether
          or not you want to receive reminder e-mail notifications is possible on
          a business notebook in the business to which the user belongs.  All
          others can safely unset the reminderNotifyEmail field from the
          recipientSettings parameter.
    </ul>

    Parameters:
     - authenticationToken
     - sharedNotebookId
     - recipientSettings
    """
    pass

  def sendMessageToSharedNotebookMembers(self, authenticationToken, notebookGuid, messageText, recipients):
    """
    Send a reminder message to some or all of the email addresses that a notebook has been
    shared with. The message includes the current link to view the notebook.
    @param authenticationToken
      The auth token of the user with permissions to share the notebook
    @param notebookGuid
      The guid of the shared notebook
    @param messageText
     User provided text to include in the email
    @param recipients
     The email addresses of the recipients. If this list is empty then all of the
     users that the notebook has been shared with are emailed.
     If an email address doesn't correspond to share invite members then that address
     is ignored.
    @return
     The number of messages sent
    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "(recipients)" -
        The email can't be sent because this would exceed the user's daily
        email limit.
      </li>
      <li> PERMISSION_DENIED "Notebook.guid" - The user doesn't have permission to
        send a message for the specified notebook.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebookGuid
     - messageText
     - recipients
    """
    pass

  def listSharedNotebooks(self, authenticationToken):
    """
    Lists the collection of shared notebooks for all notebooks in the
    users account.

    @return
     The list of all SharedNotebooks for the user

    Parameters:
     - authenticationToken
    """
    pass

  def expungeSharedNotebooks(self, authenticationToken, sharedNotebookIds):
    """
    Expunges the SharedNotebooks in the user's account using the
    SharedNotebook.id as the identifier.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param
      sharedNotebookIds - a list of ShardNotebook.id longs identifying the
          objects to delete permanently.

    @return
      The account's update sequence number.

    Parameters:
     - authenticationToken
     - sharedNotebookIds
    """
    pass

  def createLinkedNotebook(self, authenticationToken, linkedNotebook):
    """
    Asks the service to make a linked notebook with the provided name, username
    of the owner and identifiers provided. A linked notebook can be either a
    link to a public notebook or to a private shared notebook.

    @param linkedNotebook
      The desired fields for the linked notebook must be provided on this
      object.  The name of the linked notebook must be set. Either a username
      uri or a shard id and share key must be provided otherwise a
      EDAMUserException is thrown.

    @return
      The newly created LinkedNotebook.  The server-side id will be
      saved in this object's 'id' field.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "LinkedNotebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.username" - bad username format
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.uri" -
        if public notebook set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.shareKey" -
        if private notebook set but bad shareKey
      </li>
      <li> DATA_REQUIRED "LinkedNotebook.shardId" -
        if private notebook but shard id not provided
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    pass

  def updateLinkedNotebook(self, authenticationToken, linkedNotebook):
    """
    @param linkedNotebook
      Updates the name of a linked notebook.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "LinkedNotebook.name" - invalid length or pattern
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    pass

  def listLinkedNotebooks(self, authenticationToken):
    """
    Returns a list of linked notebooks

    Parameters:
     - authenticationToken
    """
    pass

  def expungeLinkedNotebook(self, authenticationToken, guid):
    """
    Permanently expunges the linked notebook from the account.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The LinkedNotebook.guid field of the LinkedNotebook to permanently remove
      from the account.

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def authenticateToSharedNotebook(self, shareKey, authenticationToken):
    """
    Asks the service to produce an authentication token that can be used to
    access the contents of a shared notebook from someone else's account.
    This authenticationToken can be used with the various other NoteStore
    calls to find and retrieve notes, and if the permissions in the shared
    notebook are sufficient, to make changes to the contents of the notebook.

    @param shareKey
      The 'shareKey' identifier from the SharedNotebook that was granted to
      some recipient.  This string internally encodes the notebook identifier
      and a security signature.

    @param authenticationToken
      If a non-empty string is provided, this is the full user-based
      authentication token that identifies the user who is currently logged in
      and trying to access the shared notebook.  This may be required if the
      notebook was created with 'requireLogin'.
      If this string is empty, the service will attempt to authenticate to the
      shared notebook without any logged in user.

    @throws EDAMSystemException <ul>
      <li> BAD_DATA_FORMAT "shareKey" - invalid shareKey string
      </li>
      <li> INVALID_AUTH "shareKey" - bad signature on shareKey string
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SharedNotebook.id" - the shared notebook no longer exists
      </li>
    </ul>

    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "authenticationToken" - the share requires login, and
             no valid authentication token was provided.
      </li>
      <li> PERMISSION_DENIED "SharedNotebook.username" - share requires login,
             and another username has already been bound to this notebook.
      </li>
    </ul>

    Parameters:
     - shareKey
     - authenticationToken
    """
    pass

  def getSharedNotebookByAuth(self, authenticationToken):
    """
    This function is used to retrieve extended information about a shared
    notebook by a guest who has already authenticated to access that notebook.
    This requires an 'authenticationToken' parameter which should be the
    resut of a call to authenticateToSharedNotebook(...).
    I.e. this is the token that gives access to the particular shared notebook
    in someone else's account -- it's not the authenticationToken for the
    owner of the notebook itself.

    @param authenticationToken
      Should be the authentication token retrieved from the reply of
      authenticateToSharedNotebook(), proving access to a particular shared
      notebook.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "authenticationToken" -
             authentication token doesn't correspond to a valid shared notebook
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SharedNotebook.id" - the shared notebook no longer exists
      </li>
    </ul>

    Parameters:
     - authenticationToken
    """
    pass

  def emailNote(self, authenticationToken, parameters):
    """
    Attempts to send a single note to one or more email recipients.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param authenticationToken
       The note will be sent as the user logged in via this token, using that
       user's registered email address.  If the authenticated user doesn't
       have permission to read that note, the emailing will fail.

    @param parameters
       The note must be specified either by GUID (in which case it will be
       sent using the existing data in the service), or else the full Note
       must be passed to this call.  This also specifies the additional
       email fields that will be used in the email.

    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "NoteEmailParameters.toAddresses" -
        The email can't be sent because this would exceed the user's daily
        email limit.
      </li>
      <li> BAD_DATA_FORMAT "(email address)" -
        email address malformed
      </li>
      <li> DATA_REQUIRED "NoteEmailParameters.toAddresses" -
        if there are no To: or Cc: addresses provided.
      </li>
      <li> DATA_REQUIRED "Note.title" -
        if the caller provides a Note parameter with no title
      </li>
      <li> DATA_REQUIRED "Note.content" -
        if the caller provides a Note parameter with no content
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> DATA_REQUIRED "NoteEmailParameters.note" -
        if no guid or note provided
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - parameters
    """
    pass

  def shareNote(self, authenticationToken, guid):
    """
    If this note is not already shared (via its own direct URL), then this
    will start sharing that note.
    This will return the secret "Note Key" for this note that
    can currently be used in conjunction with the Note's GUID to gain direct
    read-only access to the Note.
    If the note is already shared, then this won't make any changes to the
    note, and the existing "Note Key" will be returned.  The only way to change
    the Note Key for an existing note is to stopSharingNote first, and then
    call this function.

    @param guid
      The GUID of the note to be shared.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def stopSharingNote(self, authenticationToken, guid):
    """
    If this note is not already shared then this will stop sharing that note
    and invalidate its "Note Key", so any existing URLs to access that Note
    will stop working.
    If the Note is not shared, then this function will do nothing.

    @param guid
      The GUID of the note to be un-shared.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    pass

  def authenticateToSharedNote(self, guid, noteKey, authenticationToken):
    """
    Asks the service to produce an authentication token that can be used to
    access the contents of a single Note which was individually shared
    from someone's account.
    This authenticationToken can be used with the various other NoteStore
    calls to find and retrieve the Note and its directly-referenced children.

    @param guid
      The GUID identifying this Note on this shard.

    @param noteKey
      The 'noteKey' identifier from the Note that was originally created via
      a call to shareNote() and then given to a recipient to access.

    @param authenticationToken
      An optional authenticationToken that identifies the user accessing the
      shared note. This parameter may be required to access some shared notes.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - the Note with that GUID is either not
        shared, or the noteKey doesn't match the current key for this note
      </li>
      <li> PERMISSION_DENIED "authenticationToken" - an authentication token is
        required to access this Note, but either no authentication token or a
        "non-owner" authentication token was provided.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "guid" - the note with that GUID is not found
      </li>
    </ul>

    @throws EDAMSystemException <ul>
      <li> TAKEN_DOWN "Note" - The specified shared note is taken down (for
        all requesters).
      </li>
      <li> TAKEN_DOWN "Country" - The specified shared note is taken down
        for the requester because of an IP-based country lookup.
      </ul>
    </ul>

    Parameters:
     - guid
     - noteKey
     - authenticationToken
    """
    pass

  def findRelated(self, authenticationToken, query, resultSpec):
    """
    Identify related entities on the service, such as notes,
    notebooks, and tags related to notes or content.

    @param query
      The information about which we are finding related entities.

    @param resultSpec
      Allows the client to indicate the type and quantity of
      information to be returned, allowing a saving of time and
      bandwidth.

    @return
      The result of the query, with information considered
      to likely be relevantly related to the information
      described by the query.

    @throws EDAMUserException <ul>
      <li>BAD_DATA_FORMAT "RelatedQuery.plainText" - If you provided a
        a zero-length plain text value.
      </li>
      <li>BAD_DATA_FORMAT "RelatedQuery.noteGuid" - If you provided an
        invalid Note GUID, that is, one that does not match the constraints
        defined by EDAM_GUID_LEN_MIN, EDAM_GUID_LEN_MAX, EDAM_GUID_REGEX.
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>
      <li>PERMISSION_DENIED "Note" - If the caller does not have access to
        the note identified by RelatedQuery.noteGuid.
      </li>
      <li>DATA_REQUIRED "RelatedResultSpec" - If you did not not set any values
        in the result spec.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li>"RelatedQuery.noteGuid" - the note with that GUID is not
        found, if that field has been set in the query.
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - query
     - resultSpec
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def getSyncState(self, authenticationToken):
    """
    Asks the NoteStore to provide information about the status of the user
    account corresponding to the provided authentication token.

    Parameters:
     - authenticationToken
    """
    self.send_getSyncState(authenticationToken)
    return self.recv_getSyncState()

  def send_getSyncState(self, authenticationToken):
    self._oprot.writeMessageBegin('getSyncState', TMessageType.CALL, self._seqid)
    args = getSyncState_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSyncState(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSyncState_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSyncState failed: unknown result");

  def getSyncStateWithMetrics(self, authenticationToken, clientMetrics):
    """
    Asks the NoteStore to provide information about the status of the user
    account corresponding to the provided authentication token.
    This version of 'getSyncState' allows the client to upload coarse-
    grained usage metrics to the service.

    @param clientMetrics  see the documentation of the ClientUsageMetrics
      structure for an explanation of the fields that clients can pass to
      the service.

    Parameters:
     - authenticationToken
     - clientMetrics
    """
    self.send_getSyncStateWithMetrics(authenticationToken, clientMetrics)
    return self.recv_getSyncStateWithMetrics()

  def send_getSyncStateWithMetrics(self, authenticationToken, clientMetrics):
    self._oprot.writeMessageBegin('getSyncStateWithMetrics', TMessageType.CALL, self._seqid)
    args = getSyncStateWithMetrics_args()
    args.authenticationToken = authenticationToken
    args.clientMetrics = clientMetrics
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSyncStateWithMetrics(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSyncStateWithMetrics_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSyncStateWithMetrics failed: unknown result");

  def getSyncChunk(self, authenticationToken, afterUSN, maxEntries, fullSyncOnly):
    """
    DEPRECATED - use getFilteredSyncChunk.

    Parameters:
     - authenticationToken
     - afterUSN
     - maxEntries
     - fullSyncOnly
    """
    self.send_getSyncChunk(authenticationToken, afterUSN, maxEntries, fullSyncOnly)
    return self.recv_getSyncChunk()

  def send_getSyncChunk(self, authenticationToken, afterUSN, maxEntries, fullSyncOnly):
    self._oprot.writeMessageBegin('getSyncChunk', TMessageType.CALL, self._seqid)
    args = getSyncChunk_args()
    args.authenticationToken = authenticationToken
    args.afterUSN = afterUSN
    args.maxEntries = maxEntries
    args.fullSyncOnly = fullSyncOnly
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSyncChunk(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSyncChunk_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSyncChunk failed: unknown result");

  def getFilteredSyncChunk(self, authenticationToken, afterUSN, maxEntries, filter):
    """
    Asks the NoteStore to provide the state of the account in order of
    last modification.  This request retrieves one block of the server's
    state so that a client can make several small requests against a large
    account rather than getting the entire state in one big message.
    This call gives fine-grained control of the data that will
    be received by a client by omitting data elements that a client doesn't
    need. This may reduce network traffic and sync times.

    @param afterUSN
      The client can pass this value to ask only for objects that
      have been updated after a certain point.  This allows the client to
      receive updates after its last checkpoint rather than doing a full
      synchronization on every pass.  The default value of "0" indicates
      that the client wants to get objects from the start of the account.

    @param maxEntries
      The maximum number of modified objects that should be
      returned in the result SyncChunk.  This can be used to limit the size
      of each individual message to be friendly for network transfer.

    @param filter
      The caller must set some of the flags in this structure to specify which
      data types should be returned during the synchronization.  See
      the SyncChunkFilter structure for information on each flag.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "afterUSN" - if negative
      </li>
      <li> BAD_DATA_FORMAT "maxEntries" - if less than 1
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - afterUSN
     - maxEntries
     - filter
    """
    self.send_getFilteredSyncChunk(authenticationToken, afterUSN, maxEntries, filter)
    return self.recv_getFilteredSyncChunk()

  def send_getFilteredSyncChunk(self, authenticationToken, afterUSN, maxEntries, filter):
    self._oprot.writeMessageBegin('getFilteredSyncChunk', TMessageType.CALL, self._seqid)
    args = getFilteredSyncChunk_args()
    args.authenticationToken = authenticationToken
    args.afterUSN = afterUSN
    args.maxEntries = maxEntries
    args.filter = filter
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getFilteredSyncChunk(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getFilteredSyncChunk_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getFilteredSyncChunk failed: unknown result");

  def getLinkedNotebookSyncState(self, authenticationToken, linkedNotebook):
    """
    Asks the NoteStore to provide information about the status of a linked
    notebook that has been shared with the caller, or that is public to the
    world.
    This will return a result that is similar to getSyncState, but may omit
    SyncState.uploaded if the caller doesn't have permission to write to
    the linked notebook.

    This function must be called on the shard that owns the referenced
    notebook.  (I.e. the shardId in /shard/shardId/edam/note must be the
    same as LinkedNotebook.shardId.)

    @param authenticationToken
      This should be an authenticationToken for the guest who has received
      the invitation to the share.  (I.e. this should not be the result of
      NoteStore.authenticateToSharedNotebook)

    @param linkedNotebook
      This structure should contain identifying information and permissions
      to access the notebook in question.

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    self.send_getLinkedNotebookSyncState(authenticationToken, linkedNotebook)
    return self.recv_getLinkedNotebookSyncState()

  def send_getLinkedNotebookSyncState(self, authenticationToken, linkedNotebook):
    self._oprot.writeMessageBegin('getLinkedNotebookSyncState', TMessageType.CALL, self._seqid)
    args = getLinkedNotebookSyncState_args()
    args.authenticationToken = authenticationToken
    args.linkedNotebook = linkedNotebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getLinkedNotebookSyncState(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getLinkedNotebookSyncState_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getLinkedNotebookSyncState failed: unknown result");

  def getLinkedNotebookSyncChunk(self, authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly):
    """
    Asks the NoteStore to provide information about the contents of a linked
    notebook that has been shared with the caller, or that is public to the
    world.
    This will return a result that is similar to getSyncChunk, but will only
    contain entries that are visible to the caller.  I.e. only that particular
    Notebook will be visible, along with its Notes, and Tags on those Notes.

    This function must be called on the shard that owns the referenced
    notebook.  (I.e. the shardId in /shard/shardId/edam/note must be the
    same as LinkedNotebook.shardId.)

    @param authenticationToken
      This should be an authenticationToken for the guest who has received
      the invitation to the share.  (I.e. this should not be the result of
      NoteStore.authenticateToSharedNotebook)

    @param linkedNotebook
      This structure should contain identifying information and permissions
      to access the notebook in question.  This must contain the valid fields
      for either a shared notebook (e.g. shareKey)
      or a public notebook (e.g. username, uri)

    @param afterUSN
      The client can pass this value to ask only for objects that
      have been updated after a certain point.  This allows the client to
      receive updates after its last checkpoint rather than doing a full
      synchronization on every pass.  The default value of "0" indicates
      that the client wants to get objects from the start of the account.

    @param maxEntries
      The maximum number of modified objects that should be
      returned in the result SyncChunk.  This can be used to limit the size
      of each individual message to be friendly for network transfer.
      Applications should not request more than 256 objects at a time,
      and must handle the case where the service returns less than the
      requested number of objects in a given request even though more
      objects are available on the service.

    @param fullSyncOnly
      If true, then the client only wants initial data for a full sync.
      In this case, the service will not return any expunged objects,
      and will not return any Resources, since these are also provided
      in their corresponding Notes.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "afterUSN" - if negative
      </li>
      <li> BAD_DATA_FORMAT "maxEntries" - if less than 1
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "LinkedNotebook" - if the provided information doesn't match any
        valid notebook
      </li>
      <li> "LinkedNotebook.uri" - if the provided public URI doesn't match any
        valid notebook
      </li>
      <li> "SharedNotebook.id" - if the provided information indicates a
         shared notebook that no longer exists
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
     - afterUSN
     - maxEntries
     - fullSyncOnly
    """
    self.send_getLinkedNotebookSyncChunk(authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly)
    return self.recv_getLinkedNotebookSyncChunk()

  def send_getLinkedNotebookSyncChunk(self, authenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly):
    self._oprot.writeMessageBegin('getLinkedNotebookSyncChunk', TMessageType.CALL, self._seqid)
    args = getLinkedNotebookSyncChunk_args()
    args.authenticationToken = authenticationToken
    args.linkedNotebook = linkedNotebook
    args.afterUSN = afterUSN
    args.maxEntries = maxEntries
    args.fullSyncOnly = fullSyncOnly
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getLinkedNotebookSyncChunk(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getLinkedNotebookSyncChunk_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getLinkedNotebookSyncChunk failed: unknown result");

  def listNotebooks(self, authenticationToken):
    """
    Returns a list of all of the notebooks in the account.

    Parameters:
     - authenticationToken
    """
    self.send_listNotebooks(authenticationToken)
    return self.recv_listNotebooks()

  def send_listNotebooks(self, authenticationToken):
    self._oprot.writeMessageBegin('listNotebooks', TMessageType.CALL, self._seqid)
    args = listNotebooks_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listNotebooks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listNotebooks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listNotebooks failed: unknown result");

  def getNotebook(self, authenticationToken, guid):
    """
    Returns the current state of the notebook with the provided GUID.
    The notebook may be active or deleted (but not expunged).

    @param guid
      The GUID of the notebook to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Notebook" - private notebook, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getNotebook(authenticationToken, guid)
    return self.recv_getNotebook()

  def send_getNotebook(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getNotebook', TMessageType.CALL, self._seqid)
    args = getNotebook_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNotebook failed: unknown result");

  def getDefaultNotebook(self, authenticationToken):
    """
    Returns the notebook that should be used to store new notes in the
    user's account when no other notebooks are specified.

    Parameters:
     - authenticationToken
    """
    self.send_getDefaultNotebook(authenticationToken)
    return self.recv_getDefaultNotebook()

  def send_getDefaultNotebook(self, authenticationToken):
    self._oprot.writeMessageBegin('getDefaultNotebook', TMessageType.CALL, self._seqid)
    args = getDefaultNotebook_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getDefaultNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getDefaultNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getDefaultNotebook failed: unknown result");

  def createNotebook(self, authenticationToken, notebook):
    """
    Asks the service to make a notebook with the provided name.

    @param notebook
      The desired fields for the notebook must be provided on this
      object.  The name of the notebook must be set, and either the 'active'
      or 'defaultNotebook' fields may be set by the client at creation.
      If a notebook exists in the account with the same name (via
      case-insensitive compare), this will throw an EDAMUserException.

    @return
      The newly created Notebook.  The server-side GUID will be
      saved in this object's 'guid' field.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Notebook.stack" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Publishing.uri" - if publishing set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "Publishing.publicDescription" - if too long
      </li>
      <li> DATA_CONFLICT "Notebook.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Publishing.uri" - if URI already in use
      </li>
      <li> DATA_REQUIRED "Publishing.uri" - if publishing set but uri missing
      </li>
      <li> LIMIT_REACHED "Notebook" - at max number of notebooks
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebook
    """
    self.send_createNotebook(authenticationToken, notebook)
    return self.recv_createNotebook()

  def send_createNotebook(self, authenticationToken, notebook):
    self._oprot.writeMessageBegin('createNotebook', TMessageType.CALL, self._seqid)
    args = createNotebook_args()
    args.authenticationToken = authenticationToken
    args.notebook = notebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createNotebook failed: unknown result");

  def updateNotebook(self, authenticationToken, notebook):
    """
    Submits notebook changes to the service.  The provided data must include
    the notebook's guid field for identification.

    @param notebook
      The notebook object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Notebook.stack" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Publishing.uri" - if publishing set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "Publishing.publicDescription" - if too long
      </li>
      <li> DATA_CONFLICT "Notebook.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Publishing.uri" - if URI already in use
      </li>
      <li> DATA_REQUIRED "Publishing.uri" - if publishing set but uri missing
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebook
    """
    self.send_updateNotebook(authenticationToken, notebook)
    return self.recv_updateNotebook()

  def send_updateNotebook(self, authenticationToken, notebook):
    self._oprot.writeMessageBegin('updateNotebook', TMessageType.CALL, self._seqid)
    args = updateNotebook_args()
    args.authenticationToken = authenticationToken
    args.notebook = notebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateNotebook failed: unknown result");

  def expungeNotebook(self, authenticationToken, guid):
    """
    Permanently removes the notebook from the user's account.
    After this action, the notebook is no longer available for undeletion, etc.
    If the notebook contains any Notes, they will be moved to the current
    default notebook and moved into the trash (i.e. Note.active=false).
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the notebook to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Notebook.guid" - if the parameter is missing
      </li>
      <li> LIMIT_REACHED "Notebook" - trying to expunge the last Notebook
      </li>
      <li> PERMISSION_DENIED "Notebook" - private notebook, user doesn't own
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_expungeNotebook(authenticationToken, guid)
    return self.recv_expungeNotebook()

  def send_expungeNotebook(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('expungeNotebook', TMessageType.CALL, self._seqid)
    args = expungeNotebook_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeNotebook failed: unknown result");

  def listTags(self, authenticationToken):
    """
    Returns a list of the tags in the account.  Evernote does not support
    the undeletion of tags, so this will only include active tags.

    Parameters:
     - authenticationToken
    """
    self.send_listTags(authenticationToken)
    return self.recv_listTags()

  def send_listTags(self, authenticationToken):
    self._oprot.writeMessageBegin('listTags', TMessageType.CALL, self._seqid)
    args = listTags_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listTags(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listTags_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listTags failed: unknown result");

  def listTagsByNotebook(self, authenticationToken, notebookGuid):
    """
    Returns a list of the tags that are applied to at least one note within
    the provided notebook.  If the notebook is public, the authenticationToken
    may be ignored.

    @param notebookGuid
       the GUID of the notebook to use to find tags

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - notebook not found by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebookGuid
    """
    self.send_listTagsByNotebook(authenticationToken, notebookGuid)
    return self.recv_listTagsByNotebook()

  def send_listTagsByNotebook(self, authenticationToken, notebookGuid):
    self._oprot.writeMessageBegin('listTagsByNotebook', TMessageType.CALL, self._seqid)
    args = listTagsByNotebook_args()
    args.authenticationToken = authenticationToken
    args.notebookGuid = notebookGuid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listTagsByNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listTagsByNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listTagsByNotebook failed: unknown result");

  def getTag(self, authenticationToken, guid):
    """
    Returns the current state of the Tag with the provided GUID.

    @param guid
      The GUID of the tag to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - private Tag, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getTag(authenticationToken, guid)
    return self.recv_getTag()

  def send_getTag(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getTag', TMessageType.CALL, self._seqid)
    args = getTag_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTag(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTag_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTag failed: unknown result");

  def createTag(self, authenticationToken, tag):
    """
    Asks the service to make a tag with a set of information.

    @param tag
      The desired list of fields for the tag are specified in this
      object.  The caller must specify the tag name, and may provide
      the parentGUID.

    @return
      The newly created Tag.  The server-side GUID will be
      saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Tag.parentGuid" - malformed GUID
      </li>
      <li> DATA_CONFLICT "Tag.name" - name already in use
      </li>
      <li> LIMIT_REACHED "Tag" - at max number of tags
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.parentGuid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - tag
    """
    self.send_createTag(authenticationToken, tag)
    return self.recv_createTag()

  def send_createTag(self, authenticationToken, tag):
    self._oprot.writeMessageBegin('createTag', TMessageType.CALL, self._seqid)
    args = createTag_args()
    args.authenticationToken = authenticationToken
    args.tag = tag
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createTag(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createTag_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createTag failed: unknown result");

  def updateTag(self, authenticationToken, tag):
    """
    Submits tag changes to the service.  The provided data must include
    the tag's guid field for identification.  The service will apply
    updates to the following tag fields:  name, parentGuid

    @param tag
      The tag object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Tag.parentGuid" - malformed GUID
      </li>
      <li> DATA_CONFLICT "Tag.name" - name already in use
      </li>
      <li> DATA_CONFLICT "Tag.parentGuid" - can't set parent: circular
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
      <li> "Tag.parentGuid" - parent not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - tag
    """
    self.send_updateTag(authenticationToken, tag)
    return self.recv_updateTag()

  def send_updateTag(self, authenticationToken, tag):
    self._oprot.writeMessageBegin('updateTag', TMessageType.CALL, self._seqid)
    args = updateTag_args()
    args.authenticationToken = authenticationToken
    args.tag = tag
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateTag(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateTag_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateTag failed: unknown result");

  def untagAll(self, authenticationToken, guid):
    """
    Removes the provided tag from every note that is currently tagged with
    this tag.  If this operation is successful, the tag will still be in
    the account, but it will not be tagged on any notes.

    This function is not indended for use by full synchronizing clients, since
    it does not provide enough result information to the client to reconcile
    the local state without performing a follow-up sync from the service.  This
    is intended for "thin clients" that need to efficiently support this as
    a UI operation.

    @param guid
      The GUID of the tag to remove from all notes.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the guid parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_untagAll(authenticationToken, guid)
    self.recv_untagAll()

  def send_untagAll(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('untagAll', TMessageType.CALL, self._seqid)
    args = untagAll_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_untagAll(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = untagAll_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    return

  def expungeTag(self, authenticationToken, guid):
    """
    Permanently deletes the tag with the provided GUID, if present.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the tag to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Tag.guid" - if the guid parameter is missing
      </li>
      <li> PERMISSION_DENIED "Tag" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Tag.guid" - tag not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_expungeTag(authenticationToken, guid)
    return self.recv_expungeTag()

  def send_expungeTag(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('expungeTag', TMessageType.CALL, self._seqid)
    args = expungeTag_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeTag(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeTag_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeTag failed: unknown result");

  def listSearches(self, authenticationToken):
    """
    Returns a list of the searches in the account.  Evernote does not support
    the undeletion of searches, so this will only include active searches.

    Parameters:
     - authenticationToken
    """
    self.send_listSearches(authenticationToken)
    return self.recv_listSearches()

  def send_listSearches(self, authenticationToken):
    self._oprot.writeMessageBegin('listSearches', TMessageType.CALL, self._seqid)
    args = listSearches_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listSearches(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listSearches_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listSearches failed: unknown result");

  def getSearch(self, authenticationToken, guid):
    """
    Returns the current state of the search with the provided GUID.

    @param guid
      The GUID of the search to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - private Tag, user doesn't own
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getSearch(authenticationToken, guid)
    return self.recv_getSearch()

  def send_getSearch(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getSearch', TMessageType.CALL, self._seqid)
    args = getSearch_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSearch(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSearch_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSearch failed: unknown result");

  def createSearch(self, authenticationToken, search):
    """
    Asks the service to make a saved search with a set of information.

    @param search
      The desired list of fields for the search are specified in this
      object. The caller must specify the name and query for the
      search, and may optionally specify a search scope.
      The SavedSearch.format field is ignored by the service.

    @return
      The newly created SavedSearch.  The server-side GUID will be
      saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "SavedSearch.query" - invalid length
      </li>
      <li> DATA_CONFLICT "SavedSearch.name" - name already in use
      </li>
      <li> LIMIT_REACHED "SavedSearch" - at max number of searches
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - search
    """
    self.send_createSearch(authenticationToken, search)
    return self.recv_createSearch()

  def send_createSearch(self, authenticationToken, search):
    self._oprot.writeMessageBegin('createSearch', TMessageType.CALL, self._seqid)
    args = createSearch_args()
    args.authenticationToken = authenticationToken
    args.search = search
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createSearch(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createSearch_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createSearch failed: unknown result");

  def updateSearch(self, authenticationToken, search):
    """
    Submits search changes to the service. The provided data must include
    the search's guid field for identification. The service will apply
    updates to the following search fields: name, query, and scope.

    @param search
      The search object containing the requested changes.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "SavedSearch.query" - invalid length
      </li>
      <li> DATA_CONFLICT "SavedSearch.name" - name already in use
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - user doesn't own tag
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - search
    """
    self.send_updateSearch(authenticationToken, search)
    return self.recv_updateSearch()

  def send_updateSearch(self, authenticationToken, search):
    self._oprot.writeMessageBegin('updateSearch', TMessageType.CALL, self._seqid)
    args = updateSearch_args()
    args.authenticationToken = authenticationToken
    args.search = search
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateSearch(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateSearch_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateSearch failed: unknown result");

  def expungeSearch(self, authenticationToken, guid):
    """
    Permanently deletes the saved search with the provided GUID, if present.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the search to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "SavedSearch.guid" - if the guid parameter is empty
      </li>
      <li> PERMISSION_DENIED "SavedSearch" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SavedSearch.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_expungeSearch(authenticationToken, guid)
    return self.recv_expungeSearch()

  def send_expungeSearch(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('expungeSearch', TMessageType.CALL, self._seqid)
    args = expungeSearch_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeSearch(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeSearch_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeSearch failed: unknown result");

  def findNotes(self, authenticationToken, filter, offset, maxNotes):
    """
    DEPRECATED. Use findNotesMetadata.

    Parameters:
     - authenticationToken
     - filter
     - offset
     - maxNotes
    """
    self.send_findNotes(authenticationToken, filter, offset, maxNotes)
    return self.recv_findNotes()

  def send_findNotes(self, authenticationToken, filter, offset, maxNotes):
    self._oprot.writeMessageBegin('findNotes', TMessageType.CALL, self._seqid)
    args = findNotes_args()
    args.authenticationToken = authenticationToken
    args.filter = filter
    args.offset = offset
    args.maxNotes = maxNotes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findNotes(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = findNotes_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findNotes failed: unknown result");

  def findNoteOffset(self, authenticationToken, filter, guid):
    """
    Finds the position of a note within a sorted subset of all of the user's
    notes. This may be useful for thin clients that are displaying a paginated
    listing of a large account, which need to know where a particular note
    sits in the list without retrieving all notes first.

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The list of criteria that will constrain the notes to be returned.

    @param guid
      The GUID of the note to be retrieved.

    @return
      If the note with the provided GUID is found within the matching note
      list, this will return the offset of that note within that list (where
      the first offset is 0).  If the note is not found within the set of
      notes, this will return -1.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "offset" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "maxNotes" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - guid
    """
    self.send_findNoteOffset(authenticationToken, filter, guid)
    return self.recv_findNoteOffset()

  def send_findNoteOffset(self, authenticationToken, filter, guid):
    self._oprot.writeMessageBegin('findNoteOffset', TMessageType.CALL, self._seqid)
    args = findNoteOffset_args()
    args.authenticationToken = authenticationToken
    args.filter = filter
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findNoteOffset(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = findNoteOffset_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findNoteOffset failed: unknown result");

  def findNotesMetadata(self, authenticationToken, filter, offset, maxNotes, resultSpec):
    """
    Used to find the high-level information about a set of the notes from a
    user's account based on various criteria specified via a NoteFilter object.
    <p/>
    Web applications that wish to periodically check for new content in a user's
    Evernote account should consider using webhooks instead of polling this API.
    See http://dev.evernote.com/documentation/cloud/chapters/polling_notification.php
    for more information.

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The list of criteria that will constrain the notes to be returned.

    @param offset
      The numeric index of the first note to show within the sorted
      results.  The numbering scheme starts with "0".  This can be used for
      pagination.

    @param maxNotes
      The mximum notes to return in this query.  The service will return a set
      of notes that is no larger than this number, but may return fewer notes
      if needed.  The NoteList.totalNotes field in the return value will
      indicate whether there are more values available after the returned set.

    @param resultSpec
      This specifies which information should be returned for each matching
      Note. The fields on this structure can be used to eliminate data that
      the client doesn't need, which will reduce the time and bandwidth
      to receive and process the reply.

    @return
      The list of notes that match the criteria.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "offset" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "maxNotes" - not between 0 and EDAM_USER_NOTES_MAX
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - offset
     - maxNotes
     - resultSpec
    """
    self.send_findNotesMetadata(authenticationToken, filter, offset, maxNotes, resultSpec)
    return self.recv_findNotesMetadata()

  def send_findNotesMetadata(self, authenticationToken, filter, offset, maxNotes, resultSpec):
    self._oprot.writeMessageBegin('findNotesMetadata', TMessageType.CALL, self._seqid)
    args = findNotesMetadata_args()
    args.authenticationToken = authenticationToken
    args.filter = filter
    args.offset = offset
    args.maxNotes = maxNotes
    args.resultSpec = resultSpec
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findNotesMetadata(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = findNotesMetadata_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findNotesMetadata failed: unknown result");

  def findNoteCounts(self, authenticationToken, filter, withTrash):
    """
    This function is used to determine how many notes are found for each
    notebook and tag in the user's account, given a current set of filter
    parameters that determine the current selection.  This function will
    return a structure that gives the note count for each notebook and tag
    that has at least one note under the requested filter.  Any notebook or
    tag that has zero notes in the filtered set will not be listed in the
    reply to this function (so they can be assumed to be 0).

    @param authenticationToken
      Must be a valid token for the user's account unless the NoteFilter
      'notebookGuid' is the GUID of a public notebook.

    @param filter
      The note selection filter that is currently being applied.  The note
      counts are to be calculated with this filter applied to the total set
      of notes in the user's account.

    @param withTrash
      If true, then the NoteCollectionCounts.trashCount will be calculated
      and supplied in the reply. Otherwise, the trash value will be omitted.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - filter
     - withTrash
    """
    self.send_findNoteCounts(authenticationToken, filter, withTrash)
    return self.recv_findNoteCounts()

  def send_findNoteCounts(self, authenticationToken, filter, withTrash):
    self._oprot.writeMessageBegin('findNoteCounts', TMessageType.CALL, self._seqid)
    args = findNoteCounts_args()
    args.authenticationToken = authenticationToken
    args.filter = filter
    args.withTrash = withTrash
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findNoteCounts(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = findNoteCounts_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findNoteCounts failed: unknown result");

  def getNote(self, authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    """
    Returns the current state of the note in the service with the provided
    GUID.  The ENML contents of the note will only be provided if the
    'withContent' parameter is true.  The service will include the meta-data
    for each resource in the note, but the binary contents of the resources
    and their recognition data will be omitted.
    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).  The applicationData
    fields are returned as keysOnly.

    @param guid
      The GUID of the note to be retrieved.

    @param withContent
      If true, the note will include the ENML contents of its
      'content' field.

    @param withResourcesData
      If true, any Resource elements in this Note will include the binary
      contents of their 'data' field's body.

    @param withResourcesRecognition
      If true, any Resource elements will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withResourcesAlternateData
      If true, any Resource elements in this Note will include the binary
      contents of their 'alternateData' fields' body, if an alternate form
      is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - withContent
     - withResourcesData
     - withResourcesRecognition
     - withResourcesAlternateData
    """
    self.send_getNote(authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData)
    return self.recv_getNote()

  def send_getNote(self, authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    self._oprot.writeMessageBegin('getNote', TMessageType.CALL, self._seqid)
    args = getNote_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.withContent = withContent
    args.withResourcesData = withResourcesData
    args.withResourcesRecognition = withResourcesRecognition
    args.withResourcesAlternateData = withResourcesAlternateData
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNote failed: unknown result");

  def getNoteApplicationData(self, authenticationToken, guid):
    """
    Get all of the application data for the note identified by GUID,
    with values returned within the LazyMap fullMap field.
    If there are no applicationData entries, then a LazyMap
    with an empty fullMap will be returned. If your application
    only needs to fetch its own applicationData entry, use
    getNoteApplicationDataEntry instead.

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getNoteApplicationData(authenticationToken, guid)
    return self.recv_getNoteApplicationData()

  def send_getNoteApplicationData(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getNoteApplicationData', TMessageType.CALL, self._seqid)
    args = getNoteApplicationData_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteApplicationData(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteApplicationData_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteApplicationData failed: unknown result");

  def getNoteApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Get the value of a single entry in the applicationData map
    for the note identified by GUID.

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - note not found, by GUID</li>
      <li> "NoteAttributes.applicationData.key" - note not found, by key</li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    self.send_getNoteApplicationDataEntry(authenticationToken, guid, key)
    return self.recv_getNoteApplicationDataEntry()

  def send_getNoteApplicationDataEntry(self, authenticationToken, guid, key):
    self._oprot.writeMessageBegin('getNoteApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = getNoteApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteApplicationDataEntry failed: unknown result");

  def setNoteApplicationDataEntry(self, authenticationToken, guid, key, value):
    """
    Update, or create, an entry in the applicationData map for
    the note identified by guid.

    Parameters:
     - authenticationToken
     - guid
     - key
     - value
    """
    self.send_setNoteApplicationDataEntry(authenticationToken, guid, key, value)
    return self.recv_setNoteApplicationDataEntry()

  def send_setNoteApplicationDataEntry(self, authenticationToken, guid, key, value):
    self._oprot.writeMessageBegin('setNoteApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = setNoteApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.value = value
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setNoteApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setNoteApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "setNoteApplicationDataEntry failed: unknown result");

  def unsetNoteApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Remove an entry identified by 'key' from the applicationData map for
    the note identified by 'guid'. Silently ignores an unset of a
    non-existing key.

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    self.send_unsetNoteApplicationDataEntry(authenticationToken, guid, key)
    return self.recv_unsetNoteApplicationDataEntry()

  def send_unsetNoteApplicationDataEntry(self, authenticationToken, guid, key):
    self._oprot.writeMessageBegin('unsetNoteApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = unsetNoteApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_unsetNoteApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = unsetNoteApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "unsetNoteApplicationDataEntry failed: unknown result");

  def getNoteContent(self, authenticationToken, guid):
    """
    Returns XHTML contents of the note with the provided GUID.
    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the note to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getNoteContent(authenticationToken, guid)
    return self.recv_getNoteContent()

  def send_getNoteContent(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getNoteContent', TMessageType.CALL, self._seqid)
    args = getNoteContent_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteContent(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteContent_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteContent failed: unknown result");

  def getNoteSearchText(self, authenticationToken, guid, noteOnly, tokenizeForIndexing):
    """
    Returns a block of the extracted plain text contents of the note with the
    provided GUID.  This text can be indexed for search purposes by a light
    client that doesn't have capabilities to extract all of the searchable
    text content from the note and its resources.

    If the Note is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the note to be retrieved.

    @param noteOnly
      If true, this will only return the text extracted from the ENML contents
      of the note itself.  If false, this will also include the extracted text
      from any text-bearing resources (PDF, recognized images)

    @param tokenizeForIndexing
      If true, this will break the text into cleanly separated and sanitized
      tokens.  If false, this will return the more raw text extraction, with
      its original punctuation, capitalization, spacing, etc.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - noteOnly
     - tokenizeForIndexing
    """
    self.send_getNoteSearchText(authenticationToken, guid, noteOnly, tokenizeForIndexing)
    return self.recv_getNoteSearchText()

  def send_getNoteSearchText(self, authenticationToken, guid, noteOnly, tokenizeForIndexing):
    self._oprot.writeMessageBegin('getNoteSearchText', TMessageType.CALL, self._seqid)
    args = getNoteSearchText_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.noteOnly = noteOnly
    args.tokenizeForIndexing = tokenizeForIndexing
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteSearchText(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteSearchText_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteSearchText failed: unknown result");

  def getResourceSearchText(self, authenticationToken, guid):
    """
    Returns a block of the extracted plain text contents of the resource with
    the provided GUID.  This text can be indexed for search purposes by a light
    client that doesn't have capability to extract all of the searchable
    text content from a resource.

    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceSearchText(authenticationToken, guid)
    return self.recv_getResourceSearchText()

  def send_getResourceSearchText(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceSearchText', TMessageType.CALL, self._seqid)
    args = getResourceSearchText_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceSearchText(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceSearchText_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceSearchText failed: unknown result");

  def getNoteTagNames(self, authenticationToken, guid):
    """
    Returns a list of the names of the tags for the note with the provided
    guid.  This can be used with authentication to get the tags for a
    user's own note, or can be used without valid authentication to retrieve
    the names of the tags for a note in a public notebook.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getNoteTagNames(authenticationToken, guid)
    return self.recv_getNoteTagNames()

  def send_getNoteTagNames(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getNoteTagNames', TMessageType.CALL, self._seqid)
    args = getNoteTagNames_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteTagNames(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteTagNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteTagNames failed: unknown result");

  def createNote(self, authenticationToken, note):
    """
    Asks the service to make a note with the provided set of information.

    @param note
      A Note object containing the desired fields to be populated on
      the service.

    @return
      The newly created Note from the service.  The server-side
      GUIDs for the Note and any Resources will be saved in this object.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.title" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Note.content" - invalid length for ENML content
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> BAD_DATA_FORMAT "NoteAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> DATA_CONFLICT "Note.deleted" - deleted time set on active note
      </li>
      <li> DATA_REQUIRED "Resource.data" - resource data body missing
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> LIMIT_REACHED "Note" - at max number per account
      </li>
      <li> LIMIT_REACHED "Note.size" - total note size too large
      </li>
      <li> LIMIT_REACHED "Note.resources" - too many resources on Note
      </li>
      <li> LIMIT_REACHED "Note.tagGuids" - too many Tags on Note
      </li>
      <li> LIMIT_REACHED "Resource.data.size" - resource too large
      </li>
      <li> LIMIT_REACHED "NoteAttribute.*" - attribute string too long
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Note.notebookGuid" - NB not owned by user
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
      <li> BAD_DATA_FORMAT "Tag.name" - Note.tagNames was provided, and one
        of the specified tags had an invalid length or pattern
      </li>
      <li> LIMIT_REACHED "Tag" - Note.tagNames was provided, and the required
        new tags would exceed the maximum number per account
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.notebookGuid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - note
    """
    self.send_createNote(authenticationToken, note)
    return self.recv_createNote()

  def send_createNote(self, authenticationToken, note):
    self._oprot.writeMessageBegin('createNote', TMessageType.CALL, self._seqid)
    args = createNote_args()
    args.authenticationToken = authenticationToken
    args.note = note
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createNote failed: unknown result");

  def updateNote(self, authenticationToken, note):
    """
    Submit a set of changes to a note to the service.  The provided data
    must include the note's guid field for identification. The note's
    title must also be set.

    @param note
      A Note object containing the desired fields to be populated on
      the service. With the exception of the note's title and guid, fields
      that are not being changed do not need to be set. If the content is not
      being modified, note.content should be left unset. If the list of
      resources is not being modified, note.resources should be left unset.

    @return
      The metadata (no contents) for the Note on the server after the update

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.title" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "Note.content" - invalid length for ENML body
      </li>
      <li> BAD_DATA_FORMAT "NoteAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> DATA_CONFLICT "Note.deleted" - deleted time set on active note
      </li>
      <li> DATA_REQUIRED "Resource.data" - resource data body missing
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> LIMIT_REACHED "Note.tagGuids" - too many Tags on Note
      </li>
      <li> LIMIT_REACHED "Note.resources" - too many resources on Note
      </li>
      <li> LIMIT_REACHED "Note.size" - total note size too large
      </li>
      <li> LIMIT_REACHED "Resource.data.size" - resource too large
      </li>
      <li> LIMIT_REACHED "NoteAttribute.*" - attribute string too long
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
      <li> PERMISSION_DENIED "Note.notebookGuid" - user doesn't own destination
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
      <li> BAD_DATA_FORMAT "Tag.name" - Note.tagNames was provided, and one
        of the specified tags had an invalid length or pattern
      </li>
      <li> LIMIT_REACHED "Tag" - Note.tagNames was provided, and the required
        new tags would exceed the maximum number per account
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - note not found, by GUID
      </li>
      <li> "Note.notebookGuid" - if notebookGuid provided, but not found
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - note
    """
    self.send_updateNote(authenticationToken, note)
    return self.recv_updateNote()

  def send_updateNote(self, authenticationToken, note):
    self._oprot.writeMessageBegin('updateNote', TMessageType.CALL, self._seqid)
    args = updateNote_args()
    args.authenticationToken = authenticationToken
    args.note = note
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateNote failed: unknown result");

  def deleteNote(self, authenticationToken, guid):
    """
    Moves the note into the trash. The note may still be undeleted, unless it
    is expunged.  This is equivalent to calling updateNote() after setting
    Note.active = false

    @param guid
      The GUID of the note to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't have permission to
             update the note.
      </li>
    </ul>

    @throws EDAMUserException <ul>
      <li> DATA_CONFLICT "Note.guid" - the note is already deleted
      </li>
    </ul>
    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_deleteNote(authenticationToken, guid)
    return self.recv_deleteNote()

  def send_deleteNote(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('deleteNote', TMessageType.CALL, self._seqid)
    args = deleteNote_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "deleteNote failed: unknown result");

  def expungeNote(self, authenticationToken, guid):
    """
    Permanently removes a Note, and all of its Resources,
    from the service.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The GUID of the note to delete.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_expungeNote(authenticationToken, guid)
    return self.recv_expungeNote()

  def send_expungeNote(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('expungeNote', TMessageType.CALL, self._seqid)
    args = expungeNote_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeNote failed: unknown result");

  def expungeNotes(self, authenticationToken, noteGuids):
    """
    Permanently removes a list of Notes, and all of their Resources, from
    the service.  This should be invoked with a small number of Note GUIDs
    (e.g. 100 or less) on each call.  To expunge a larger number of notes,
    call this method multiple times.  This should also be used to reduce the
    number of Notes in a notebook before calling expungeNotebook() or
    in the trash before calling expungeInactiveNotes(), since these calls may
    be prohibitively slow if there are more than a few hundred notes.
    If an exception is thrown for any of the GUIDs, then none of the notes
    will be deleted.  I.e. this call can be treated as an atomic transaction.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param noteGuids
      The list of GUIDs for the Notes to remove.

    @return
      The account's updateCount at the end of this operation

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuids
    """
    self.send_expungeNotes(authenticationToken, noteGuids)
    return self.recv_expungeNotes()

  def send_expungeNotes(self, authenticationToken, noteGuids):
    self._oprot.writeMessageBegin('expungeNotes', TMessageType.CALL, self._seqid)
    args = expungeNotes_args()
    args.authenticationToken = authenticationToken
    args.noteGuids = noteGuids
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeNotes(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeNotes_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeNotes failed: unknown result");

  def expungeInactiveNotes(self, authenticationToken):
    """
    Permanently removes all of the Notes that are currently marked as
    inactive.  This is equivalent to "emptying the trash", and these Notes
    will be gone permanently.
    <p/>
    This operation may be relatively slow if the account contains a large
    number of inactive Notes.
    <p/>
    NOTE: This function is not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @return
       The number of notes that were expunged.

    Parameters:
     - authenticationToken
    """
    self.send_expungeInactiveNotes(authenticationToken)
    return self.recv_expungeInactiveNotes()

  def send_expungeInactiveNotes(self, authenticationToken):
    self._oprot.writeMessageBegin('expungeInactiveNotes', TMessageType.CALL, self._seqid)
    args = expungeInactiveNotes_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeInactiveNotes(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeInactiveNotes_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeInactiveNotes failed: unknown result");

  def copyNote(self, authenticationToken, noteGuid, toNotebookGuid):
    """
    Performs a deep copy of the Note with the provided GUID 'noteGuid' into
    the Notebook with the provided GUID 'toNotebookGuid'.
    The caller must be the owner of both the Note and the Notebook.
    This creates a new Note in the destination Notebook with new content and
    Resources that match all of the content and Resources from the original
    Note, but with new GUID identifiers.
    The original Note is not modified by this operation.
    The copied note is considered as an "upload" for the purpose of upload
    transfer limit calculation, so its size is added to the upload count for
    the owner.

    @param noteGuid
      The GUID of the Note to copy.

    @param toNotebookGuid
      The GUID of the Notebook that should receive the new Note.

    @return
      The metadata for the new Note that was created.  This will include the
      new GUID for this Note (and any copied Resources), but will not include
      the content body or the binary bodies of any Resources.

    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "Note" - at max number per account
      </li>
      <li> PERMISSION_DENIED "Notebook.guid" - destination not owned by user
      </li>
      <li> PERMISSION_DENIED "Note" - user doesn't own
      </li>
      <li> QUOTA_REACHED "Accounting.uploadLimit" - note exceeds upload quota
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - toNotebookGuid
    """
    self.send_copyNote(authenticationToken, noteGuid, toNotebookGuid)
    return self.recv_copyNote()

  def send_copyNote(self, authenticationToken, noteGuid, toNotebookGuid):
    self._oprot.writeMessageBegin('copyNote', TMessageType.CALL, self._seqid)
    args = copyNote_args()
    args.authenticationToken = authenticationToken
    args.noteGuid = noteGuid
    args.toNotebookGuid = toNotebookGuid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_copyNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = copyNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "copyNote failed: unknown result");

  def listNoteVersions(self, authenticationToken, noteGuid):
    """
    Returns a list of the prior versions of a particular note that are
    saved within the service.  These prior versions are stored to provide a
    recovery from unintentional removal of content from a note. The identifiers
    that are returned by this call can be used with getNoteVersion to retrieve
    the previous note.
    The identifiers will be listed from the most recent versions to the oldest.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
    """
    self.send_listNoteVersions(authenticationToken, noteGuid)
    return self.recv_listNoteVersions()

  def send_listNoteVersions(self, authenticationToken, noteGuid):
    self._oprot.writeMessageBegin('listNoteVersions', TMessageType.CALL, self._seqid)
    args = listNoteVersions_args()
    args.authenticationToken = authenticationToken
    args.noteGuid = noteGuid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listNoteVersions(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listNoteVersions_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listNoteVersions failed: unknown result");

  def getNoteVersion(self, authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    """
    This can be used to retrieve a previous version of a Note after it has been
    updated within the service.  The caller must identify the note (via its
    guid) and the version (via the updateSequenceNumber of that version).
    to find a listing of the stored version USNs for a note, call
    listNoteVersions.
    This call is only available for notes in Premium accounts.  (I.e. access
    to past versions of Notes is a Premium-only feature.)

    @param noteGuid
      The GUID of the note to be retrieved.

    @param updateSequenceNum
      The USN of the version of the note that is being retrieved

    @param withResourcesData
      If true, any Resource elements in this Note will include the binary
      contents of their 'data' field's body.

    @param withResourcesRecognition
      If true, any Resource elements will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withResourcesAlternateData
      If true, any Resource elements in this Note will include the binary
      contents of their 'alternateData' fields' body, if an alternate form
      is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
      <li> PERMISSION_DENIED "updateSequenceNum" -
        The account isn't permitted to access previous versions of notes.
        (i.e. this is a Free account.)
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
      <li> "Note.updateSequenceNumber" - the Note doesn't have a version with
         the corresponding USN.
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - updateSequenceNum
     - withResourcesData
     - withResourcesRecognition
     - withResourcesAlternateData
    """
    self.send_getNoteVersion(authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData)
    return self.recv_getNoteVersion()

  def send_getNoteVersion(self, authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData):
    self._oprot.writeMessageBegin('getNoteVersion', TMessageType.CALL, self._seqid)
    args = getNoteVersion_args()
    args.authenticationToken = authenticationToken
    args.noteGuid = noteGuid
    args.updateSequenceNum = updateSequenceNum
    args.withResourcesData = withResourcesData
    args.withResourcesRecognition = withResourcesRecognition
    args.withResourcesAlternateData = withResourcesAlternateData
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getNoteVersion(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getNoteVersion_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getNoteVersion failed: unknown result");

  def getResource(self, authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData):
    """
    Returns the current state of the resource in the service with the
    provided GUID.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).  Only the
    keys for the applicationData will be returned.

    @param guid
      The GUID of the resource to be retrieved.

    @param withData
      If true, the Resource will include the binary contents of the
      'data' field's body.

    @param withRecognition
      If true, the Resource will include the binary contents of the
      'recognition' field's body if recognition data is present.

    @param withAttributes
      If true, the Resource will include the attributes

    @param withAlternateData
      If true, the Resource will include the binary contents of the
      'alternateData' field's body, if an alternate form is present.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - withData
     - withRecognition
     - withAttributes
     - withAlternateData
    """
    self.send_getResource(authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData)
    return self.recv_getResource()

  def send_getResource(self, authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData):
    self._oprot.writeMessageBegin('getResource', TMessageType.CALL, self._seqid)
    args = getResource_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.withData = withData
    args.withRecognition = withRecognition
    args.withAttributes = withAttributes
    args.withAlternateData = withAlternateData
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResource(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResource_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResource failed: unknown result");

  def getResourceApplicationData(self, authenticationToken, guid):
    """
    Get all of the application data for the Resource identified by GUID,
    with values returned within the LazyMap fullMap field.
    If there are no applicationData entries, then a LazyMap
    with an empty fullMap will be returned. If your application
    only needs to fetch its own applicationData entry, use
    getResourceApplicationDataEntry instead.

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceApplicationData(authenticationToken, guid)
    return self.recv_getResourceApplicationData()

  def send_getResourceApplicationData(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceApplicationData', TMessageType.CALL, self._seqid)
    args = getResourceApplicationData_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceApplicationData(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceApplicationData_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceApplicationData failed: unknown result");

  def getResourceApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Get the value of a single entry in the applicationData map
    for the Resource identified by GUID.

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - Resource not found, by GUID</li>
      <li> "ResourceAttributes.applicationData.key" - Resource not found, by key</li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    self.send_getResourceApplicationDataEntry(authenticationToken, guid, key)
    return self.recv_getResourceApplicationDataEntry()

  def send_getResourceApplicationDataEntry(self, authenticationToken, guid, key):
    self._oprot.writeMessageBegin('getResourceApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = getResourceApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceApplicationDataEntry failed: unknown result");

  def setResourceApplicationDataEntry(self, authenticationToken, guid, key, value):
    """
    Update, or create, an entry in the applicationData map for
    the Resource identified by guid.

    Parameters:
     - authenticationToken
     - guid
     - key
     - value
    """
    self.send_setResourceApplicationDataEntry(authenticationToken, guid, key, value)
    return self.recv_setResourceApplicationDataEntry()

  def send_setResourceApplicationDataEntry(self, authenticationToken, guid, key, value):
    self._oprot.writeMessageBegin('setResourceApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = setResourceApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.value = value
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setResourceApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setResourceApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "setResourceApplicationDataEntry failed: unknown result");

  def unsetResourceApplicationDataEntry(self, authenticationToken, guid, key):
    """
    Remove an entry identified by 'key' from the applicationData map for
    the Resource identified by 'guid'.

    Parameters:
     - authenticationToken
     - guid
     - key
    """
    self.send_unsetResourceApplicationDataEntry(authenticationToken, guid, key)
    return self.recv_unsetResourceApplicationDataEntry()

  def send_unsetResourceApplicationDataEntry(self, authenticationToken, guid, key):
    self._oprot.writeMessageBegin('unsetResourceApplicationDataEntry', TMessageType.CALL, self._seqid)
    args = unsetResourceApplicationDataEntry_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.key = key
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_unsetResourceApplicationDataEntry(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = unsetResourceApplicationDataEntry_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "unsetResourceApplicationDataEntry failed: unknown result");

  def updateResource(self, authenticationToken, resource):
    """
    Submit a set of changes to a resource to the service.  This can be used
    to update the meta-data about the resource, but cannot be used to change
    the binary contents of the resource (including the length and hash).  These
    cannot be changed directly without creating a new resource and removing the
    old one via updateNote.

    @param resource
      A Resource object containing the desired fields to be populated on
      the service.  The service will attempt to update the resource with the
      following fields from the client:
      <ul>
         <li>guid:  must be provided to identify the resource
         </li>
         <li>mime
         </li>
         <li>width
         </li>
         <li>height
         </li>
         <li>duration
         </li>
         <li>attributes:  optional.  if present, the set of attributes will
              be replaced.
         </li>
      </ul>

    @return
      The Update Sequence Number of the resource after the changes have been
      applied.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> BAD_DATA_FORMAT "Resource.mime" - invalid resource MIME type
      </li>
      <li> BAD_DATA_FORMAT "ResourceAttributes.*" - bad resource string
      </li>
      <li> LIMIT_REACHED "ResourceAttribute.*" - attribute string too long
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - resource
    """
    self.send_updateResource(authenticationToken, resource)
    return self.recv_updateResource()

  def send_updateResource(self, authenticationToken, resource):
    self._oprot.writeMessageBegin('updateResource', TMessageType.CALL, self._seqid)
    args = updateResource_args()
    args.authenticationToken = authenticationToken
    args.resource = resource
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateResource(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateResource_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateResource failed: unknown result");

  def getResourceData(self, authenticationToken, guid):
    """
    Returns binary data of the resource with the provided GUID.  For
    example, if this were an image resource, this would contain the
    raw bits of the image.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource to be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceData(authenticationToken, guid)
    return self.recv_getResourceData()

  def send_getResourceData(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceData', TMessageType.CALL, self._seqid)
    args = getResourceData_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceData(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceData_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceData failed: unknown result");

  def getResourceByHash(self, authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData):
    """
    Returns the current state of a resource, referenced by containing
    note GUID and resource content hash.

    @param noteGuid
      The GUID of the note that holds the resource to be retrieved.

    @param contentHash
      The MD5 checksum of the resource within that note. Note that
      this is the binary checksum, for example from Resource.data.bodyHash,
      and not the hex-encoded checksum that is used within an en-media
      tag in a note body.

    @param withData
      If true, the Resource will include the binary contents of the
      'data' field's body.

    @param withRecognition
      If true, the Resource will include the binary contents of the
      'recognition' field's body.

    @param withAlternateData
      If true, the Resource will include the binary contents of the
      'alternateData' field's body, if an alternate form is present.

    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "Note.guid" - noteGuid param missing
      </li>
      <li> DATA_REQUIRED "Note.contentHash" - contentHash param missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note" - not found, by guid
      </li>
      <li> "Resource" - not found, by hash
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - noteGuid
     - contentHash
     - withData
     - withRecognition
     - withAlternateData
    """
    self.send_getResourceByHash(authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData)
    return self.recv_getResourceByHash()

  def send_getResourceByHash(self, authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData):
    self._oprot.writeMessageBegin('getResourceByHash', TMessageType.CALL, self._seqid)
    args = getResourceByHash_args()
    args.authenticationToken = authenticationToken
    args.noteGuid = noteGuid
    args.contentHash = contentHash
    args.withData = withData
    args.withRecognition = withRecognition
    args.withAlternateData = withAlternateData
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceByHash(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceByHash_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceByHash failed: unknown result");

  def getResourceRecognition(self, authenticationToken, guid):
    """
    Returns the binary contents of the recognition index for the resource
    with the provided GUID.  If the caller asks about a resource that has
    no recognition data, this will throw EDAMNotFoundException.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource whose recognition data should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
      <li> "Resource.recognition" - resource has no recognition
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceRecognition(authenticationToken, guid)
    return self.recv_getResourceRecognition()

  def send_getResourceRecognition(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceRecognition', TMessageType.CALL, self._seqid)
    args = getResourceRecognition_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceRecognition(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceRecognition_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceRecognition failed: unknown result");

  def getResourceAlternateData(self, authenticationToken, guid):
    """
    If the Resource with the provided GUID has an alternate data representation
    (indicated via the Resource.alternateData field), then this request can
    be used to retrieve the binary contents of that alternate data file.
    If the caller asks about a resource that has no alternate data form, this
    will throw EDAMNotFoundException.

    @param guid
       The GUID of the resource whose recognition data should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
      <li> "Resource.alternateData" - resource has no recognition
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceAlternateData(authenticationToken, guid)
    return self.recv_getResourceAlternateData()

  def send_getResourceAlternateData(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceAlternateData', TMessageType.CALL, self._seqid)
    args = getResourceAlternateData_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceAlternateData(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceAlternateData_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceAlternateData failed: unknown result");

  def getResourceAttributes(self, authenticationToken, guid):
    """
    Returns the set of attributes for the Resource with the provided GUID.
    If the Resource is found in a public notebook, the authenticationToken
    will be ignored (so it could be an empty string).

    @param guid
      The GUID of the resource whose attributes should be retrieved.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Resource.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Resource" - private resource, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Resource.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_getResourceAttributes(authenticationToken, guid)
    return self.recv_getResourceAttributes()

  def send_getResourceAttributes(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('getResourceAttributes', TMessageType.CALL, self._seqid)
    args = getResourceAttributes_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getResourceAttributes(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getResourceAttributes_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getResourceAttributes failed: unknown result");

  def getPublicNotebook(self, userId, publicUri):
    """
    <p>
    Looks for a user account with the provided userId on this NoteStore
    shard and determines whether that account contains a public notebook
    with the given URI.  If the account is not found, or no public notebook
    exists with this URI, this will throw an EDAMNotFoundException,
    otherwise this will return the information for that Notebook.
    </p>
    <p>
    If a notebook is visible on the web with a full URL like
    http://www.evernote.com/pub/sethdemo/api
    Then 'sethdemo' is the username that can be used to look up the userId,
    and 'api' is the publicUri.
    </p>

    @param userId
       The numeric identifier for the user who owns the public notebook.
       To find this value based on a username string, you can invoke
       UserStore.getPublicUserInfo

    @param publicUri
       The uri string for the public notebook, from Notebook.publishing.uri.

    @throws EDAMNotFoundException <ul>
      <li>"Publishing.uri" - not found, by URI</li>
    </ul>

    @throws EDAMSystemException <ul>
      <li> TAKEN_DOWN "PublicNotebook" - The specified public notebook is
        taken down (for all requesters).</li>
      <li> TAKEN_DOWN "Country" - The specified public notebook is taken
        down for the requester because of an IP-based country lookup.</li>
    </ul>

    Parameters:
     - userId
     - publicUri
    """
    self.send_getPublicNotebook(userId, publicUri)
    return self.recv_getPublicNotebook()

  def send_getPublicNotebook(self, userId, publicUri):
    self._oprot.writeMessageBegin('getPublicNotebook', TMessageType.CALL, self._seqid)
    args = getPublicNotebook_args()
    args.userId = userId
    args.publicUri = publicUri
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getPublicNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getPublicNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getPublicNotebook failed: unknown result");

  def createSharedNotebook(self, authenticationToken, sharedNotebook):
    """
    Used to construct a shared notebook object. The constructed notebook will
    contain a "share key" which serve as a unique identifer and access token
    for a user to access the notebook of the shared notebook owner.

    @param sharedNotebook
      A shared notebook object populated with the email address of the share
      recipient, the notebook guid and the access permissions. All other
      attributes of the shared object are ignored. The SharedNotebook.allowPreview
      field must be explicitly set with either a true or false value.

    @return
      The fully populated SharedNotebook object including the server assigned
      share id and shareKey which can both be used to uniquely identify the
      SharedNotebook.

    @throws EDAMUserException <ul>
      <li>BAD_DATA_FORMAT "SharedNotebook.email" - if the email was not valid</li>
      <li>BAD_DATA_FORMAT "requireLogin" - if the SharedNotebook.allowPreview field was
          not set, and the SharedNotebook.requireLogin was also not set or was set to
          false.</li>
      <li>PERMISSION_DENIED "SharedNotebook.recipientSettings" - if
          recipientSettings is set in the sharedNotebook.  Only the recipient
          can set these values via the setSharedNotebookRecipientSettings
          method.
      </li>
      </ul>
    @throws EDAMNotFoundException <ul>
      <li>Notebook.guid - if the notebookGuid is not a valid GUID for the user.
      </li>
      </ul>

    Parameters:
     - authenticationToken
     - sharedNotebook
    """
    self.send_createSharedNotebook(authenticationToken, sharedNotebook)
    return self.recv_createSharedNotebook()

  def send_createSharedNotebook(self, authenticationToken, sharedNotebook):
    self._oprot.writeMessageBegin('createSharedNotebook', TMessageType.CALL, self._seqid)
    args = createSharedNotebook_args()
    args.authenticationToken = authenticationToken
    args.sharedNotebook = sharedNotebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createSharedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createSharedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createSharedNotebook failed: unknown result");

  def updateSharedNotebook(self, authenticationToken, sharedNotebook):
    """
    Update a SharedNotebook object.

    @param authenticationToken
      Must be an authentication token from the owner or a shared notebook
      authentication token or business authentication token with sufficient
      permissions to change invitations for a notebook.

    @param sharedNotebook
     The SharedNotebook object containing the requested changes.
     The "id" of the shared notebook must be set to allow the service
     to identify the SharedNotebook to be updated. In addition, you MUST set
     the email, permission, and allowPreview fields to the desired values.
     All other fields will be ignored if set.

    @return
     The Update Serial Number for this change within the account.

    @throws EDAMUserException <ul>
      <li>UNSUPPORTED_OPERATION "updateSharedNotebook" - if this service instance does not support shared notebooks.</li>
      <li>BAD_DATA_FORMAT "SharedNotebook.email" - if the email was not valid.</li>
      <li>DATA_REQUIRED "SharedNotebook.id" - if the id field was not set.</li>
      <li>DATA_REQUIRED "SharedNotebook.privilege" - if the privilege field was not set.</li>
      <li>DATA_REQUIRED "SharedNotebook.allowPreview" - if the allowPreview field was not set.</li>
      </ul>
    @throws EDAMNotFoundException <ul>
      <li>SharedNotebook.id - if no shared notebook with the specified ID was found.
      </ul>

    Parameters:
     - authenticationToken
     - sharedNotebook
    """
    self.send_updateSharedNotebook(authenticationToken, sharedNotebook)
    return self.recv_updateSharedNotebook()

  def send_updateSharedNotebook(self, authenticationToken, sharedNotebook):
    self._oprot.writeMessageBegin('updateSharedNotebook', TMessageType.CALL, self._seqid)
    args = updateSharedNotebook_args()
    args.authenticationToken = authenticationToken
    args.sharedNotebook = sharedNotebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateSharedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateSharedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateSharedNotebook failed: unknown result");

  def setSharedNotebookRecipientSettings(self, authenticationToken, sharedNotebookId, recipientSettings):
    """
    Set values for the recipient settings associated with a shared notebook.  Having
    update rights to the shared notebook record itself has no effect on this call;
    only the recipient of the shared notebook can can the recipient settings.

    If you do <i>not</i> wish to, or cannot, change one of the reminderNotifyEmail or
    reminderNotifyInApp fields, you must leave that field unset in recipientSettings.
    This method will skip that field for updates and leave the existing state as
    it is.

    @return The update sequence number of the account to which the shared notebook
      belongs, which is the account from which we are sharing a notebook.

    @throws EDAMNotFoundException "sharedNotebookId" - Thrown if the service does not
      have a shared notebook record for the sharedNotebookId on the given shard.  If you
      receive this exception, it is probable that the shared notebook record has
      been revoked or expired, or that you accessed the wrong shard.

    @throws EDAMUserException <ul>
      <li>PEMISSION_DENIED "authenticationToken" - If you do not have permission to set
          the recipient settings for the shared notebook.  Only the recipient has
          permission to do this.
      <li>DATA_CONFLICT "recipientSettings.reminderNotifyEmail" - Setting whether
          or not you want to receive reminder e-mail notifications is possible on
          a business notebook in the business to which the user belongs.  All
          others can safely unset the reminderNotifyEmail field from the
          recipientSettings parameter.
    </ul>

    Parameters:
     - authenticationToken
     - sharedNotebookId
     - recipientSettings
    """
    self.send_setSharedNotebookRecipientSettings(authenticationToken, sharedNotebookId, recipientSettings)
    return self.recv_setSharedNotebookRecipientSettings()

  def send_setSharedNotebookRecipientSettings(self, authenticationToken, sharedNotebookId, recipientSettings):
    self._oprot.writeMessageBegin('setSharedNotebookRecipientSettings', TMessageType.CALL, self._seqid)
    args = setSharedNotebookRecipientSettings_args()
    args.authenticationToken = authenticationToken
    args.sharedNotebookId = sharedNotebookId
    args.recipientSettings = recipientSettings
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_setSharedNotebookRecipientSettings(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = setSharedNotebookRecipientSettings_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "setSharedNotebookRecipientSettings failed: unknown result");

  def sendMessageToSharedNotebookMembers(self, authenticationToken, notebookGuid, messageText, recipients):
    """
    Send a reminder message to some or all of the email addresses that a notebook has been
    shared with. The message includes the current link to view the notebook.
    @param authenticationToken
      The auth token of the user with permissions to share the notebook
    @param notebookGuid
      The guid of the shared notebook
    @param messageText
     User provided text to include in the email
    @param recipients
     The email addresses of the recipients. If this list is empty then all of the
     users that the notebook has been shared with are emailed.
     If an email address doesn't correspond to share invite members then that address
     is ignored.
    @return
     The number of messages sent
    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "(recipients)" -
        The email can't be sent because this would exceed the user's daily
        email limit.
      </li>
      <li> PERMISSION_DENIED "Notebook.guid" - The user doesn't have permission to
        send a message for the specified notebook.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Notebook.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - notebookGuid
     - messageText
     - recipients
    """
    self.send_sendMessageToSharedNotebookMembers(authenticationToken, notebookGuid, messageText, recipients)
    return self.recv_sendMessageToSharedNotebookMembers()

  def send_sendMessageToSharedNotebookMembers(self, authenticationToken, notebookGuid, messageText, recipients):
    self._oprot.writeMessageBegin('sendMessageToSharedNotebookMembers', TMessageType.CALL, self._seqid)
    args = sendMessageToSharedNotebookMembers_args()
    args.authenticationToken = authenticationToken
    args.notebookGuid = notebookGuid
    args.messageText = messageText
    args.recipients = recipients
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_sendMessageToSharedNotebookMembers(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = sendMessageToSharedNotebookMembers_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "sendMessageToSharedNotebookMembers failed: unknown result");

  def listSharedNotebooks(self, authenticationToken):
    """
    Lists the collection of shared notebooks for all notebooks in the
    users account.

    @return
     The list of all SharedNotebooks for the user

    Parameters:
     - authenticationToken
    """
    self.send_listSharedNotebooks(authenticationToken)
    return self.recv_listSharedNotebooks()

  def send_listSharedNotebooks(self, authenticationToken):
    self._oprot.writeMessageBegin('listSharedNotebooks', TMessageType.CALL, self._seqid)
    args = listSharedNotebooks_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listSharedNotebooks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listSharedNotebooks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listSharedNotebooks failed: unknown result");

  def expungeSharedNotebooks(self, authenticationToken, sharedNotebookIds):
    """
    Expunges the SharedNotebooks in the user's account using the
    SharedNotebook.id as the identifier.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param
      sharedNotebookIds - a list of ShardNotebook.id longs identifying the
          objects to delete permanently.

    @return
      The account's update sequence number.

    Parameters:
     - authenticationToken
     - sharedNotebookIds
    """
    self.send_expungeSharedNotebooks(authenticationToken, sharedNotebookIds)
    return self.recv_expungeSharedNotebooks()

  def send_expungeSharedNotebooks(self, authenticationToken, sharedNotebookIds):
    self._oprot.writeMessageBegin('expungeSharedNotebooks', TMessageType.CALL, self._seqid)
    args = expungeSharedNotebooks_args()
    args.authenticationToken = authenticationToken
    args.sharedNotebookIds = sharedNotebookIds
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeSharedNotebooks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeSharedNotebooks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeSharedNotebooks failed: unknown result");

  def createLinkedNotebook(self, authenticationToken, linkedNotebook):
    """
    Asks the service to make a linked notebook with the provided name, username
    of the owner and identifiers provided. A linked notebook can be either a
    link to a public notebook or to a private shared notebook.

    @param linkedNotebook
      The desired fields for the linked notebook must be provided on this
      object.  The name of the linked notebook must be set. Either a username
      uri or a shard id and share key must be provided otherwise a
      EDAMUserException is thrown.

    @return
      The newly created LinkedNotebook.  The server-side id will be
      saved in this object's 'id' field.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "LinkedNotebook.name" - invalid length or pattern
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.username" - bad username format
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.uri" -
        if public notebook set but bad uri
      </li>
      <li> BAD_DATA_FORMAT "LinkedNotebook.shareKey" -
        if private notebook set but bad shareKey
      </li>
      <li> DATA_REQUIRED "LinkedNotebook.shardId" -
        if private notebook but shard id not provided
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    self.send_createLinkedNotebook(authenticationToken, linkedNotebook)
    return self.recv_createLinkedNotebook()

  def send_createLinkedNotebook(self, authenticationToken, linkedNotebook):
    self._oprot.writeMessageBegin('createLinkedNotebook', TMessageType.CALL, self._seqid)
    args = createLinkedNotebook_args()
    args.authenticationToken = authenticationToken
    args.linkedNotebook = linkedNotebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createLinkedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createLinkedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "createLinkedNotebook failed: unknown result");

  def updateLinkedNotebook(self, authenticationToken, linkedNotebook):
    """
    @param linkedNotebook
      Updates the name of a linked notebook.

    @return
      The Update Sequence Number for this change within the account.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "LinkedNotebook.name" - invalid length or pattern
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - linkedNotebook
    """
    self.send_updateLinkedNotebook(authenticationToken, linkedNotebook)
    return self.recv_updateLinkedNotebook()

  def send_updateLinkedNotebook(self, authenticationToken, linkedNotebook):
    self._oprot.writeMessageBegin('updateLinkedNotebook', TMessageType.CALL, self._seqid)
    args = updateLinkedNotebook_args()
    args.authenticationToken = authenticationToken
    args.linkedNotebook = linkedNotebook
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_updateLinkedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = updateLinkedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "updateLinkedNotebook failed: unknown result");

  def listLinkedNotebooks(self, authenticationToken):
    """
    Returns a list of linked notebooks

    Parameters:
     - authenticationToken
    """
    self.send_listLinkedNotebooks(authenticationToken)
    return self.recv_listLinkedNotebooks()

  def send_listLinkedNotebooks(self, authenticationToken):
    self._oprot.writeMessageBegin('listLinkedNotebooks', TMessageType.CALL, self._seqid)
    args = listLinkedNotebooks_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_listLinkedNotebooks(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = listLinkedNotebooks_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "listLinkedNotebooks failed: unknown result");

  def expungeLinkedNotebook(self, authenticationToken, guid):
    """
    Permanently expunges the linked notebook from the account.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param guid
      The LinkedNotebook.guid field of the LinkedNotebook to permanently remove
      from the account.

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_expungeLinkedNotebook(authenticationToken, guid)
    return self.recv_expungeLinkedNotebook()

  def send_expungeLinkedNotebook(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('expungeLinkedNotebook', TMessageType.CALL, self._seqid)
    args = expungeLinkedNotebook_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_expungeLinkedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = expungeLinkedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "expungeLinkedNotebook failed: unknown result");

  def authenticateToSharedNotebook(self, shareKey, authenticationToken):
    """
    Asks the service to produce an authentication token that can be used to
    access the contents of a shared notebook from someone else's account.
    This authenticationToken can be used with the various other NoteStore
    calls to find and retrieve notes, and if the permissions in the shared
    notebook are sufficient, to make changes to the contents of the notebook.

    @param shareKey
      The 'shareKey' identifier from the SharedNotebook that was granted to
      some recipient.  This string internally encodes the notebook identifier
      and a security signature.

    @param authenticationToken
      If a non-empty string is provided, this is the full user-based
      authentication token that identifies the user who is currently logged in
      and trying to access the shared notebook.  This may be required if the
      notebook was created with 'requireLogin'.
      If this string is empty, the service will attempt to authenticate to the
      shared notebook without any logged in user.

    @throws EDAMSystemException <ul>
      <li> BAD_DATA_FORMAT "shareKey" - invalid shareKey string
      </li>
      <li> INVALID_AUTH "shareKey" - bad signature on shareKey string
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SharedNotebook.id" - the shared notebook no longer exists
      </li>
    </ul>

    @throws EDAMUserException <ul>
      <li> DATA_REQUIRED "authenticationToken" - the share requires login, and
             no valid authentication token was provided.
      </li>
      <li> PERMISSION_DENIED "SharedNotebook.username" - share requires login,
             and another username has already been bound to this notebook.
      </li>
    </ul>

    Parameters:
     - shareKey
     - authenticationToken
    """
    self.send_authenticateToSharedNotebook(shareKey, authenticationToken)
    return self.recv_authenticateToSharedNotebook()

  def send_authenticateToSharedNotebook(self, shareKey, authenticationToken):
    self._oprot.writeMessageBegin('authenticateToSharedNotebook', TMessageType.CALL, self._seqid)
    args = authenticateToSharedNotebook_args()
    args.shareKey = shareKey
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_authenticateToSharedNotebook(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = authenticateToSharedNotebook_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "authenticateToSharedNotebook failed: unknown result");

  def getSharedNotebookByAuth(self, authenticationToken):
    """
    This function is used to retrieve extended information about a shared
    notebook by a guest who has already authenticated to access that notebook.
    This requires an 'authenticationToken' parameter which should be the
    resut of a call to authenticateToSharedNotebook(...).
    I.e. this is the token that gives access to the particular shared notebook
    in someone else's account -- it's not the authenticationToken for the
    owner of the notebook itself.

    @param authenticationToken
      Should be the authentication token retrieved from the reply of
      authenticateToSharedNotebook(), proving access to a particular shared
      notebook.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "authenticationToken" -
             authentication token doesn't correspond to a valid shared notebook
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "SharedNotebook.id" - the shared notebook no longer exists
      </li>
    </ul>

    Parameters:
     - authenticationToken
    """
    self.send_getSharedNotebookByAuth(authenticationToken)
    return self.recv_getSharedNotebookByAuth()

  def send_getSharedNotebookByAuth(self, authenticationToken):
    self._oprot.writeMessageBegin('getSharedNotebookByAuth', TMessageType.CALL, self._seqid)
    args = getSharedNotebookByAuth_args()
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getSharedNotebookByAuth(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getSharedNotebookByAuth_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getSharedNotebookByAuth failed: unknown result");

  def emailNote(self, authenticationToken, parameters):
    """
    Attempts to send a single note to one or more email recipients.
    <p/>
    NOTE: This function is generally not available to third party applications.
    Calls will result in an EDAMUserException with the error code
    PERMISSION_DENIED.

    @param authenticationToken
       The note will be sent as the user logged in via this token, using that
       user's registered email address.  If the authenticated user doesn't
       have permission to read that note, the emailing will fail.

    @param parameters
       The note must be specified either by GUID (in which case it will be
       sent using the existing data in the service), or else the full Note
       must be passed to this call.  This also specifies the additional
       email fields that will be used in the email.

    @throws EDAMUserException <ul>
      <li> LIMIT_REACHED "NoteEmailParameters.toAddresses" -
        The email can't be sent because this would exceed the user's daily
        email limit.
      </li>
      <li> BAD_DATA_FORMAT "(email address)" -
        email address malformed
      </li>
      <li> DATA_REQUIRED "NoteEmailParameters.toAddresses" -
        if there are no To: or Cc: addresses provided.
      </li>
      <li> DATA_REQUIRED "Note.title" -
        if the caller provides a Note parameter with no title
      </li>
      <li> DATA_REQUIRED "Note.content" -
        if the caller provides a Note parameter with no content
      </li>
      <li> ENML_VALIDATION "*" - note content doesn't validate against DTD
      </li>
      <li> DATA_REQUIRED "NoteEmailParameters.note" -
        if no guid or note provided
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - parameters
    """
    self.send_emailNote(authenticationToken, parameters)
    self.recv_emailNote()

  def send_emailNote(self, authenticationToken, parameters):
    self._oprot.writeMessageBegin('emailNote', TMessageType.CALL, self._seqid)
    args = emailNote_args()
    args.authenticationToken = authenticationToken
    args.parameters = parameters
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_emailNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = emailNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    return

  def shareNote(self, authenticationToken, guid):
    """
    If this note is not already shared (via its own direct URL), then this
    will start sharing that note.
    This will return the secret "Note Key" for this note that
    can currently be used in conjunction with the Note's GUID to gain direct
    read-only access to the Note.
    If the note is already shared, then this won't make any changes to the
    note, and the existing "Note Key" will be returned.  The only way to change
    the Note Key for an existing note is to stopSharingNote first, and then
    call this function.

    @param guid
      The GUID of the note to be shared.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_shareNote(authenticationToken, guid)
    return self.recv_shareNote()

  def send_shareNote(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('shareNote', TMessageType.CALL, self._seqid)
    args = shareNote_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_shareNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = shareNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "shareNote failed: unknown result");

  def stopSharingNote(self, authenticationToken, guid):
    """
    If this note is not already shared then this will stop sharing that note
    and invalidate its "Note Key", so any existing URLs to access that Note
    will stop working.
    If the Note is not shared, then this function will do nothing.

    @param guid
      The GUID of the note to be un-shared.

    @throws EDAMUserException <ul>
      <li> BAD_DATA_FORMAT "Note.guid" - if the parameter is missing
      </li>
      <li> PERMISSION_DENIED "Note" - private note, user doesn't own
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "Note.guid" - not found, by GUID
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - guid
    """
    self.send_stopSharingNote(authenticationToken, guid)
    self.recv_stopSharingNote()

  def send_stopSharingNote(self, authenticationToken, guid):
    self._oprot.writeMessageBegin('stopSharingNote', TMessageType.CALL, self._seqid)
    args = stopSharingNote_args()
    args.authenticationToken = authenticationToken
    args.guid = guid
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_stopSharingNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = stopSharingNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    return

  def authenticateToSharedNote(self, guid, noteKey, authenticationToken):
    """
    Asks the service to produce an authentication token that can be used to
    access the contents of a single Note which was individually shared
    from someone's account.
    This authenticationToken can be used with the various other NoteStore
    calls to find and retrieve the Note and its directly-referenced children.

    @param guid
      The GUID identifying this Note on this shard.

    @param noteKey
      The 'noteKey' identifier from the Note that was originally created via
      a call to shareNote() and then given to a recipient to access.

    @param authenticationToken
      An optional authenticationToken that identifies the user accessing the
      shared note. This parameter may be required to access some shared notes.

    @throws EDAMUserException <ul>
      <li> PERMISSION_DENIED "Note" - the Note with that GUID is either not
        shared, or the noteKey doesn't match the current key for this note
      </li>
      <li> PERMISSION_DENIED "authenticationToken" - an authentication token is
        required to access this Note, but either no authentication token or a
        "non-owner" authentication token was provided.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li> "guid" - the note with that GUID is not found
      </li>
    </ul>

    @throws EDAMSystemException <ul>
      <li> TAKEN_DOWN "Note" - The specified shared note is taken down (for
        all requesters).
      </li>
      <li> TAKEN_DOWN "Country" - The specified shared note is taken down
        for the requester because of an IP-based country lookup.
      </ul>
    </ul>

    Parameters:
     - guid
     - noteKey
     - authenticationToken
    """
    self.send_authenticateToSharedNote(guid, noteKey, authenticationToken)
    return self.recv_authenticateToSharedNote()

  def send_authenticateToSharedNote(self, guid, noteKey, authenticationToken):
    self._oprot.writeMessageBegin('authenticateToSharedNote', TMessageType.CALL, self._seqid)
    args = authenticateToSharedNote_args()
    args.guid = guid
    args.noteKey = noteKey
    args.authenticationToken = authenticationToken
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_authenticateToSharedNote(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = authenticateToSharedNote_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.notFoundException is not None:
      raise result.notFoundException
    if result.systemException is not None:
      raise result.systemException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "authenticateToSharedNote failed: unknown result");

  def findRelated(self, authenticationToken, query, resultSpec):
    """
    Identify related entities on the service, such as notes,
    notebooks, and tags related to notes or content.

    @param query
      The information about which we are finding related entities.

    @param resultSpec
      Allows the client to indicate the type and quantity of
      information to be returned, allowing a saving of time and
      bandwidth.

    @return
      The result of the query, with information considered
      to likely be relevantly related to the information
      described by the query.

    @throws EDAMUserException <ul>
      <li>BAD_DATA_FORMAT "RelatedQuery.plainText" - If you provided a
        a zero-length plain text value.
      </li>
      <li>BAD_DATA_FORMAT "RelatedQuery.noteGuid" - If you provided an
        invalid Note GUID, that is, one that does not match the constraints
        defined by EDAM_GUID_LEN_MIN, EDAM_GUID_LEN_MAX, EDAM_GUID_REGEX.
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.notebookGuid" - if malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.tagGuids" - if any are malformed
      </li>
      <li> BAD_DATA_FORMAT "NoteFilter.words" - if search string too long
      </li>
      <li>PERMISSION_DENIED "Note" - If the caller does not have access to
        the note identified by RelatedQuery.noteGuid.
      </li>
      <li>DATA_REQUIRED "RelatedResultSpec" - If you did not not set any values
        in the result spec.
      </li>
    </ul>

    @throws EDAMNotFoundException <ul>
      <li>"RelatedQuery.noteGuid" - the note with that GUID is not
        found, if that field has been set in the query.
      </li>
    </ul>

    Parameters:
     - authenticationToken
     - query
     - resultSpec
    """
    self.send_findRelated(authenticationToken, query, resultSpec)
    return self.recv_findRelated()

  def send_findRelated(self, authenticationToken, query, resultSpec):
    self._oprot.writeMessageBegin('findRelated', TMessageType.CALL, self._seqid)
    args = findRelated_args()
    args.authenticationToken = authenticationToken
    args.query = query
    args.resultSpec = resultSpec
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_findRelated(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = findRelated_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.userException is not None:
      raise result.userException
    if result.systemException is not None:
      raise result.systemException
    if result.notFoundException is not None:
      raise result.notFoundException
    raise TApplicationException(TApplicationException.MISSING_RESULT, "findRelated failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["getSyncState"] = Processor.process_getSyncState
    self._processMap["getSyncStateWithMetrics"] = Processor.process_getSyncStateWithMetrics
    self._processMap["getSyncChunk"] = Processor.process_getSyncChunk
    self._processMap["getFilteredSyncChunk"] = Processor.process_getFilteredSyncChunk
    self._processMap["getLinkedNotebookSyncState"] = Processor.process_getLinkedNotebookSyncState
    self._processMap["getLinkedNotebookSyncChunk"] = Processor.process_getLinkedNotebookSyncChunk
    self._processMap["listNotebooks"] = Processor.process_listNotebooks
    self._processMap["getNotebook"] = Processor.process_getNotebook
    self._processMap["getDefaultNotebook"] = Processor.process_getDefaultNotebook
    self._processMap["createNotebook"] = Processor.process_createNotebook
    self._processMap["updateNotebook"] = Processor.process_updateNotebook
    self._processMap["expungeNotebook"] = Processor.process_expungeNotebook
    self._processMap["listTags"] = Processor.process_listTags
    self._processMap["listTagsByNotebook"] = Processor.process_listTagsByNotebook
    self._processMap["getTag"] = Processor.process_getTag
    self._processMap["createTag"] = Processor.process_createTag
    self._processMap["updateTag"] = Processor.process_updateTag
    self._processMap["untagAll"] = Processor.process_untagAll
    self._processMap["expungeTag"] = Processor.process_expungeTag
    self._processMap["listSearches"] = Processor.process_listSearches
    self._processMap["getSearch"] = Processor.process_getSearch
    self._processMap["createSearch"] = Processor.process_createSearch
    self._processMap["updateSearch"] = Processor.process_updateSearch
    self._processMap["expungeSearch"] = Processor.process_expungeSearch
    self._processMap["findNotes"] = Processor.process_findNotes
    self._processMap["findNoteOffset"] = Processor.process_findNoteOffset
    self._processMap["findNotesMetadata"] = Processor.process_findNotesMetadata
    self._processMap["findNoteCounts"] = Processor.process_findNoteCounts
    self._processMap["getNote"] = Processor.process_getNote
    self._processMap["getNoteApplicationData"] = Processor.process_getNoteApplicationData
    self._processMap["getNoteApplicationDataEntry"] = Processor.process_getNoteApplicationDataEntry
    self._processMap["setNoteApplicationDataEntry"] = Processor.process_setNoteApplicationDataEntry
    self._processMap["unsetNoteApplicationDataEntry"] = Processor.process_unsetNoteApplicationDataEntry
    self._processMap["getNoteContent"] = Processor.process_getNoteContent
    self._processMap["getNoteSearchText"] = Processor.process_getNoteSearchText
    self._processMap["getResourceSearchText"] = Processor.process_getResourceSearchText
    self._processMap["getNoteTagNames"] = Processor.process_getNoteTagNames
    self._processMap["createNote"] = Processor.process_createNote
    self._processMap["updateNote"] = Processor.process_updateNote
    self._processMap["deleteNote"] = Processor.process_deleteNote
    self._processMap["expungeNote"] = Processor.process_expungeNote
    self._processMap["expungeNotes"] = Processor.process_expungeNotes
    self._processMap["expungeInactiveNotes"] = Processor.process_expungeInactiveNotes
    self._processMap["copyNote"] = Processor.process_copyNote
    self._processMap["listNoteVersions"] = Processor.process_listNoteVersions
    self._processMap["getNoteVersion"] = Processor.process_getNoteVersion
    self._processMap["getResource"] = Processor.process_getResource
    self._processMap["getResourceApplicationData"] = Processor.process_getResourceApplicationData
    self._processMap["getResourceApplicationDataEntry"] = Processor.process_getResourceApplicationDataEntry
    self._processMap["setResourceApplicationDataEntry"] = Processor.process_setResourceApplicationDataEntry
    self._processMap["unsetResourceApplicationDataEntry"] = Processor.process_unsetResourceApplicationDataEntry
    self._processMap["updateResource"] = Processor.process_updateResource
    self._processMap["getResourceData"] = Processor.process_getResourceData
    self._processMap["getResourceByHash"] = Processor.process_getResourceByHash
    self._processMap["getResourceRecognition"] = Processor.process_getResourceRecognition
    self._processMap["getResourceAlternateData"] = Processor.process_getResourceAlternateData
    self._processMap["getResourceAttributes"] = Processor.process_getResourceAttributes
    self._processMap["getPublicNotebook"] = Processor.process_getPublicNotebook
    self._processMap["createSharedNotebook"] = Processor.process_createSharedNotebook
    self._processMap["updateSharedNotebook"] = Processor.process_updateSharedNotebook
    self._processMap["setSharedNotebookRecipientSettings"] = Processor.process_setSharedNotebookRecipientSettings
    self._processMap["sendMessageToSharedNotebookMembers"] = Processor.process_sendMessageToSharedNotebookMembers
    self._processMap["listSharedNotebooks"] = Processor.process_listSharedNotebooks
    self._processMap["expungeSharedNotebooks"] = Processor.process_expungeSharedNotebooks
    self._processMap["createLinkedNotebook"] = Processor.process_createLinkedNotebook
    self._processMap["updateLinkedNotebook"] = Processor.process_updateLinkedNotebook
    self._processMap["listLinkedNotebooks"] = Processor.process_listLinkedNotebooks
    self._processMap["expungeLinkedNotebook"] = Processor.process_expungeLinkedNotebook
    self._processMap["authenticateToSharedNotebook"] = Processor.process_authenticateToSharedNotebook
    self._processMap["getSharedNotebookByAuth"] = Processor.process_getSharedNotebookByAuth
    self._processMap["emailNote"] = Processor.process_emailNote
    self._processMap["shareNote"] = Processor.process_shareNote
    self._processMap["stopSharingNote"] = Processor.process_stopSharingNote
    self._processMap["authenticateToSharedNote"] = Processor.process_authenticateToSharedNote
    self._processMap["findRelated"] = Processor.process_findRelated

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_getSyncState(self, seqid, iprot, oprot):
    args = getSyncState_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSyncState_result()
    try:
      result.success = self._handler.getSyncState(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getSyncState", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSyncStateWithMetrics(self, seqid, iprot, oprot):
    args = getSyncStateWithMetrics_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSyncStateWithMetrics_result()
    try:
      result.success = self._handler.getSyncStateWithMetrics(args.authenticationToken, args.clientMetrics)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getSyncStateWithMetrics", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSyncChunk(self, seqid, iprot, oprot):
    args = getSyncChunk_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSyncChunk_result()
    try:
      result.success = self._handler.getSyncChunk(args.authenticationToken, args.afterUSN, args.maxEntries, args.fullSyncOnly)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getSyncChunk", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getFilteredSyncChunk(self, seqid, iprot, oprot):
    args = getFilteredSyncChunk_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getFilteredSyncChunk_result()
    try:
      result.success = self._handler.getFilteredSyncChunk(args.authenticationToken, args.afterUSN, args.maxEntries, args.filter)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getFilteredSyncChunk", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getLinkedNotebookSyncState(self, seqid, iprot, oprot):
    args = getLinkedNotebookSyncState_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getLinkedNotebookSyncState_result()
    try:
      result.success = self._handler.getLinkedNotebookSyncState(args.authenticationToken, args.linkedNotebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getLinkedNotebookSyncState", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getLinkedNotebookSyncChunk(self, seqid, iprot, oprot):
    args = getLinkedNotebookSyncChunk_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getLinkedNotebookSyncChunk_result()
    try:
      result.success = self._handler.getLinkedNotebookSyncChunk(args.authenticationToken, args.linkedNotebook, args.afterUSN, args.maxEntries, args.fullSyncOnly)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getLinkedNotebookSyncChunk", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listNotebooks(self, seqid, iprot, oprot):
    args = listNotebooks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listNotebooks_result()
    try:
      result.success = self._handler.listNotebooks(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("listNotebooks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNotebook(self, seqid, iprot, oprot):
    args = getNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNotebook_result()
    try:
      result.success = self._handler.getNotebook(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getDefaultNotebook(self, seqid, iprot, oprot):
    args = getDefaultNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getDefaultNotebook_result()
    try:
      result.success = self._handler.getDefaultNotebook(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getDefaultNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createNotebook(self, seqid, iprot, oprot):
    args = createNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createNotebook_result()
    try:
      result.success = self._handler.createNotebook(args.authenticationToken, args.notebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("createNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateNotebook(self, seqid, iprot, oprot):
    args = updateNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateNotebook_result()
    try:
      result.success = self._handler.updateNotebook(args.authenticationToken, args.notebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("updateNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeNotebook(self, seqid, iprot, oprot):
    args = expungeNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeNotebook_result()
    try:
      result.success = self._handler.expungeNotebook(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("expungeNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listTags(self, seqid, iprot, oprot):
    args = listTags_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listTags_result()
    try:
      result.success = self._handler.listTags(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("listTags", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listTagsByNotebook(self, seqid, iprot, oprot):
    args = listTagsByNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listTagsByNotebook_result()
    try:
      result.success = self._handler.listTagsByNotebook(args.authenticationToken, args.notebookGuid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("listTagsByNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTag(self, seqid, iprot, oprot):
    args = getTag_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTag_result()
    try:
      result.success = self._handler.getTag(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getTag", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createTag(self, seqid, iprot, oprot):
    args = createTag_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createTag_result()
    try:
      result.success = self._handler.createTag(args.authenticationToken, args.tag)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("createTag", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateTag(self, seqid, iprot, oprot):
    args = updateTag_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateTag_result()
    try:
      result.success = self._handler.updateTag(args.authenticationToken, args.tag)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("updateTag", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_untagAll(self, seqid, iprot, oprot):
    args = untagAll_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = untagAll_result()
    try:
      self._handler.untagAll(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("untagAll", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeTag(self, seqid, iprot, oprot):
    args = expungeTag_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeTag_result()
    try:
      result.success = self._handler.expungeTag(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("expungeTag", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listSearches(self, seqid, iprot, oprot):
    args = listSearches_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listSearches_result()
    try:
      result.success = self._handler.listSearches(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("listSearches", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSearch(self, seqid, iprot, oprot):
    args = getSearch_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSearch_result()
    try:
      result.success = self._handler.getSearch(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getSearch", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createSearch(self, seqid, iprot, oprot):
    args = createSearch_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createSearch_result()
    try:
      result.success = self._handler.createSearch(args.authenticationToken, args.search)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("createSearch", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateSearch(self, seqid, iprot, oprot):
    args = updateSearch_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateSearch_result()
    try:
      result.success = self._handler.updateSearch(args.authenticationToken, args.search)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("updateSearch", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeSearch(self, seqid, iprot, oprot):
    args = expungeSearch_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeSearch_result()
    try:
      result.success = self._handler.expungeSearch(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("expungeSearch", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findNotes(self, seqid, iprot, oprot):
    args = findNotes_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findNotes_result()
    try:
      result.success = self._handler.findNotes(args.authenticationToken, args.filter, args.offset, args.maxNotes)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("findNotes", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findNoteOffset(self, seqid, iprot, oprot):
    args = findNoteOffset_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findNoteOffset_result()
    try:
      result.success = self._handler.findNoteOffset(args.authenticationToken, args.filter, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("findNoteOffset", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findNotesMetadata(self, seqid, iprot, oprot):
    args = findNotesMetadata_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findNotesMetadata_result()
    try:
      result.success = self._handler.findNotesMetadata(args.authenticationToken, args.filter, args.offset, args.maxNotes, args.resultSpec)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("findNotesMetadata", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findNoteCounts(self, seqid, iprot, oprot):
    args = findNoteCounts_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findNoteCounts_result()
    try:
      result.success = self._handler.findNoteCounts(args.authenticationToken, args.filter, args.withTrash)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("findNoteCounts", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNote(self, seqid, iprot, oprot):
    args = getNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNote_result()
    try:
      result.success = self._handler.getNote(args.authenticationToken, args.guid, args.withContent, args.withResourcesData, args.withResourcesRecognition, args.withResourcesAlternateData)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteApplicationData(self, seqid, iprot, oprot):
    args = getNoteApplicationData_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteApplicationData_result()
    try:
      result.success = self._handler.getNoteApplicationData(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteApplicationData", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteApplicationDataEntry(self, seqid, iprot, oprot):
    args = getNoteApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteApplicationDataEntry_result()
    try:
      result.success = self._handler.getNoteApplicationDataEntry(args.authenticationToken, args.guid, args.key)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setNoteApplicationDataEntry(self, seqid, iprot, oprot):
    args = setNoteApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setNoteApplicationDataEntry_result()
    try:
      result.success = self._handler.setNoteApplicationDataEntry(args.authenticationToken, args.guid, args.key, args.value)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("setNoteApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_unsetNoteApplicationDataEntry(self, seqid, iprot, oprot):
    args = unsetNoteApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = unsetNoteApplicationDataEntry_result()
    try:
      result.success = self._handler.unsetNoteApplicationDataEntry(args.authenticationToken, args.guid, args.key)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("unsetNoteApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteContent(self, seqid, iprot, oprot):
    args = getNoteContent_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteContent_result()
    try:
      result.success = self._handler.getNoteContent(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteContent", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteSearchText(self, seqid, iprot, oprot):
    args = getNoteSearchText_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteSearchText_result()
    try:
      result.success = self._handler.getNoteSearchText(args.authenticationToken, args.guid, args.noteOnly, args.tokenizeForIndexing)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteSearchText", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceSearchText(self, seqid, iprot, oprot):
    args = getResourceSearchText_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceSearchText_result()
    try:
      result.success = self._handler.getResourceSearchText(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceSearchText", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteTagNames(self, seqid, iprot, oprot):
    args = getNoteTagNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteTagNames_result()
    try:
      result.success = self._handler.getNoteTagNames(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteTagNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createNote(self, seqid, iprot, oprot):
    args = createNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createNote_result()
    try:
      result.success = self._handler.createNote(args.authenticationToken, args.note)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("createNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateNote(self, seqid, iprot, oprot):
    args = updateNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateNote_result()
    try:
      result.success = self._handler.updateNote(args.authenticationToken, args.note)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("updateNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteNote(self, seqid, iprot, oprot):
    args = deleteNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteNote_result()
    try:
      result.success = self._handler.deleteNote(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("deleteNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeNote(self, seqid, iprot, oprot):
    args = expungeNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeNote_result()
    try:
      result.success = self._handler.expungeNote(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("expungeNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeNotes(self, seqid, iprot, oprot):
    args = expungeNotes_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeNotes_result()
    try:
      result.success = self._handler.expungeNotes(args.authenticationToken, args.noteGuids)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("expungeNotes", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeInactiveNotes(self, seqid, iprot, oprot):
    args = expungeInactiveNotes_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeInactiveNotes_result()
    try:
      result.success = self._handler.expungeInactiveNotes(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("expungeInactiveNotes", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_copyNote(self, seqid, iprot, oprot):
    args = copyNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = copyNote_result()
    try:
      result.success = self._handler.copyNote(args.authenticationToken, args.noteGuid, args.toNotebookGuid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("copyNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listNoteVersions(self, seqid, iprot, oprot):
    args = listNoteVersions_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listNoteVersions_result()
    try:
      result.success = self._handler.listNoteVersions(args.authenticationToken, args.noteGuid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("listNoteVersions", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getNoteVersion(self, seqid, iprot, oprot):
    args = getNoteVersion_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getNoteVersion_result()
    try:
      result.success = self._handler.getNoteVersion(args.authenticationToken, args.noteGuid, args.updateSequenceNum, args.withResourcesData, args.withResourcesRecognition, args.withResourcesAlternateData)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getNoteVersion", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResource(self, seqid, iprot, oprot):
    args = getResource_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResource_result()
    try:
      result.success = self._handler.getResource(args.authenticationToken, args.guid, args.withData, args.withRecognition, args.withAttributes, args.withAlternateData)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResource", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceApplicationData(self, seqid, iprot, oprot):
    args = getResourceApplicationData_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceApplicationData_result()
    try:
      result.success = self._handler.getResourceApplicationData(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceApplicationData", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceApplicationDataEntry(self, seqid, iprot, oprot):
    args = getResourceApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceApplicationDataEntry_result()
    try:
      result.success = self._handler.getResourceApplicationDataEntry(args.authenticationToken, args.guid, args.key)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setResourceApplicationDataEntry(self, seqid, iprot, oprot):
    args = setResourceApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setResourceApplicationDataEntry_result()
    try:
      result.success = self._handler.setResourceApplicationDataEntry(args.authenticationToken, args.guid, args.key, args.value)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("setResourceApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_unsetResourceApplicationDataEntry(self, seqid, iprot, oprot):
    args = unsetResourceApplicationDataEntry_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = unsetResourceApplicationDataEntry_result()
    try:
      result.success = self._handler.unsetResourceApplicationDataEntry(args.authenticationToken, args.guid, args.key)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("unsetResourceApplicationDataEntry", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateResource(self, seqid, iprot, oprot):
    args = updateResource_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateResource_result()
    try:
      result.success = self._handler.updateResource(args.authenticationToken, args.resource)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("updateResource", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceData(self, seqid, iprot, oprot):
    args = getResourceData_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceData_result()
    try:
      result.success = self._handler.getResourceData(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceData", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceByHash(self, seqid, iprot, oprot):
    args = getResourceByHash_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceByHash_result()
    try:
      result.success = self._handler.getResourceByHash(args.authenticationToken, args.noteGuid, args.contentHash, args.withData, args.withRecognition, args.withAlternateData)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceByHash", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceRecognition(self, seqid, iprot, oprot):
    args = getResourceRecognition_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceRecognition_result()
    try:
      result.success = self._handler.getResourceRecognition(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceRecognition", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceAlternateData(self, seqid, iprot, oprot):
    args = getResourceAlternateData_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceAlternateData_result()
    try:
      result.success = self._handler.getResourceAlternateData(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceAlternateData", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getResourceAttributes(self, seqid, iprot, oprot):
    args = getResourceAttributes_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getResourceAttributes_result()
    try:
      result.success = self._handler.getResourceAttributes(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getResourceAttributes", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getPublicNotebook(self, seqid, iprot, oprot):
    args = getPublicNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getPublicNotebook_result()
    try:
      result.success = self._handler.getPublicNotebook(args.userId, args.publicUri)
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("getPublicNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createSharedNotebook(self, seqid, iprot, oprot):
    args = createSharedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createSharedNotebook_result()
    try:
      result.success = self._handler.createSharedNotebook(args.authenticationToken, args.sharedNotebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("createSharedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateSharedNotebook(self, seqid, iprot, oprot):
    args = updateSharedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateSharedNotebook_result()
    try:
      result.success = self._handler.updateSharedNotebook(args.authenticationToken, args.sharedNotebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("updateSharedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_setSharedNotebookRecipientSettings(self, seqid, iprot, oprot):
    args = setSharedNotebookRecipientSettings_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = setSharedNotebookRecipientSettings_result()
    try:
      result.success = self._handler.setSharedNotebookRecipientSettings(args.authenticationToken, args.sharedNotebookId, args.recipientSettings)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("setSharedNotebookRecipientSettings", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_sendMessageToSharedNotebookMembers(self, seqid, iprot, oprot):
    args = sendMessageToSharedNotebookMembers_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = sendMessageToSharedNotebookMembers_result()
    try:
      result.success = self._handler.sendMessageToSharedNotebookMembers(args.authenticationToken, args.notebookGuid, args.messageText, args.recipients)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("sendMessageToSharedNotebookMembers", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listSharedNotebooks(self, seqid, iprot, oprot):
    args = listSharedNotebooks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listSharedNotebooks_result()
    try:
      result.success = self._handler.listSharedNotebooks(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("listSharedNotebooks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeSharedNotebooks(self, seqid, iprot, oprot):
    args = expungeSharedNotebooks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeSharedNotebooks_result()
    try:
      result.success = self._handler.expungeSharedNotebooks(args.authenticationToken, args.sharedNotebookIds)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("expungeSharedNotebooks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createLinkedNotebook(self, seqid, iprot, oprot):
    args = createLinkedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createLinkedNotebook_result()
    try:
      result.success = self._handler.createLinkedNotebook(args.authenticationToken, args.linkedNotebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("createLinkedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_updateLinkedNotebook(self, seqid, iprot, oprot):
    args = updateLinkedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = updateLinkedNotebook_result()
    try:
      result.success = self._handler.updateLinkedNotebook(args.authenticationToken, args.linkedNotebook)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("updateLinkedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_listLinkedNotebooks(self, seqid, iprot, oprot):
    args = listLinkedNotebooks_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = listLinkedNotebooks_result()
    try:
      result.success = self._handler.listLinkedNotebooks(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("listLinkedNotebooks", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_expungeLinkedNotebook(self, seqid, iprot, oprot):
    args = expungeLinkedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = expungeLinkedNotebook_result()
    try:
      result.success = self._handler.expungeLinkedNotebook(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("expungeLinkedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_authenticateToSharedNotebook(self, seqid, iprot, oprot):
    args = authenticateToSharedNotebook_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = authenticateToSharedNotebook_result()
    try:
      result.success = self._handler.authenticateToSharedNotebook(args.shareKey, args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("authenticateToSharedNotebook", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getSharedNotebookByAuth(self, seqid, iprot, oprot):
    args = getSharedNotebookByAuth_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getSharedNotebookByAuth_result()
    try:
      result.success = self._handler.getSharedNotebookByAuth(args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("getSharedNotebookByAuth", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_emailNote(self, seqid, iprot, oprot):
    args = emailNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = emailNote_result()
    try:
      self._handler.emailNote(args.authenticationToken, args.parameters)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("emailNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_shareNote(self, seqid, iprot, oprot):
    args = shareNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = shareNote_result()
    try:
      result.success = self._handler.shareNote(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("shareNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_stopSharingNote(self, seqid, iprot, oprot):
    args = stopSharingNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = stopSharingNote_result()
    try:
      self._handler.stopSharingNote(args.authenticationToken, args.guid)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("stopSharingNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_authenticateToSharedNote(self, seqid, iprot, oprot):
    args = authenticateToSharedNote_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = authenticateToSharedNote_result()
    try:
      result.success = self._handler.authenticateToSharedNote(args.guid, args.noteKey, args.authenticationToken)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    oprot.writeMessageBegin("authenticateToSharedNote", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_findRelated(self, seqid, iprot, oprot):
    args = findRelated_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = findRelated_result()
    try:
      result.success = self._handler.findRelated(args.authenticationToken, args.query, args.resultSpec)
    except evernote.edam.error.ttypes.EDAMUserException as userException:
      result.userException = userException
    except evernote.edam.error.ttypes.EDAMSystemException as systemException:
      result.systemException = systemException
    except evernote.edam.error.ttypes.EDAMNotFoundException as notFoundException:
      result.notFoundException = notFoundException
    oprot.writeMessageBegin("findRelated", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class getSyncState_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncState_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSyncState_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncState, SyncState.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncState()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncState_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSyncStateWithMetrics_args(object):
  """
  Attributes:
   - authenticationToken
   - clientMetrics
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'clientMetrics', (ClientUsageMetrics, ClientUsageMetrics.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, clientMetrics=None,):
    self.authenticationToken = authenticationToken
    self.clientMetrics = clientMetrics

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.clientMetrics = ClientUsageMetrics()
          self.clientMetrics.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncStateWithMetrics_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.clientMetrics is not None:
      oprot.writeFieldBegin('clientMetrics', TType.STRUCT, 2)
      self.clientMetrics.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSyncStateWithMetrics_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncState, SyncState.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncState()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncStateWithMetrics_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSyncChunk_args(object):
  """
  Attributes:
   - authenticationToken
   - afterUSN
   - maxEntries
   - fullSyncOnly
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.I32, 'afterUSN', None, None, ), # 2
    (3, TType.I32, 'maxEntries', None, None, ), # 3
    (4, TType.BOOL, 'fullSyncOnly', None, None, ), # 4
  )

  def __init__(self, authenticationToken=None, afterUSN=None, maxEntries=None, fullSyncOnly=None,):
    self.authenticationToken = authenticationToken
    self.afterUSN = afterUSN
    self.maxEntries = maxEntries
    self.fullSyncOnly = fullSyncOnly

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.afterUSN = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.maxEntries = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.fullSyncOnly = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncChunk_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.afterUSN is not None:
      oprot.writeFieldBegin('afterUSN', TType.I32, 2)
      oprot.writeI32(self.afterUSN)
      oprot.writeFieldEnd()
    if self.maxEntries is not None:
      oprot.writeFieldBegin('maxEntries', TType.I32, 3)
      oprot.writeI32(self.maxEntries)
      oprot.writeFieldEnd()
    if self.fullSyncOnly is not None:
      oprot.writeFieldBegin('fullSyncOnly', TType.BOOL, 4)
      oprot.writeBool(self.fullSyncOnly)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSyncChunk_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncChunk, SyncChunk.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncChunk()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSyncChunk_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getFilteredSyncChunk_args(object):
  """
  Attributes:
   - authenticationToken
   - afterUSN
   - maxEntries
   - filter
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.I32, 'afterUSN', None, None, ), # 2
    (3, TType.I32, 'maxEntries', None, None, ), # 3
    (4, TType.STRUCT, 'filter', (SyncChunkFilter, SyncChunkFilter.thrift_spec), None, ), # 4
  )

  def __init__(self, authenticationToken=None, afterUSN=None, maxEntries=None, filter=None,):
    self.authenticationToken = authenticationToken
    self.afterUSN = afterUSN
    self.maxEntries = maxEntries
    self.filter = filter

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.afterUSN = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.maxEntries = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.filter = SyncChunkFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getFilteredSyncChunk_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.afterUSN is not None:
      oprot.writeFieldBegin('afterUSN', TType.I32, 2)
      oprot.writeI32(self.afterUSN)
      oprot.writeFieldEnd()
    if self.maxEntries is not None:
      oprot.writeFieldBegin('maxEntries', TType.I32, 3)
      oprot.writeI32(self.maxEntries)
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 4)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getFilteredSyncChunk_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncChunk, SyncChunk.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncChunk()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getFilteredSyncChunk_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getLinkedNotebookSyncState_args(object):
  """
  Attributes:
   - authenticationToken
   - linkedNotebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'linkedNotebook', (evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, linkedNotebook=None,):
    self.authenticationToken = authenticationToken
    self.linkedNotebook = linkedNotebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.linkedNotebook = evernote.edam.type.ttypes.LinkedNotebook()
          self.linkedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getLinkedNotebookSyncState_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.linkedNotebook is not None:
      oprot.writeFieldBegin('linkedNotebook', TType.STRUCT, 2)
      self.linkedNotebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getLinkedNotebookSyncState_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncState, SyncState.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncState()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getLinkedNotebookSyncState_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getLinkedNotebookSyncChunk_args(object):
  """
  Attributes:
   - authenticationToken
   - linkedNotebook
   - afterUSN
   - maxEntries
   - fullSyncOnly
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'linkedNotebook', (evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec), None, ), # 2
    (3, TType.I32, 'afterUSN', None, None, ), # 3
    (4, TType.I32, 'maxEntries', None, None, ), # 4
    (5, TType.BOOL, 'fullSyncOnly', None, None, ), # 5
  )

  def __init__(self, authenticationToken=None, linkedNotebook=None, afterUSN=None, maxEntries=None, fullSyncOnly=None,):
    self.authenticationToken = authenticationToken
    self.linkedNotebook = linkedNotebook
    self.afterUSN = afterUSN
    self.maxEntries = maxEntries
    self.fullSyncOnly = fullSyncOnly

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.linkedNotebook = evernote.edam.type.ttypes.LinkedNotebook()
          self.linkedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.afterUSN = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.maxEntries = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.fullSyncOnly = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getLinkedNotebookSyncChunk_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.linkedNotebook is not None:
      oprot.writeFieldBegin('linkedNotebook', TType.STRUCT, 2)
      self.linkedNotebook.write(oprot)
      oprot.writeFieldEnd()
    if self.afterUSN is not None:
      oprot.writeFieldBegin('afterUSN', TType.I32, 3)
      oprot.writeI32(self.afterUSN)
      oprot.writeFieldEnd()
    if self.maxEntries is not None:
      oprot.writeFieldBegin('maxEntries', TType.I32, 4)
      oprot.writeI32(self.maxEntries)
      oprot.writeFieldEnd()
    if self.fullSyncOnly is not None:
      oprot.writeFieldBegin('fullSyncOnly', TType.BOOL, 5)
      oprot.writeBool(self.fullSyncOnly)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getLinkedNotebookSyncChunk_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (SyncChunk, SyncChunk.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = SyncChunk()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getLinkedNotebookSyncChunk_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listNotebooks_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listNotebooks_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listNotebooks_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype196, _size193) = iprot.readListBegin()
          for _i197 in range(_size193):
            _elem198 = evernote.edam.type.ttypes.Notebook()
            _elem198.read(iprot)
            self.success.append(_elem198)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listNotebooks_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter199 in self.success:
        iter199.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Notebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDefaultNotebook_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDefaultNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getDefaultNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Notebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getDefaultNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - notebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'notebook', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, notebook=None,):
    self.authenticationToken = authenticationToken
    self.notebook = notebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notebook = evernote.edam.type.ttypes.Notebook()
          self.notebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.notebook is not None:
      oprot.writeFieldBegin('notebook', TType.STRUCT, 2)
      self.notebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Notebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - notebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'notebook', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, notebook=None,):
    self.authenticationToken = authenticationToken
    self.notebook = notebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notebook = evernote.edam.type.ttypes.Notebook()
          self.notebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.notebook is not None:
      oprot.writeFieldBegin('notebook', TType.STRUCT, 2)
      self.notebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listTags_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listTags_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listTags_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype203, _size200) = iprot.readListBegin()
          for _i204 in range(_size200):
            _elem205 = evernote.edam.type.ttypes.Tag()
            _elem205.read(iprot)
            self.success.append(_elem205)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listTags_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter206 in self.success:
        iter206.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listTagsByNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - notebookGuid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'notebookGuid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, notebookGuid=None,):
    self.authenticationToken = authenticationToken
    self.notebookGuid = notebookGuid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listTagsByNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 2)
      oprot.writeString(self.notebookGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listTagsByNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype210, _size207) = iprot.readListBegin()
          for _i211 in range(_size207):
            _elem212 = evernote.edam.type.ttypes.Tag()
            _elem212.read(iprot)
            self.success.append(_elem212)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listTagsByNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter213 in self.success:
        iter213.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTag_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTag_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTag_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Tag()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTag_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTag_args(object):
  """
  Attributes:
   - authenticationToken
   - tag
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'tag', (evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, tag=None,):
    self.authenticationToken = authenticationToken
    self.tag = tag

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tag = evernote.edam.type.ttypes.Tag()
          self.tag.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTag_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.tag is not None:
      oprot.writeFieldBegin('tag', TType.STRUCT, 2)
      self.tag.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTag_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Tag()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTag_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateTag_args(object):
  """
  Attributes:
   - authenticationToken
   - tag
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'tag', (evernote.edam.type.ttypes.Tag, evernote.edam.type.ttypes.Tag.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, tag=None,):
    self.authenticationToken = authenticationToken
    self.tag = tag

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.tag = evernote.edam.type.ttypes.Tag()
          self.tag.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateTag_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.tag is not None:
      oprot.writeFieldBegin('tag', TType.STRUCT, 2)
      self.tag.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateTag_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateTag_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class untagAll_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('untagAll_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class untagAll_result(object):
  """
  Attributes:
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, userException=None, systemException=None, notFoundException=None,):
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('untagAll_result')
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeTag_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeTag_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeTag_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeTag_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSearches_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSearches_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSearches_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype217, _size214) = iprot.readListBegin()
          for _i218 in range(_size214):
            _elem219 = evernote.edam.type.ttypes.SavedSearch()
            _elem219.read(iprot)
            self.success.append(_elem219)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSearches_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter220 in self.success:
        iter220.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSearch_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSearch_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSearch_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.SavedSearch()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSearch_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createSearch_args(object):
  """
  Attributes:
   - authenticationToken
   - search
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'search', (evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, search=None,):
    self.authenticationToken = authenticationToken
    self.search = search

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.search = evernote.edam.type.ttypes.SavedSearch()
          self.search.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createSearch_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.search is not None:
      oprot.writeFieldBegin('search', TType.STRUCT, 2)
      self.search.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createSearch_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.SavedSearch()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createSearch_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateSearch_args(object):
  """
  Attributes:
   - authenticationToken
   - search
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'search', (evernote.edam.type.ttypes.SavedSearch, evernote.edam.type.ttypes.SavedSearch.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, search=None,):
    self.authenticationToken = authenticationToken
    self.search = search

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.search = evernote.edam.type.ttypes.SavedSearch()
          self.search.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateSearch_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.search is not None:
      oprot.writeFieldBegin('search', TType.STRUCT, 2)
      self.search.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateSearch_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateSearch_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeSearch_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeSearch_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeSearch_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeSearch_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNotes_args(object):
  """
  Attributes:
   - authenticationToken
   - filter
   - offset
   - maxNotes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'filter', (NoteFilter, NoteFilter.thrift_spec), None, ), # 2
    (3, TType.I32, 'offset', None, None, ), # 3
    (4, TType.I32, 'maxNotes', None, None, ), # 4
  )

  def __init__(self, authenticationToken=None, filter=None, offset=None, maxNotes=None,):
    self.authenticationToken = authenticationToken
    self.filter = filter
    self.offset = offset
    self.maxNotes = maxNotes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.filter = NoteFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.offset = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.maxNotes = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNotes_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 2)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    if self.offset is not None:
      oprot.writeFieldBegin('offset', TType.I32, 3)
      oprot.writeI32(self.offset)
      oprot.writeFieldEnd()
    if self.maxNotes is not None:
      oprot.writeFieldBegin('maxNotes', TType.I32, 4)
      oprot.writeI32(self.maxNotes)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNotes_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (NoteList, NoteList.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = NoteList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNotes_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNoteOffset_args(object):
  """
  Attributes:
   - authenticationToken
   - filter
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'filter', (NoteFilter, NoteFilter.thrift_spec), None, ), # 2
    (3, TType.STRING, 'guid', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, filter=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.filter = filter
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.filter = NoteFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNoteOffset_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 2)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 3)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNoteOffset_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNoteOffset_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNotesMetadata_args(object):
  """
  Attributes:
   - authenticationToken
   - filter
   - offset
   - maxNotes
   - resultSpec
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'filter', (NoteFilter, NoteFilter.thrift_spec), None, ), # 2
    (3, TType.I32, 'offset', None, None, ), # 3
    (4, TType.I32, 'maxNotes', None, None, ), # 4
    (5, TType.STRUCT, 'resultSpec', (NotesMetadataResultSpec, NotesMetadataResultSpec.thrift_spec), None, ), # 5
  )

  def __init__(self, authenticationToken=None, filter=None, offset=None, maxNotes=None, resultSpec=None,):
    self.authenticationToken = authenticationToken
    self.filter = filter
    self.offset = offset
    self.maxNotes = maxNotes
    self.resultSpec = resultSpec

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.filter = NoteFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.offset = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.maxNotes = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.resultSpec = NotesMetadataResultSpec()
          self.resultSpec.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNotesMetadata_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 2)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    if self.offset is not None:
      oprot.writeFieldBegin('offset', TType.I32, 3)
      oprot.writeI32(self.offset)
      oprot.writeFieldEnd()
    if self.maxNotes is not None:
      oprot.writeFieldBegin('maxNotes', TType.I32, 4)
      oprot.writeI32(self.maxNotes)
      oprot.writeFieldEnd()
    if self.resultSpec is not None:
      oprot.writeFieldBegin('resultSpec', TType.STRUCT, 5)
      self.resultSpec.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNotesMetadata_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (NotesMetadataList, NotesMetadataList.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = NotesMetadataList()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNotesMetadata_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNoteCounts_args(object):
  """
  Attributes:
   - authenticationToken
   - filter
   - withTrash
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'filter', (NoteFilter, NoteFilter.thrift_spec), None, ), # 2
    (3, TType.BOOL, 'withTrash', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, filter=None, withTrash=None,):
    self.authenticationToken = authenticationToken
    self.filter = filter
    self.withTrash = withTrash

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.filter = NoteFilter()
          self.filter.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.withTrash = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNoteCounts_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.filter is not None:
      oprot.writeFieldBegin('filter', TType.STRUCT, 2)
      self.filter.write(oprot)
      oprot.writeFieldEnd()
    if self.withTrash is not None:
      oprot.writeFieldBegin('withTrash', TType.BOOL, 3)
      oprot.writeBool(self.withTrash)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findNoteCounts_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (NoteCollectionCounts, NoteCollectionCounts.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = NoteCollectionCounts()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findNoteCounts_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNote_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - withContent
   - withResourcesData
   - withResourcesRecognition
   - withResourcesAlternateData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.BOOL, 'withContent', None, None, ), # 3
    (4, TType.BOOL, 'withResourcesData', None, None, ), # 4
    (5, TType.BOOL, 'withResourcesRecognition', None, None, ), # 5
    (6, TType.BOOL, 'withResourcesAlternateData', None, None, ), # 6
  )

  def __init__(self, authenticationToken=None, guid=None, withContent=None, withResourcesData=None, withResourcesRecognition=None, withResourcesAlternateData=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.withContent = withContent
    self.withResourcesData = withResourcesData
    self.withResourcesRecognition = withResourcesRecognition
    self.withResourcesAlternateData = withResourcesAlternateData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.withContent = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.withResourcesData = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.withResourcesRecognition = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.withResourcesAlternateData = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.withContent is not None:
      oprot.writeFieldBegin('withContent', TType.BOOL, 3)
      oprot.writeBool(self.withContent)
      oprot.writeFieldEnd()
    if self.withResourcesData is not None:
      oprot.writeFieldBegin('withResourcesData', TType.BOOL, 4)
      oprot.writeBool(self.withResourcesData)
      oprot.writeFieldEnd()
    if self.withResourcesRecognition is not None:
      oprot.writeFieldBegin('withResourcesRecognition', TType.BOOL, 5)
      oprot.writeBool(self.withResourcesRecognition)
      oprot.writeFieldEnd()
    if self.withResourcesAlternateData is not None:
      oprot.writeFieldBegin('withResourcesAlternateData', TType.BOOL, 6)
      oprot.writeBool(self.withResourcesAlternateData)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Note()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteApplicationData_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteApplicationData_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteApplicationData_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.LazyMap, evernote.edam.type.ttypes.LazyMap.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.LazyMap()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteApplicationData_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, guid=None, key=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setNoteApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
   - value
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
    (4, TType.STRING, 'value', None, None, ), # 4
  )

  def __init__(self, authenticationToken=None, guid=None, key=None, value=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.value = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setNoteApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 4)
      oprot.writeString(self.value.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setNoteApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setNoteApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsetNoteApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, guid=None, key=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsetNoteApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsetNoteApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsetNoteApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteContent_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteContent_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteContent_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteContent_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteSearchText_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - noteOnly
   - tokenizeForIndexing
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.BOOL, 'noteOnly', None, None, ), # 3
    (4, TType.BOOL, 'tokenizeForIndexing', None, None, ), # 4
  )

  def __init__(self, authenticationToken=None, guid=None, noteOnly=None, tokenizeForIndexing=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.noteOnly = noteOnly
    self.tokenizeForIndexing = tokenizeForIndexing

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.noteOnly = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.tokenizeForIndexing = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteSearchText_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteOnly is not None:
      oprot.writeFieldBegin('noteOnly', TType.BOOL, 3)
      oprot.writeBool(self.noteOnly)
      oprot.writeFieldEnd()
    if self.tokenizeForIndexing is not None:
      oprot.writeFieldBegin('tokenizeForIndexing', TType.BOOL, 4)
      oprot.writeBool(self.tokenizeForIndexing)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteSearchText_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteSearchText_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceSearchText_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceSearchText_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceSearchText_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceSearchText_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteTagNames_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteTagNames_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteTagNames_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype224, _size221) = iprot.readListBegin()
          for _i225 in range(_size221):
            _elem226 = iprot.readString().decode('utf-8')
            self.success.append(_elem226)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteTagNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter227 in self.success:
        oprot.writeString(iter227.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createNote_args(object):
  """
  Attributes:
   - authenticationToken
   - note
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'note', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, note=None,):
    self.authenticationToken = authenticationToken
    self.note = note

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.note = evernote.edam.type.ttypes.Note()
          self.note.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.note is not None:
      oprot.writeFieldBegin('note', TType.STRUCT, 2)
      self.note.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Note()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateNote_args(object):
  """
  Attributes:
   - authenticationToken
   - note
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'note', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, note=None,):
    self.authenticationToken = authenticationToken
    self.note = note

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.note = evernote.edam.type.ttypes.Note()
          self.note.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.note is not None:
      oprot.writeFieldBegin('note', TType.STRUCT, 2)
      self.note.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Note()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteNote_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNote_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNotes_args(object):
  """
  Attributes:
   - authenticationToken
   - noteGuids
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.LIST, 'noteGuids', (TType.STRING,None), None, ), # 2
  )

  def __init__(self, authenticationToken=None, noteGuids=None,):
    self.authenticationToken = authenticationToken
    self.noteGuids = noteGuids

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.noteGuids = []
          (_etype231, _size228) = iprot.readListBegin()
          for _i232 in range(_size228):
            _elem233 = iprot.readString().decode('utf-8')
            self.noteGuids.append(_elem233)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNotes_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteGuids is not None:
      oprot.writeFieldBegin('noteGuids', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.noteGuids))
      for iter234 in self.noteGuids:
        oprot.writeString(iter234.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeNotes_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeNotes_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeInactiveNotes_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeInactiveNotes_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeInactiveNotes_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, userException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeInactiveNotes_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class copyNote_args(object):
  """
  Attributes:
   - authenticationToken
   - noteGuid
   - toNotebookGuid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'noteGuid', None, None, ), # 2
    (3, TType.STRING, 'toNotebookGuid', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, noteGuid=None, toNotebookGuid=None,):
    self.authenticationToken = authenticationToken
    self.noteGuid = noteGuid
    self.toNotebookGuid = toNotebookGuid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.toNotebookGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('copyNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 2)
      oprot.writeString(self.noteGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.toNotebookGuid is not None:
      oprot.writeFieldBegin('toNotebookGuid', TType.STRING, 3)
      oprot.writeString(self.toNotebookGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class copyNote_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Note()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('copyNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listNoteVersions_args(object):
  """
  Attributes:
   - authenticationToken
   - noteGuid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'noteGuid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, noteGuid=None,):
    self.authenticationToken = authenticationToken
    self.noteGuid = noteGuid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listNoteVersions_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 2)
      oprot.writeString(self.noteGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listNoteVersions_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(NoteVersionId, NoteVersionId.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype238, _size235) = iprot.readListBegin()
          for _i239 in range(_size235):
            _elem240 = NoteVersionId()
            _elem240.read(iprot)
            self.success.append(_elem240)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listNoteVersions_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter241 in self.success:
        iter241.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteVersion_args(object):
  """
  Attributes:
   - authenticationToken
   - noteGuid
   - updateSequenceNum
   - withResourcesData
   - withResourcesRecognition
   - withResourcesAlternateData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'noteGuid', None, None, ), # 2
    (3, TType.I32, 'updateSequenceNum', None, None, ), # 3
    (4, TType.BOOL, 'withResourcesData', None, None, ), # 4
    (5, TType.BOOL, 'withResourcesRecognition', None, None, ), # 5
    (6, TType.BOOL, 'withResourcesAlternateData', None, None, ), # 6
  )

  def __init__(self, authenticationToken=None, noteGuid=None, updateSequenceNum=None, withResourcesData=None, withResourcesRecognition=None, withResourcesAlternateData=None,):
    self.authenticationToken = authenticationToken
    self.noteGuid = noteGuid
    self.updateSequenceNum = updateSequenceNum
    self.withResourcesData = withResourcesData
    self.withResourcesRecognition = withResourcesRecognition
    self.withResourcesAlternateData = withResourcesAlternateData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.updateSequenceNum = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.withResourcesData = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.withResourcesRecognition = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.withResourcesAlternateData = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteVersion_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 2)
      oprot.writeString(self.noteGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.updateSequenceNum is not None:
      oprot.writeFieldBegin('updateSequenceNum', TType.I32, 3)
      oprot.writeI32(self.updateSequenceNum)
      oprot.writeFieldEnd()
    if self.withResourcesData is not None:
      oprot.writeFieldBegin('withResourcesData', TType.BOOL, 4)
      oprot.writeBool(self.withResourcesData)
      oprot.writeFieldEnd()
    if self.withResourcesRecognition is not None:
      oprot.writeFieldBegin('withResourcesRecognition', TType.BOOL, 5)
      oprot.writeBool(self.withResourcesRecognition)
      oprot.writeFieldEnd()
    if self.withResourcesAlternateData is not None:
      oprot.writeFieldBegin('withResourcesAlternateData', TType.BOOL, 6)
      oprot.writeBool(self.withResourcesAlternateData)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getNoteVersion_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Note, evernote.edam.type.ttypes.Note.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Note()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getNoteVersion_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResource_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - withData
   - withRecognition
   - withAttributes
   - withAlternateData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.BOOL, 'withData', None, None, ), # 3
    (4, TType.BOOL, 'withRecognition', None, None, ), # 4
    (5, TType.BOOL, 'withAttributes', None, None, ), # 5
    (6, TType.BOOL, 'withAlternateData', None, None, ), # 6
  )

  def __init__(self, authenticationToken=None, guid=None, withData=None, withRecognition=None, withAttributes=None, withAlternateData=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.withData = withData
    self.withRecognition = withRecognition
    self.withAttributes = withAttributes
    self.withAlternateData = withAlternateData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.withData = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.withRecognition = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.withAttributes = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.withAlternateData = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResource_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.withData is not None:
      oprot.writeFieldBegin('withData', TType.BOOL, 3)
      oprot.writeBool(self.withData)
      oprot.writeFieldEnd()
    if self.withRecognition is not None:
      oprot.writeFieldBegin('withRecognition', TType.BOOL, 4)
      oprot.writeBool(self.withRecognition)
      oprot.writeFieldEnd()
    if self.withAttributes is not None:
      oprot.writeFieldBegin('withAttributes', TType.BOOL, 5)
      oprot.writeBool(self.withAttributes)
      oprot.writeFieldEnd()
    if self.withAlternateData is not None:
      oprot.writeFieldBegin('withAlternateData', TType.BOOL, 6)
      oprot.writeBool(self.withAlternateData)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResource_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Resource, evernote.edam.type.ttypes.Resource.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Resource()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResource_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceApplicationData_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceApplicationData_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceApplicationData_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.LazyMap, evernote.edam.type.ttypes.LazyMap.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.LazyMap()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceApplicationData_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, guid=None, key=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setResourceApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
   - value
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
    (4, TType.STRING, 'value', None, None, ), # 4
  )

  def __init__(self, authenticationToken=None, guid=None, key=None, value=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.value = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setResourceApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 4)
      oprot.writeString(self.value.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setResourceApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setResourceApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsetResourceApplicationDataEntry_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
   - key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
    (3, TType.STRING, 'key', None, None, ), # 3
  )

  def __init__(self, authenticationToken=None, guid=None, key=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid
    self.key = key

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.key = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsetResourceApplicationDataEntry_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.key is not None:
      oprot.writeFieldBegin('key', TType.STRING, 3)
      oprot.writeString(self.key.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class unsetResourceApplicationDataEntry_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('unsetResourceApplicationDataEntry_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateResource_args(object):
  """
  Attributes:
   - authenticationToken
   - resource
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'resource', (evernote.edam.type.ttypes.Resource, evernote.edam.type.ttypes.Resource.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, resource=None,):
    self.authenticationToken = authenticationToken
    self.resource = resource

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.resource = evernote.edam.type.ttypes.Resource()
          self.resource.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateResource_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.resource is not None:
      oprot.writeFieldBegin('resource', TType.STRUCT, 2)
      self.resource.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateResource_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateResource_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceData_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceData_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceData_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceData_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceByHash_args(object):
  """
  Attributes:
   - authenticationToken
   - noteGuid
   - contentHash
   - withData
   - withRecognition
   - withAlternateData
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'noteGuid', None, None, ), # 2
    (3, TType.STRING, 'contentHash', None, None, ), # 3
    (4, TType.BOOL, 'withData', None, None, ), # 4
    (5, TType.BOOL, 'withRecognition', None, None, ), # 5
    (6, TType.BOOL, 'withAlternateData', None, None, ), # 6
  )

  def __init__(self, authenticationToken=None, noteGuid=None, contentHash=None, withData=None, withRecognition=None, withAlternateData=None,):
    self.authenticationToken = authenticationToken
    self.noteGuid = noteGuid
    self.contentHash = contentHash
    self.withData = withData
    self.withRecognition = withRecognition
    self.withAlternateData = withAlternateData

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.contentHash = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.withData = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.BOOL:
          self.withRecognition = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.BOOL:
          self.withAlternateData = iprot.readBool();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceByHash_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteGuid is not None:
      oprot.writeFieldBegin('noteGuid', TType.STRING, 2)
      oprot.writeString(self.noteGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.contentHash is not None:
      oprot.writeFieldBegin('contentHash', TType.STRING, 3)
      oprot.writeString(self.contentHash)
      oprot.writeFieldEnd()
    if self.withData is not None:
      oprot.writeFieldBegin('withData', TType.BOOL, 4)
      oprot.writeBool(self.withData)
      oprot.writeFieldEnd()
    if self.withRecognition is not None:
      oprot.writeFieldBegin('withRecognition', TType.BOOL, 5)
      oprot.writeBool(self.withRecognition)
      oprot.writeFieldEnd()
    if self.withAlternateData is not None:
      oprot.writeFieldBegin('withAlternateData', TType.BOOL, 6)
      oprot.writeBool(self.withAlternateData)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceByHash_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Resource, evernote.edam.type.ttypes.Resource.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Resource()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceByHash_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceRecognition_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceRecognition_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceRecognition_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceRecognition_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceAlternateData_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceAlternateData_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceAlternateData_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceAlternateData_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceAttributes_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceAttributes_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getResourceAttributes_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.ResourceAttributes, evernote.edam.type.ttypes.ResourceAttributes.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.ResourceAttributes()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getResourceAttributes_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPublicNotebook_args(object):
  """
  Attributes:
   - userId
   - publicUri
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'userId', None, None, ), # 1
    (2, TType.STRING, 'publicUri', None, None, ), # 2
  )

  def __init__(self, userId=None, publicUri=None,):
    self.userId = userId
    self.publicUri = publicUri

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.userId = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.publicUri = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPublicNotebook_args')
    if self.userId is not None:
      oprot.writeFieldBegin('userId', TType.I32, 1)
      oprot.writeI32(self.userId)
      oprot.writeFieldEnd()
    if self.publicUri is not None:
      oprot.writeFieldBegin('publicUri', TType.STRING, 2)
      oprot.writeString(self.publicUri.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getPublicNotebook_result(object):
  """
  Attributes:
   - success
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.Notebook, evernote.edam.type.ttypes.Notebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, systemException=None, notFoundException=None,):
    self.success = success
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.Notebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getPublicNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 1)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createSharedNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - sharedNotebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'sharedNotebook', (evernote.edam.type.ttypes.SharedNotebook, evernote.edam.type.ttypes.SharedNotebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, sharedNotebook=None,):
    self.authenticationToken = authenticationToken
    self.sharedNotebook = sharedNotebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.sharedNotebook = evernote.edam.type.ttypes.SharedNotebook()
          self.sharedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createSharedNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sharedNotebook is not None:
      oprot.writeFieldBegin('sharedNotebook', TType.STRUCT, 2)
      self.sharedNotebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createSharedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.SharedNotebook, evernote.edam.type.ttypes.SharedNotebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.SharedNotebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createSharedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateSharedNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - sharedNotebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'sharedNotebook', (evernote.edam.type.ttypes.SharedNotebook, evernote.edam.type.ttypes.SharedNotebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, sharedNotebook=None,):
    self.authenticationToken = authenticationToken
    self.sharedNotebook = sharedNotebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.sharedNotebook = evernote.edam.type.ttypes.SharedNotebook()
          self.sharedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateSharedNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sharedNotebook is not None:
      oprot.writeFieldBegin('sharedNotebook', TType.STRUCT, 2)
      self.sharedNotebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateSharedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateSharedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setSharedNotebookRecipientSettings_args(object):
  """
  Attributes:
   - authenticationToken
   - sharedNotebookId
   - recipientSettings
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.I64, 'sharedNotebookId', None, None, ), # 2
    (3, TType.STRUCT, 'recipientSettings', (evernote.edam.type.ttypes.SharedNotebookRecipientSettings, evernote.edam.type.ttypes.SharedNotebookRecipientSettings.thrift_spec), None, ), # 3
  )

  def __init__(self, authenticationToken=None, sharedNotebookId=None, recipientSettings=None,):
    self.authenticationToken = authenticationToken
    self.sharedNotebookId = sharedNotebookId
    self.recipientSettings = recipientSettings

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.sharedNotebookId = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.recipientSettings = evernote.edam.type.ttypes.SharedNotebookRecipientSettings()
          self.recipientSettings.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setSharedNotebookRecipientSettings_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sharedNotebookId is not None:
      oprot.writeFieldBegin('sharedNotebookId', TType.I64, 2)
      oprot.writeI64(self.sharedNotebookId)
      oprot.writeFieldEnd()
    if self.recipientSettings is not None:
      oprot.writeFieldBegin('recipientSettings', TType.STRUCT, 3)
      self.recipientSettings.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class setSharedNotebookRecipientSettings_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('setSharedNotebookRecipientSettings_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class sendMessageToSharedNotebookMembers_args(object):
  """
  Attributes:
   - authenticationToken
   - notebookGuid
   - messageText
   - recipients
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'notebookGuid', None, None, ), # 2
    (3, TType.STRING, 'messageText', None, None, ), # 3
    (4, TType.LIST, 'recipients', (TType.STRING,None), None, ), # 4
  )

  def __init__(self, authenticationToken=None, notebookGuid=None, messageText=None, recipients=None,):
    self.authenticationToken = authenticationToken
    self.notebookGuid = notebookGuid
    self.messageText = messageText
    self.recipients = recipients

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.notebookGuid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.messageText = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.recipients = []
          (_etype245, _size242) = iprot.readListBegin()
          for _i246 in range(_size242):
            _elem247 = iprot.readString().decode('utf-8')
            self.recipients.append(_elem247)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('sendMessageToSharedNotebookMembers_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.notebookGuid is not None:
      oprot.writeFieldBegin('notebookGuid', TType.STRING, 2)
      oprot.writeString(self.notebookGuid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.messageText is not None:
      oprot.writeFieldBegin('messageText', TType.STRING, 3)
      oprot.writeString(self.messageText.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.recipients is not None:
      oprot.writeFieldBegin('recipients', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.recipients))
      for iter248 in self.recipients:
        oprot.writeString(iter248.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class sendMessageToSharedNotebookMembers_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('sendMessageToSharedNotebookMembers_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSharedNotebooks_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSharedNotebooks_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listSharedNotebooks_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.SharedNotebook, evernote.edam.type.ttypes.SharedNotebook.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype252, _size249) = iprot.readListBegin()
          for _i253 in range(_size249):
            _elem254 = evernote.edam.type.ttypes.SharedNotebook()
            _elem254.read(iprot)
            self.success.append(_elem254)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listSharedNotebooks_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter255 in self.success:
        iter255.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeSharedNotebooks_args(object):
  """
  Attributes:
   - authenticationToken
   - sharedNotebookIds
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.LIST, 'sharedNotebookIds', (TType.I64,None), None, ), # 2
  )

  def __init__(self, authenticationToken=None, sharedNotebookIds=None,):
    self.authenticationToken = authenticationToken
    self.sharedNotebookIds = sharedNotebookIds

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.sharedNotebookIds = []
          (_etype259, _size256) = iprot.readListBegin()
          for _i260 in range(_size256):
            _elem261 = iprot.readI64();
            self.sharedNotebookIds.append(_elem261)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeSharedNotebooks_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sharedNotebookIds is not None:
      oprot.writeFieldBegin('sharedNotebookIds', TType.LIST, 2)
      oprot.writeListBegin(TType.I64, len(self.sharedNotebookIds))
      for iter262 in self.sharedNotebookIds:
        oprot.writeI64(iter262)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeSharedNotebooks_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeSharedNotebooks_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createLinkedNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - linkedNotebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'linkedNotebook', (evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, linkedNotebook=None,):
    self.authenticationToken = authenticationToken
    self.linkedNotebook = linkedNotebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.linkedNotebook = evernote.edam.type.ttypes.LinkedNotebook()
          self.linkedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createLinkedNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.linkedNotebook is not None:
      oprot.writeFieldBegin('linkedNotebook', TType.STRUCT, 2)
      self.linkedNotebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createLinkedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.LinkedNotebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createLinkedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateLinkedNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - linkedNotebook
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'linkedNotebook', (evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, linkedNotebook=None,):
    self.authenticationToken = authenticationToken
    self.linkedNotebook = linkedNotebook

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.linkedNotebook = evernote.edam.type.ttypes.LinkedNotebook()
          self.linkedNotebook.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateLinkedNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.linkedNotebook is not None:
      oprot.writeFieldBegin('linkedNotebook', TType.STRUCT, 2)
      self.linkedNotebook.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class updateLinkedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('updateLinkedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listLinkedNotebooks_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listLinkedNotebooks_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class listLinkedNotebooks_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(evernote.edam.type.ttypes.LinkedNotebook, evernote.edam.type.ttypes.LinkedNotebook.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype266, _size263) = iprot.readListBegin()
          for _i267 in range(_size263):
            _elem268 = evernote.edam.type.ttypes.LinkedNotebook()
            _elem268.read(iprot)
            self.success.append(_elem268)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('listLinkedNotebooks_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter269 in self.success:
        iter269.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeLinkedNotebook_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeLinkedNotebook_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class expungeLinkedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('expungeLinkedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticateToSharedNotebook_args(object):
  """
  Attributes:
   - shareKey
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'shareKey', None, None, ), # 1
    (2, TType.STRING, 'authenticationToken', None, None, ), # 2
  )

  def __init__(self, shareKey=None, authenticationToken=None,):
    self.shareKey = shareKey
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.shareKey = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticateToSharedNotebook_args')
    if self.shareKey is not None:
      oprot.writeFieldBegin('shareKey', TType.STRING, 1)
      oprot.writeString(self.shareKey.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 2)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticateToSharedNotebook_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.userstore.ttypes.AuthenticationResult, evernote.edam.userstore.ttypes.AuthenticationResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.userstore.ttypes.AuthenticationResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticateToSharedNotebook_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSharedNotebookByAuth_args(object):
  """
  Attributes:
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
  )

  def __init__(self, authenticationToken=None,):
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSharedNotebookByAuth_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getSharedNotebookByAuth_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.type.ttypes.SharedNotebook, evernote.edam.type.ttypes.SharedNotebook.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.type.ttypes.SharedNotebook()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getSharedNotebookByAuth_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class emailNote_args(object):
  """
  Attributes:
   - authenticationToken
   - parameters
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'parameters', (NoteEmailParameters, NoteEmailParameters.thrift_spec), None, ), # 2
  )

  def __init__(self, authenticationToken=None, parameters=None,):
    self.authenticationToken = authenticationToken
    self.parameters = parameters

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.parameters = NoteEmailParameters()
          self.parameters.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('emailNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.parameters is not None:
      oprot.writeFieldBegin('parameters', TType.STRUCT, 2)
      self.parameters.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class emailNote_result(object):
  """
  Attributes:
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, userException=None, notFoundException=None, systemException=None,):
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('emailNote_result')
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class shareNote_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('shareNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class shareNote_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRING, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRING:
          self.success = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('shareNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRING, 0)
      oprot.writeString(self.success.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class stopSharingNote_args(object):
  """
  Attributes:
   - authenticationToken
   - guid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRING, 'guid', None, None, ), # 2
  )

  def __init__(self, authenticationToken=None, guid=None,):
    self.authenticationToken = authenticationToken
    self.guid = guid

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('stopSharingNote_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 2)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class stopSharingNote_result(object):
  """
  Attributes:
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, userException=None, notFoundException=None, systemException=None,):
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('stopSharingNote_result')
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticateToSharedNote_args(object):
  """
  Attributes:
   - guid
   - noteKey
   - authenticationToken
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'guid', None, None, ), # 1
    (2, TType.STRING, 'noteKey', None, None, ), # 2
    (3, TType.STRING, 'authenticationToken', None, None, ), # 3
  )

  def __init__(self, guid=None, noteKey=None, authenticationToken=None,):
    self.guid = guid
    self.noteKey = noteKey
    self.authenticationToken = authenticationToken

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.guid = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.noteKey = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticateToSharedNote_args')
    if self.guid is not None:
      oprot.writeFieldBegin('guid', TType.STRING, 1)
      oprot.writeString(self.guid.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.noteKey is not None:
      oprot.writeFieldBegin('noteKey', TType.STRING, 2)
      oprot.writeString(self.noteKey.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 3)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class authenticateToSharedNote_result(object):
  """
  Attributes:
   - success
   - userException
   - notFoundException
   - systemException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (evernote.edam.userstore.ttypes.AuthenticationResult, evernote.edam.userstore.ttypes.AuthenticationResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, notFoundException=None, systemException=None,):
    self.success = success
    self.userException = userException
    self.notFoundException = notFoundException
    self.systemException = systemException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = evernote.edam.userstore.ttypes.AuthenticationResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('authenticateToSharedNote_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 2)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 3)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findRelated_args(object):
  """
  Attributes:
   - authenticationToken
   - query
   - resultSpec
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'authenticationToken', None, None, ), # 1
    (2, TType.STRUCT, 'query', (RelatedQuery, RelatedQuery.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'resultSpec', (RelatedResultSpec, RelatedResultSpec.thrift_spec), None, ), # 3
  )

  def __init__(self, authenticationToken=None, query=None, resultSpec=None,):
    self.authenticationToken = authenticationToken
    self.query = query
    self.resultSpec = resultSpec

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.authenticationToken = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.query = RelatedQuery()
          self.query.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.resultSpec = RelatedResultSpec()
          self.resultSpec.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findRelated_args')
    if self.authenticationToken is not None:
      oprot.writeFieldBegin('authenticationToken', TType.STRING, 1)
      oprot.writeString(self.authenticationToken.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.query is not None:
      oprot.writeFieldBegin('query', TType.STRUCT, 2)
      self.query.write(oprot)
      oprot.writeFieldEnd()
    if self.resultSpec is not None:
      oprot.writeFieldBegin('resultSpec', TType.STRUCT, 3)
      self.resultSpec.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class findRelated_result(object):
  """
  Attributes:
   - success
   - userException
   - systemException
   - notFoundException
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (RelatedResult, RelatedResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'userException', (evernote.edam.error.ttypes.EDAMUserException, evernote.edam.error.ttypes.EDAMUserException.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'systemException', (evernote.edam.error.ttypes.EDAMSystemException, evernote.edam.error.ttypes.EDAMSystemException.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'notFoundException', (evernote.edam.error.ttypes.EDAMNotFoundException, evernote.edam.error.ttypes.EDAMNotFoundException.thrift_spec), None, ), # 3
  )

  def __init__(self, success=None, userException=None, systemException=None, notFoundException=None,):
    self.success = success
    self.userException = userException
    self.systemException = systemException
    self.notFoundException = notFoundException

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = RelatedResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.userException = evernote.edam.error.ttypes.EDAMUserException()
          self.userException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.systemException = evernote.edam.error.ttypes.EDAMSystemException()
          self.systemException.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.notFoundException = evernote.edam.error.ttypes.EDAMNotFoundException()
          self.notFoundException.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('findRelated_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.userException is not None:
      oprot.writeFieldBegin('userException', TType.STRUCT, 1)
      self.userException.write(oprot)
      oprot.writeFieldEnd()
    if self.systemException is not None:
      oprot.writeFieldBegin('systemException', TType.STRUCT, 2)
      self.systemException.write(oprot)
      oprot.writeFieldEnd()
    if self.notFoundException is not None:
      oprot.writeFieldBegin('notFoundException', TType.STRUCT, 3)
      self.notFoundException.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.items()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
