/*
    Copyright  2006 by Redstone Handelsbolag
    All Rights Reserved.

    The copyright to the source code herein is the property of
    Redstone Handelsbolag. The source code may be used and/or copied only
    with written permission from Redstone or in accordance with
    the terms and conditions stipulated in the agreement/contract
    under which the source code has been supplied.
*/

package redstone.xmlrpc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 *  Contains various messages generated by the library. The original messages are
 *  stored in XmlRpcMessages.properties, which may be overridden by creating
 *  additional locale specific bundles. This is achieved by placing a copy of
 *  XmlRpcMessages.properties with the locale specific suffix (like
 *  XmlRpcMessages_de.properties for German). The bundle will automatically be selected
 *  depending on the default locale of the JVM.
 *
 *  @author Greger Olsson
 */

public class XmlRpcMessages
{
    /**
     *  Returns a message from the resource bundle corresponding to the given key.
     * 
     *  @param key The message key.
     *  @return The message corresponding to the message key.
     *  @throws MissingResourceException If the message is not found.
     */

    public static String getString( String key )
    {
        try
        {
            return RESOURCE_BUNDLE.getString( key );
        }
        catch ( MissingResourceException e )
        {
            return '!' + key + '!';
        }
    }
    
    
    /** <describe> */
    private static final String BUNDLE_NAME = "redstone.xmlrpc.XmlRpcMessages";

    /** <describe> */
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle( BUNDLE_NAME );
}
