// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralG2Production.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class G2Production_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.G2Production:2.0.0", null);

    public G2Production_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public G2Production_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new G2Production_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new G2Production_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public const int ERR_NO_CONFIG_MODE = 2;

    public const int ERR_NO_DEVICE = 3;

    public const int ERR_NO_FIRMWARE_FILE = 4;

    public const int ERR_FIRMWARE_INVALID = 5;

    public const int ERR_PROTECTED = 6;

    public const int ERR_UPDATE_IN_PROGRESS = 7;

    public class FirmwareInfo : ICloneable {
      public object Clone() {
        FirmwareInfo copy = new FirmwareInfo();
        copy.crc = this.crc;
        copy.compiler = this.compiler;
        copy.compilerVersion = this.compilerVersion;
        copy.compileDate = this.compileDate;
        copy.version = this.version;
        copy.subVersion = this.subVersion;
        copy.configurationId = this.configurationId;
        copy.updateDate = this.updateDate;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["crc"] = this.crc;
        json["compiler"] = this.compiler;
        json["compilerVersion"] = this.compilerVersion;
        json["compileDate"] = this.compileDate;
        json["version"] = this.version;
        json["subVersion"] = this.subVersion;
        json["configurationId"] = this.configurationId;
        json["updateDate"] = this.updateDate;
        return json;
      }

      public static FirmwareInfo Decode(LightJson.JsonObject json, Agent agent) {
        FirmwareInfo inst = new FirmwareInfo();
        inst.crc = (int)json["crc"];
        inst.compiler = (string)json["compiler"];
        inst.compilerVersion = (int)json["compilerVersion"];
        inst.compileDate = (string)json["compileDate"];
        inst.version = (int)json["version"];
        inst.subVersion = (int)json["subVersion"];
        inst.configurationId = (int)json["configurationId"];
        inst.updateDate = (string)json["updateDate"];
        return inst;
      }

      public int crc = 0;
      public string compiler = "";
      public int compilerVersion = 0;
      public string compileDate = "";
      public int version = 0;
      public int subVersion = 0;
      public int configurationId = 0;
      public string updateDate = "";
    }

    public class UpdateFirmwareResult {
      public int _ret_;
    }

    public UpdateFirmwareResult updateFirmware(string romcode) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;

      var _result = RpcCall("updateFirmware", _parameters);
      var _ret = new UpdateFirmwareResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest updateFirmware(string romcode, AsyncRpcResponse<UpdateFirmwareResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return updateFirmware(romcode, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest updateFirmware(string romcode, AsyncRpcResponse<UpdateFirmwareResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("updateFirmware", _parameters,
        _result => {
          try {
            var _ret = new UpdateFirmwareResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UpdateFirmwarePosResult {
      public int _ret_;
    }

    public UpdateFirmwarePosResult updateFirmwarePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("updateFirmwarePos", _parameters);
      var _ret = new UpdateFirmwarePosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest updateFirmwarePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, AsyncRpcResponse<UpdateFirmwarePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return updateFirmwarePos(position, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest updateFirmwarePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, AsyncRpcResponse<UpdateFirmwarePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("updateFirmwarePos", _parameters,
        _result => {
          try {
            var _ret = new UpdateFirmwarePosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFirmwareInfoResult {
      public int _ret_;
      public Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo info;
    }

    public GetFirmwareInfoResult getFirmwareInfo(string romcode) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;

      var _result = RpcCall("getFirmwareInfo", _parameters);
      var _ret = new GetFirmwareInfoResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.info = Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getFirmwareInfo(string romcode, AsyncRpcResponse<GetFirmwareInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFirmwareInfo(romcode, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFirmwareInfo(string romcode, AsyncRpcResponse<GetFirmwareInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getFirmwareInfo", _parameters,
        _result => {
          try {
            var _ret = new GetFirmwareInfoResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.info = Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFirmwareInfoPosResult {
      public int _ret_;
      public Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo info;
    }

    public GetFirmwareInfoPosResult getFirmwareInfoPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("getFirmwareInfoPos", _parameters);
      var _ret = new GetFirmwareInfoPosResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.info = Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getFirmwareInfoPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, AsyncRpcResponse<GetFirmwareInfoPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFirmwareInfoPos(position, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFirmwareInfoPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, AsyncRpcResponse<GetFirmwareInfoPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getFirmwareInfoPos", _parameters,
        _result => {
          try {
            var _ret = new GetFirmwareInfoPosResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.info = Com.Raritan.Idl.peripheral.G2Production_2_0_0.FirmwareInfo.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public enum ConfigurationSpace {
      HARDWARE,
      FUNCTION,
      FIRMWARE,
      RESERVED,
    }

    public class ReadConfigurationSpaceResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<byte> cfg;
    }

    public ReadConfigurationSpaceResult readConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["cs"] = (int)cs;

      var _result = RpcCall("readConfigurationSpace", _parameters);
      var _ret = new ReadConfigurationSpaceResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.cfg = new System.Collections.Generic.List<byte>(_result["cfg"].AsJsonArray.Select(
        _value => (byte)_value));
      return _ret;
    }

    public AsyncRequest readConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return readConfigurationSpace(romcode, cs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest readConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["cs"] = (int)cs;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("readConfigurationSpace", _parameters,
        _result => {
          try {
            var _ret = new ReadConfigurationSpaceResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.cfg = new System.Collections.Generic.List<byte>(_result["cfg"].AsJsonArray.Select(
              _value => (byte)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ReadConfigurationSpacePosResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<byte> cfg;
    }

    public ReadConfigurationSpacePosResult readConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["cs"] = (int)cs;

      var _result = RpcCall("readConfigurationSpacePos", _parameters);
      var _ret = new ReadConfigurationSpacePosResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.cfg = new System.Collections.Generic.List<byte>(_result["cfg"].AsJsonArray.Select(
        _value => (byte)_value));
      return _ret;
    }

    public AsyncRequest readConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return readConfigurationSpacePos(position, cs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest readConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["cs"] = (int)cs;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("readConfigurationSpacePos", _parameters,
        _result => {
          try {
            var _ret = new ReadConfigurationSpacePosResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.cfg = new System.Collections.Generic.List<byte>(_result["cfg"].AsJsonArray.Select(
              _value => (byte)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EraseConfigurationSpaceResult {
      public int _ret_;
    }

    public EraseConfigurationSpaceResult eraseConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["cs"] = (int)cs;

      var _result = RpcCall("eraseConfigurationSpace", _parameters);
      var _ret = new EraseConfigurationSpaceResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest eraseConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<EraseConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return eraseConfigurationSpace(romcode, cs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest eraseConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<EraseConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["cs"] = (int)cs;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("eraseConfigurationSpace", _parameters,
        _result => {
          try {
            var _ret = new EraseConfigurationSpaceResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EraseConfigurationSpacePosResult {
      public int _ret_;
    }

    public EraseConfigurationSpacePosResult eraseConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["cs"] = (int)cs;

      var _result = RpcCall("eraseConfigurationSpacePos", _parameters);
      var _ret = new EraseConfigurationSpacePosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest eraseConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<EraseConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return eraseConfigurationSpacePos(position, cs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest eraseConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, AsyncRpcResponse<EraseConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["cs"] = (int)cs;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("eraseConfigurationSpacePos", _parameters,
        _result => {
          try {
            var _ret = new EraseConfigurationSpacePosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteConfigurationSpaceResult {
      public int _ret_;
    }

    public WriteConfigurationSpaceResult writeConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["cs"] = (int)cs;
      _parameters["cfg"] = new JsonArray(cfg.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("writeConfigurationSpace", _parameters);
      var _ret = new WriteConfigurationSpaceResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg, AsyncRpcResponse<WriteConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeConfigurationSpace(romcode, cs, cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeConfigurationSpace(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg, AsyncRpcResponse<WriteConfigurationSpaceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["cs"] = (int)cs;
        _parameters["cfg"] = new JsonArray(cfg.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeConfigurationSpace", _parameters,
        _result => {
          try {
            var _ret = new WriteConfigurationSpaceResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteConfigurationSpacePosResult {
      public int _ret_;
    }

    public WriteConfigurationSpacePosResult writeConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["cs"] = (int)cs;
      _parameters["cfg"] = new JsonArray(cfg.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("writeConfigurationSpacePos", _parameters);
      var _ret = new WriteConfigurationSpacePosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg, AsyncRpcResponse<WriteConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeConfigurationSpacePos(position, cs, cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeConfigurationSpacePos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ConfigurationSpace cs, System.Collections.Generic.IEnumerable<byte> cfg, AsyncRpcResponse<WriteConfigurationSpacePosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["cs"] = (int)cs;
        _parameters["cfg"] = new JsonArray(cfg.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeConfigurationSpacePos", _parameters,
        _result => {
          try {
            var _ret = new WriteConfigurationSpacePosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ReadRegistersResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<byte> data;
    }

    public ReadRegistersResult readRegisters(string romcode, int address, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["address"] = address;
      _parameters["count"] = count;

      var _result = RpcCall("readRegisters", _parameters);
      var _ret = new ReadRegistersResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.data = new System.Collections.Generic.List<byte>(_result["data"].AsJsonArray.Select(
        _value => (byte)_value));
      return _ret;
    }

    public AsyncRequest readRegisters(string romcode, int address, int count, AsyncRpcResponse<ReadRegistersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return readRegisters(romcode, address, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest readRegisters(string romcode, int address, int count, AsyncRpcResponse<ReadRegistersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["address"] = address;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("readRegisters", _parameters,
        _result => {
          try {
            var _ret = new ReadRegistersResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.data = new System.Collections.Generic.List<byte>(_result["data"].AsJsonArray.Select(
              _value => (byte)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ReadRegistersPosResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<byte> data;
    }

    public ReadRegistersPosResult readRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["address"] = address;
      _parameters["count"] = count;

      var _result = RpcCall("readRegistersPos", _parameters);
      var _ret = new ReadRegistersPosResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.data = new System.Collections.Generic.List<byte>(_result["data"].AsJsonArray.Select(
        _value => (byte)_value));
      return _ret;
    }

    public AsyncRequest readRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, int count, AsyncRpcResponse<ReadRegistersPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return readRegistersPos(position, address, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest readRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, int count, AsyncRpcResponse<ReadRegistersPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["address"] = address;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("readRegistersPos", _parameters,
        _result => {
          try {
            var _ret = new ReadRegistersPosResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.data = new System.Collections.Generic.List<byte>(_result["data"].AsJsonArray.Select(
              _value => (byte)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteRegistersResult {
      public int _ret_;
    }

    public WriteRegistersResult writeRegisters(string romcode, int address, System.Collections.Generic.IEnumerable<byte> data) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["address"] = address;
      _parameters["data"] = new JsonArray(data.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("writeRegisters", _parameters);
      var _ret = new WriteRegistersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeRegisters(string romcode, int address, System.Collections.Generic.IEnumerable<byte> data, AsyncRpcResponse<WriteRegistersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeRegisters(romcode, address, data, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeRegisters(string romcode, int address, System.Collections.Generic.IEnumerable<byte> data, AsyncRpcResponse<WriteRegistersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["address"] = address;
        _parameters["data"] = new JsonArray(data.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeRegisters", _parameters,
        _result => {
          try {
            var _ret = new WriteRegistersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteRegistersPosResult {
      public int _ret_;
    }

    public WriteRegistersPosResult writeRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, System.Collections.Generic.IEnumerable<byte> data) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["address"] = address;
      _parameters["data"] = new JsonArray(data.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("writeRegistersPos", _parameters);
      var _ret = new WriteRegistersPosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, System.Collections.Generic.IEnumerable<byte> data, AsyncRpcResponse<WriteRegistersPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeRegistersPos(position, address, data, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeRegistersPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, System.Collections.Generic.IEnumerable<byte> data, AsyncRpcResponse<WriteRegistersPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["address"] = address;
        _parameters["data"] = new JsonArray(data.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeRegistersPos", _parameters,
        _result => {
          try {
            var _ret = new WriteRegistersPosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteRegisterBitsResult {
      public int _ret_;
    }

    public WriteRegisterBitsResult writeRegisterBits(string romcode, int address, byte mask, byte bits) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["address"] = address;
      _parameters["mask"] = mask;
      _parameters["bits"] = bits;

      var _result = RpcCall("writeRegisterBits", _parameters);
      var _ret = new WriteRegisterBitsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeRegisterBits(string romcode, int address, byte mask, byte bits, AsyncRpcResponse<WriteRegisterBitsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeRegisterBits(romcode, address, mask, bits, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeRegisterBits(string romcode, int address, byte mask, byte bits, AsyncRpcResponse<WriteRegisterBitsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["address"] = address;
        _parameters["mask"] = mask;
        _parameters["bits"] = bits;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeRegisterBits", _parameters,
        _result => {
          try {
            var _ret = new WriteRegisterBitsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class WriteRegisterBitsPosResult {
      public int _ret_;
    }

    public WriteRegisterBitsPosResult writeRegisterBitsPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, byte mask, byte bits) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["address"] = address;
      _parameters["mask"] = mask;
      _parameters["bits"] = bits;

      var _result = RpcCall("writeRegisterBitsPos", _parameters);
      var _ret = new WriteRegisterBitsPosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest writeRegisterBitsPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, byte mask, byte bits, AsyncRpcResponse<WriteRegisterBitsPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return writeRegisterBitsPos(position, address, mask, bits, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest writeRegisterBitsPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, int address, byte mask, byte bits, AsyncRpcResponse<WriteRegisterBitsPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["address"] = address;
        _parameters["mask"] = mask;
        _parameters["bits"] = bits;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("writeRegisterBitsPos", _parameters,
        _result => {
          try {
            var _ret = new WriteRegisterBitsPosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public enum ResetMethod {
      BROWNOUT,
      WATCHDOG,
    }

    public class ResetResult {
      public int _ret_;
    }

    public ResetResult reset(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method) {
      var _parameters = new LightJson.JsonObject();
      _parameters["romcode"] = romcode;
      _parameters["method"] = (int)method;

      var _result = RpcCall("reset", _parameters);
      var _ret = new ResetResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest reset(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method, AsyncRpcResponse<ResetResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return reset(romcode, method, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest reset(string romcode, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method, AsyncRpcResponse<ResetResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["romcode"] = romcode;
        _parameters["method"] = (int)method;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("reset", _parameters,
        _result => {
          try {
            var _ret = new ResetResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ResetPosResult {
      public int _ret_;
    }

    public ResetPosResult resetPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = new JsonArray(position.Select(
        _value => (JsonValue)(_value.Encode())));
      _parameters["method"] = (int)method;

      var _result = RpcCall("resetPos", _parameters);
      var _ret = new ResetPosResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest resetPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method, AsyncRpcResponse<ResetPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return resetPos(position, method, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest resetPos(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement> position, Com.Raritan.Idl.peripheral.G2Production_2_0_0.ResetMethod method, AsyncRpcResponse<ResetPosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = new JsonArray(position.Select(
          _value => (JsonValue)(_value.Encode())));
        _parameters["method"] = (int)method;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("resetPos", _parameters,
        _result => {
          try {
            var _ret = new ResetPosResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
