// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GsmModem.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.serial {
  public class GsmModem_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("serial.GsmModem:1.0.1", null);

    public GsmModem_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public GsmModem_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new GsmModem_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new GsmModem_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public const int ERR_WRONG_PIN = 2;

    public const int ERR_SMS_SEND_FAILED = 3;

    public const int ERR_COMMUNICATION_FAILURE = 4;

    public const int ERR_SIM_LOCKED = 5;

    public const int ERR_WRONG_SIM_STATUS = 6;

    public const int ERR_WRONG_PUK = 7;

    public enum SimSecurityStatus {
      UNLOCKED,
      WAITFORPIN,
      WAITFORPUK,
      UNKNOWN,
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.pin = this.pin;
        copy.smsc = this.smsc;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["pin"] = this.pin;
        json["smsc"] = this.smsc;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.pin = (string)json["pin"];
        inst.smsc = (string)json["smsc"];
        return inst;
      }

      public string pin = "";
      public string smsc = "";
    }

    public class Information : ICloneable {
      public object Clone() {
        Information copy = new Information();
        copy.imei = this.imei;
        copy.imsi = this.imsi;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.revision = this.revision;
        copy.ownNumber = this.ownNumber;
        copy.simSmsc = this.simSmsc;
        copy.networkName = this.networkName;
        copy.serviceProviderName = this.serviceProviderName;
        copy.receptionLevel = this.receptionLevel;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["imei"] = this.imei;
        json["imsi"] = this.imsi;
        json["manufacturer"] = this.manufacturer;
        json["model"] = this.model;
        json["revision"] = this.revision;
        json["ownNumber"] = this.ownNumber;
        json["simSmsc"] = this.simSmsc;
        json["networkName"] = this.networkName;
        json["serviceProviderName"] = this.serviceProviderName;
        json["receptionLevel"] = this.receptionLevel;
        return json;
      }

      public static Information Decode(LightJson.JsonObject json, Agent agent) {
        Information inst = new Information();
        inst.imei = (string)json["imei"];
        inst.imsi = (string)json["imsi"];
        inst.manufacturer = (string)json["manufacturer"];
        inst.model = (string)json["model"];
        inst.revision = (string)json["revision"];
        inst.ownNumber = (string)json["ownNumber"];
        inst.simSmsc = (string)json["simSmsc"];
        inst.networkName = (string)json["networkName"];
        inst.serviceProviderName = (string)json["serviceProviderName"];
        inst.receptionLevel = (int)json["receptionLevel"];
        return inst;
      }

      public string imei = "";
      public string imsi = "";
      public string manufacturer = "";
      public string model = "";
      public string revision = "";
      public string ownNumber = "";
      public string simSmsc = "";
      public string networkName = "";
      public string serviceProviderName = "";
      public int receptionLevel = 0;
    }

    public class SimSecurityStatusChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("serial.GsmModem_1_0_1.SimSecurityStatusChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.serial.GsmModem_1_0_1.SimSecurityStatus newSimStatus = Com.Raritan.Idl.serial.GsmModem_1_0_1.SimSecurityStatus.UNLOCKED;
    }

    public class SimPinUpdatedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("serial.GsmModem_1_0_1.SimPinUpdatedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public string newPin = "";
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SendSmsResult {
      public int _ret_;
    }

    public SendSmsResult sendSms(string recipient, string text) {
      var _parameters = new LightJson.JsonObject();
      _parameters["recipient"] = recipient;
      _parameters["text"] = text;

      var _result = RpcCall("sendSms", _parameters);
      var _ret = new SendSmsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest sendSms(string recipient, string text, AsyncRpcResponse<SendSmsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return sendSms(recipient, text, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest sendSms(string recipient, string text, AsyncRpcResponse<SendSmsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["recipient"] = recipient;
        _parameters["text"] = text;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("sendSms", _parameters,
        _result => {
          try {
            var _ret = new SendSmsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SendTestSmsResult {
      public int _ret_;
    }

    public SendTestSmsResult sendTestSms(string recipient, Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings testSettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["recipient"] = recipient;
      _parameters["testSettings"] = testSettings.Encode();

      var _result = RpcCall("sendTestSms", _parameters);
      var _ret = new SendTestSmsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest sendTestSms(string recipient, Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings testSettings, AsyncRpcResponse<SendTestSmsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return sendTestSms(recipient, testSettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest sendTestSms(string recipient, Com.Raritan.Idl.serial.GsmModem_1_0_1.Settings testSettings, AsyncRpcResponse<SendTestSmsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["recipient"] = recipient;
        _parameters["testSettings"] = testSettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("sendTestSms", _parameters,
        _result => {
          try {
            var _ret = new SendTestSmsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInformationResult {
      public int _ret_;
      public Com.Raritan.Idl.serial.GsmModem_1_0_1.Information info;
    }

    public GetInformationResult getInformation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInformation", _parameters);
      var _ret = new GetInformationResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.info = Com.Raritan.Idl.serial.GsmModem_1_0_1.Information.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInformation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInformation", _parameters,
        _result => {
          try {
            var _ret = new GetInformationResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.info = Com.Raritan.Idl.serial.GsmModem_1_0_1.Information.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInformationWithPinResult {
      public int _ret_;
      public Com.Raritan.Idl.serial.GsmModem_1_0_1.Information info;
    }

    public GetInformationWithPinResult getInformationWithPin(string pin) {
      var _parameters = new LightJson.JsonObject();
      _parameters["pin"] = pin;

      var _result = RpcCall("getInformationWithPin", _parameters);
      var _ret = new GetInformationWithPinResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.info = Com.Raritan.Idl.serial.GsmModem_1_0_1.Information.Decode(_result["info"], agent);
      return _ret;
    }

    public AsyncRequest getInformationWithPin(string pin, AsyncRpcResponse<GetInformationWithPinResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInformationWithPin(pin, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInformationWithPin(string pin, AsyncRpcResponse<GetInformationWithPinResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["pin"] = pin;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getInformationWithPin", _parameters,
        _result => {
          try {
            var _ret = new GetInformationWithPinResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.info = Com.Raritan.Idl.serial.GsmModem_1_0_1.Information.Decode(_result["info"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSimSecurityStatusResult {
      public int _ret_;
      public Com.Raritan.Idl.serial.GsmModem_1_0_1.SimSecurityStatus simStatus;
    }

    public GetSimSecurityStatusResult getSimSecurityStatus() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSimSecurityStatus", _parameters);
      var _ret = new GetSimSecurityStatusResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.simStatus = (Com.Raritan.Idl.serial.GsmModem_1_0_1.SimSecurityStatus)(int)_result["simStatus"];
      return _ret;
    }

    public AsyncRequest getSimSecurityStatus(AsyncRpcResponse<GetSimSecurityStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSimSecurityStatus(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSimSecurityStatus(AsyncRpcResponse<GetSimSecurityStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSimSecurityStatus", _parameters,
        _result => {
          try {
            var _ret = new GetSimSecurityStatusResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.simStatus = (Com.Raritan.Idl.serial.GsmModem_1_0_1.SimSecurityStatus)(int)_result["simStatus"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UnlockSimCardResult {
      public int _ret_;
    }

    public UnlockSimCardResult unlockSimCard(string puk, string newPin) {
      var _parameters = new LightJson.JsonObject();
      _parameters["puk"] = puk;
      _parameters["newPin"] = newPin;

      var _result = RpcCall("unlockSimCard", _parameters);
      var _ret = new UnlockSimCardResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest unlockSimCard(string puk, string newPin, AsyncRpcResponse<UnlockSimCardResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return unlockSimCard(puk, newPin, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest unlockSimCard(string puk, string newPin, AsyncRpcResponse<UnlockSimCardResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["puk"] = puk;
        _parameters["newPin"] = newPin;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("unlockSimCard", _parameters,
        _result => {
          try {
            var _ret = new UnlockSimCardResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
