% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{vec_assert}
\alias{vec_assert}
\alias{vec_is}
\title{Assert an argument has known prototype and/or size}
\usage{
vec_assert(x, ptype = NULL, size = NULL, arg = as_label(substitute(x)))

vec_is(x, ptype = NULL, size = NULL)
}
\arguments{
\item{x}{A vector argument to check.}

\item{ptype}{Prototype to compare against. If the prototype has a
class, its \code{\link[=vec_ptype]{vec_ptype()}} is compared to that of \code{x} with
\code{identical()}. Otherwise, its \code{\link[=typeof]{typeof()}} is compared to that of
\code{x} with \code{==}.}

\item{size}{Size to compare against}

\item{arg}{Name of argument being checked. This is used in error
messages. The label of the expression passed as \code{x} is taken as
default.}
}
\value{
\code{vec_is()} returns \code{TRUE} or \code{FALSE}. \code{vec_assert()} either
throws a typed error (see section on error types) or returns \code{x},
invisibly.
}
\description{
\itemize{
\item \code{vec_is()} is a predicate that checks if its input conforms to a
prototype and/or a size.
\item \code{vec_assert()} throws an error when the input doesn't conform.
}
}
\section{Error types}{

\itemize{
\item If the prototype doesn't match, an error of class
\code{"vctrs_error_assert_ptype"} is raised.
\item If the size doesn't match, an error of class
\code{"vctrs_error_assert_size"} is raised.
}

Both errors inherit from \code{"vctrs_error_assert"}.
}

