% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_fallback.R
\name{font_fallback}
\alias{font_fallback}
\title{Get the fallback font for a given string}
\usage{
font_fallback(
  string,
  family = "",
  italic = FALSE,
  bold = FALSE,
  path = NULL,
  index = 0
)
}
\arguments{
\item{string}{The strings to find fallbacks for}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{bold}{logical indicating whether the font weight}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A data frame with a \code{path} and \code{index} column giving fallback for the
specified string and font combinations
}
\description{
A fallback font is a font to use as a substitute if the chosen font does not
contain the requested characters. Using font fallbacks means that the user
doesn't have to worry about mixing characters from different scripts or
mixing text and emojies. Fallback is calculated for the full string and the
result is platform specific. If no font covers all the characters in the
string an undefined "best match" is returned. The best approach is to figure
out which characters are not covered by your chosen font and figure out
fallbacks for these, rather than just request a fallback for the full string.
}
\examples{
font_fallback("\U0001f604") # Smile emoji

}
