% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{testBaseline}
\alias{testBaseline}
\title{Two-sided test of BASELINe PDFs}
\usage{
testBaseline(baseline, groupBy)
}
\arguments{
\item{baseline}{\code{Baseline} object containing the \code{db} and grouped 
BASELINe PDFs returned by \link{groupBaseline}.}

\item{groupBy}{string defining the column in the \code{db} slot of the 
\code{Baseline} containing sequence or group identifiers.}
}
\value{
A data.frame with test results containing the following columns:
          \itemize{
            \item  \code{REGION}:  sequence region, such as "CDR" and "FWR".
            \item  \code{TEST}:    string defining the groups be compared. The
                                   string is formated as the conclusion associated with the
                                   p-value in the form \code{GROUP1 != GROUP2}. Meaning,
                                   the p-value for rejection of the null hypothesis that 
                                   GROUP1 and GROUP2 have equivalent distributions.
            \item  \code{PVALUE}:  two-sided p-value for the comparison.
            \item  \code{FDR}:     FDR corrected \code{PVALUE}.
          }
}
\description{
\code{testBaseline} performs a two-sample signifance test of BASELINe 
posterior probability density functions (PDFs).
}
\examples{
\donttest{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgM", "IgG", "IgA"))

# Collapse clones
db <- collapseClones(db, sequenceColumn="SEQUENCE_IMGT",
                     germlineColumn="GERMLINE_IMGT_D_MASK",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="CLONAL_SEQUENCE",
                         germlineColumn="CLONAL_GERMLINE", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)

# Group PDFs by the isotype
grouped <- groupBaseline(baseline, groupBy="ISOTYPE")

# Visualize isotype PDFs
plot(grouped, "ISOTYPE")

# Perform test on isotype PDFs
testBaseline(grouped, groupBy="ISOTYPE")
}
}
\references{
\enumerate{
  \item  Yaari G, et al. Quantifying selection in high-throughput immunoglobulin 
           sequencing data sets. 
           Nucleic Acids Res. 2012 40(17):e134. 
           (Corretions at http://selection.med.yale.edu/baseline/correction/)
 }
}
\seealso{
To generate the \link{Baseline} input object see \link{groupBaseline}.
}
