% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.find.R
\name{list.findi}
\alias{list.findi}
\title{Find the indices of a number of elements in a list or vector
satisfying a given condition}
\usage{
list.findi(.data, cond, n = 1L)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{cond}{A logical lambda expression}

\item{n}{The number of items to find. (\code{n = 1L} by default)}
}
\value{
an integer vector consisting of the elements indices
}
\description{
Find the indices of a number of elements in a list or vector
satisfying a given condition
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.findi(x, type=='B')
list.findi(x, min(score$c1,score$c2) >= 8)
list.findi(x, min(score$c1,score$c2) <= 8, n = 2)
}

