% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{set.label}
\alias{set.label}
\title{Assign Stata Labels to a Variable}
\usage{
set.label(dat, var.name, lang = NA)
}
\arguments{
\item{dat}{\emph{data.frame.} Data.frame created by \code{read.dta13}.}

\item{var.name}{\emph{character.} Name of the variable in the data.frame}

\item{lang}{\emph{character.} Label language. Default language defined by
\code{\link{get.lang}} is used if NA}
}
\value{
Returns a labeled factor
}
\description{
Assign value labels from a Stata label set to a variable. If duplicated
 labels are found, unique labels will be generated according the following
 scheme: "label_(integer code)". Levels without labels will become <NA>.
}
\examples{
dat <- read.dta13(system.file("extdata/statacar.dta", package="readstata13"),
                  convert.factors=FALSE)

# compare vectors
set.label(dat, "type")
dat$type

# German label
set.label(dat, "type", "de")
}
