% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_split_half.R
\name{item_split_half}
\alias{item_split_half}
\title{Split-Half Reliability}
\usage{
item_split_half(x, digits = 3)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{digits}{Amount of digits for returned values.}
}
\value{
A list with two elements: the split-half reliability \code{splithalf}
and the Spearman-Brown corrected split-half reliability
\code{spearmanbrown}.
}
\description{
Compute various measures of internal consistencies
for tests or item-scales of questionnaires.
}
\details{
This function calculates the split-half reliability for items in
\code{x}, including the Spearman-Brown adjustment. Splitting is done by
selecting odd versus even columns in \code{x}. A value closer to 1
indicates greater internal consistency.
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_split_half(x)
}
\references{
\itemize{
\item Spearman C. 1910. Correlation calculated from faulty data. British
Journal of Psychology (3): 271-295. \doi{10.1111/j.2044-8295.1910.tb00206.x}

\item   Brown W. 1910. Some experimental results in the correlation of mental
abilities. British Journal of Psychology (3): 296-322.
\doi{10.1111/j.2044-8295.1910.tb00207.x}
}
}
