% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-week.r
\name{week}
\alias{week}
\alias{week<-}
\alias{isoweek}
\alias{epiweek}
\title{Get/set weeks component of a date-time}
\usage{
week(x)

week(x) <- value

isoweek(x)

epiweek(x)
}
\arguments{
\item{x}{a date-time object. Must be a POSIXct, POSIXlt, Date, chron,
yearmon, yearqtr, zoo, zooreg, timeDate, xts, its, ti, jul, timeSeries, or
fts object.}

\item{value}{a numeric object}
}
\value{
the weeks element of x as an integer number
}
\description{
\code{week()} returns the number of complete seven day periods that have
occurred between the date and January 1st, plus one.

\code{isoweek()} returns the week as it would appear in the ISO 8601
system, which uses a reoccurring leap week.

\code{epiweek()} is the US CDC version of epidemiological week. It
follows same rules as \code{isoweek()} but starts on Sunday. In other parts of
the world the convention is to start epidemiological weeks on Monday,
which is the same as \code{isoweek}.
}
\examples{
x <- ymd("2012-03-26")
week(x)
week(x) <- 1
week(x) <- 54
week(x) > 3
}
\references{
\url{https://en.wikipedia.org/wiki/ISO_week_date}
}
\seealso{
\code{\link[=isoyear]{isoyear()}}
}
\keyword{chron}
\keyword{manip}
\keyword{utilities}
