% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5File.R
\name{H5File.open}
\alias{H5File.open}
\title{Open an HDF5 file}
\usage{
H5File.open(name, mode = c("a", "r", "r+", "w", "w-", "x"),
  file_create_pl = h5const$H5P_DEFAULT,
  file_access_pl = h5const$H5P_DEFAULT)
}
\arguments{
\item{name}{The name of the file to open}

\item{mode}{The mode how to open the file}

\item{file_create_pl}{File creation property list}

\item{file_access_pl}{File access property list}
}
\value{
The file id (64bit-integer)
}
\description{
Open an HDF5 file
}
\details{
Open an HDF5 file. \code{a} creates a new file or opens an existing one for read/write. \code{r} opens an
existing file for reading, \code{r+} opens an existing file for read/write. \code{w} creates a file, truncating any
existing ones and \code{w-}/\code{x} are synonyms, creating a file and failing if it already exists.
}
\author{
Holger Hoefling
}
\keyword{internal}
