#include <gsl/gsl_sf_zeta.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_zeta_int_e  goes to zeta. */


void zeta_int(int *n, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_zeta_int_e(n[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void zeta(double *s, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_zeta_e(s[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void zetam1_int(int *n, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_zetam1_int_e(n[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void zetam1(double *s, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_zetam1_e(s[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void hzeta(double *s, double *q, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_hzeta_e(s[i], q[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void eta_int(int *n, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_eta_int_e(n[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void eta(double *s, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_eta_e(s[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
