% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_large_graphs.R, R/layouts.R
\name{layout_pmds}
\alias{layout_pmds}
\alias{layout_with_pmds}
\alias{layout_igraph_pmds}
\title{pivot MDS graph layout}
\usage{
layout_with_pmds(g, pivots, weights = NA)

layout_igraph_pmds(g, pivots, weights = NA, circular)
}
\arguments{
\item{g}{igraph object}

\item{pivots}{number of pivots}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
similar to \link[igraph]{layout_with_mds} but uses only a small set of pivots for MDS. Considerably faster than MDS and thus applicable for larger graphs.
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight)

The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
\dontrun{
library(igraph)
library(ggraph)

g <- sample_gnp(1000,0.01)

xy <- layout_with_pmds(g,pivots = 100)
}
}
\references{
Brandes, U. and Pich, C. (2006). Eigensolver Methods for Progressive Multidimensional Scaling of Large Data. In \emph{International Symposium on Graph Drawing} (pp. 42-53). Springer
}
\author{
David Schoch
}
