% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_lognormal.R
\name{dist_lognormal}
\alias{dist_lognormal}
\title{The log-normal distribution}
\usage{
dist_lognormal(mu = 0, sigma = 1)
}
\arguments{
\item{mu}{The mean (location parameter) of the distribution, which is the
mean of the associated Normal distribution. Can be any real number.}

\item{sigma}{The standard deviation (scale parameter) of the distribution.
Can be any positive number.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The log-normal distribution is a commonly used transformation of the Normal
distribution. If \eqn{X} follows a log-normal distribution, then \eqn{\ln{X}}
would be characteristed by a Normal distribution.
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{Y} be a Normal random variable with mean
\code{mu} = \eqn{\mu} and standard deviation \code{sigma} = \eqn{\sigma}. The
log-normal distribution \eqn{X = exp(Y)} is characterised by:

\strong{Support}: \eqn{R+}, the set of all real numbers greater than or equal to 0.

\strong{Mean}: \eqn{e^(\mu + \sigma^2/2}

\strong{Variance}: \eqn{(e^(\sigma^2)-1) e^(2\mu + \sigma^2}

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{x\sqrt{2 \pi \sigma^2}} e^{-(\ln{x} - \mu)^2 / 2 \sigma^2}
  }{
    f(x) = 1 / (x * sqrt(2 \pi \sigma^2)) exp(-(log(x) - \mu)^2 / (2 \sigma^2))
  }

\strong{Cumulative distribution function (c.d.f)}:

The cumulative distribution function has the form

\deqn{
    F(x) = \Phi((\ln{x} - \mu)/\sigma)
  }{
    F(x) = Phi((log(x) - \mu)/\sigma)
  }

Where \eqn{Phi}{Phi} is the CDF of a standard Normal distribution, N(0,1).
}
\examples{
dist <- dist_lognormal(mu = 1:5, sigma = 0.1)

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

# A log-normal distribution X is exp(Y), where Y is a Normal distribution of
# the same parameters. So log(X) will produce the Normal distribution Y.
log(dist)
}
\seealso{
\link[stats:Lognormal]{stats::Lognormal}
}
