% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlle.R
\docType{class}
\name{HLLE-class}
\alias{HLLE-class}
\alias{HLLE}
\title{Hessian Locally Linear Embedding}
\description{
An S4 Class implementing Hessian Locally Linear Embedding (HLLE)
}
\details{
HLLE uses local hessians to approximate the curvines and is an
extension to non-convex subsets in lowdimensional space.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

HLLE can take the following parameters:
\describe{
  \item{knn}{neighborhood size}
  \item{ndim}{number of output dimensions}
}
}

\section{Implementation}{

Own implementation, sticks to the algorithm in Donoho and Grimes
(2003). Makes use of sparsity to speed up final embedding.
}

\examples{
dat <- loadDataSet("3D S Curve", n = 300)
emb <- embed(dat, "HLLE", knn = 15)
plot(emb, type = "2vars")

}
\references{
Donoho, D.L., Grimes, C., 2003. Hessian eigenmaps: Locally linear
embedding techniques for high-dimensional data. PNAS 100,
5591-5596. doi:10.1073/pnas.1031596100
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{LLE-class}},
\code{\link{MDS-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
