% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_c50.R
\name{confidence_factor}
\alias{confidence_factor}
\alias{no_global_pruning}
\alias{predictor_winnowing}
\alias{fuzzy_thresholding}
\alias{rule_bands}
\title{Parameters for possible engine parameters for C5.0}
\usage{
confidence_factor(range = c(-1, 0), trans = log10_trans())

no_global_pruning(values = c(TRUE, FALSE))

predictor_winnowing(values = c(TRUE, FALSE))

fuzzy_thresholding(values = c(TRUE, FALSE))

rule_bands(range = c(2L, 500L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{For \code{no_global_pruning()}, \code{predictor_winnowing()}, and
\code{fuzzy_thresholding()} either \code{TRUE} or \code{FALSE}.}
}
\description{
These parameters are auxiliary to tree-based models that use the "C5.0"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("C5.0", ...)}.
}
\details{
To use these, check \code{?C50::C5.0Control} to see how they are used.
}
\examples{
confidence_factor()
no_global_pruning()
predictor_winnowing()
fuzzy_thresholding()
rule_bands()
}
