% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{hist.DHARMa}
\alias{hist.DHARMa}
\title{Histogram of DHARMa residuals}
\usage{
\method{hist}{DHARMa}(x, breaks = seq(-0.02, 1.02, len = 53),
  col = c(.Options$DHARMaSignalColor, rep("lightgrey", 50),
  .Options$DHARMaSignalColor), main = "Hist of DHARMa residuals",
  xlab = "Residuals (outliers are marked red)", cex.main = 1, ...)
}
\arguments{
\item{x}{A DHARMa simulation output (class DHARMa)}

\item{breaks}{Breaks for hist() function.}

\item{col}{Color for histogram bars.}

\item{main}{Plot title.}

\item{xlab}{Plot x-axis label.}

\item{cex.main}{Plot cex.main.}

\item{...}{Other arguments to be passed on to hist().}
}
\description{
The function produces a histogram from a DHARMa output. Outliers are marked red.
}
\details{
The function calls hist() to create a histogram of the scaled residuals. Outliers are marked red as default but it can be changed by setting \code{options(DHARMaSignalColor = "red")} to a different color. See \code{getOption("DHARMaSignalColor")} for the current setting.
}
\examples{
testData = createData(sampleSize = 200, family = poisson(), 
                      randomEffectVariance = 1, numGroups = 10)
fittedModel <- glm(observedResponse ~ Environment1, 
                   family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

######### main plotting function #############

# for all functions, quantreg = T will be more
# informative, but slower

plot(simulationOutput, quantreg = FALSE)

#############  Distribution  ######################

plotQQunif(simulationOutput = simulationOutput, 
           testDispersion = FALSE,
           testUniformity = FALSE,
           testOutliers = FALSE)

hist(simulationOutput )

#############  residual plots  ###############

# rank transformation, using a simulationOutput
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE)

# smooth scatter plot - usually used for large datasets, default for n > 10000
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE, smoothScatter = TRUE)

# residual vs predictors, using explicit values for pred, residual 
plotResiduals(simulationOutput, form = testData$Environment1, 
              quantreg = FALSE)

# if pred is a factor, or if asFactor = TRUE, will produce a boxplot
plotResiduals(simulationOutput, form = testData$group)

# to diagnose overdispersion and heteroskedasticity it can be useful to 
# display residuals as absolute deviation from the expected mean 0.5
plotResiduals(simulationOutput, absoluteDeviation = TRUE, quantreg = FALSE)

# All these options can also be provided to the main plotting function

# If you want to plot summaries per group, use
simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
plot(simulationOutput, quantreg = FALSE) 
# we see one residual point per RE


}
\seealso{
\link{plotSimulatedResiduals}, \link{plotResiduals}
}
