% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-compute.R
\name{collapse.tbl_sql}
\alias{collapse.tbl_sql}
\alias{compute.tbl_sql}
\alias{collect.tbl_sql}
\title{Force computation of query}
\usage{
\method{collapse}{tbl_sql}(x, ...)

\method{compute}{tbl_sql}(x, name = unique_table_name(),
  temporary = TRUE, unique_indexes = list(), indexes = list(),
  analyze = TRUE, ...)

\method{collect}{tbl_sql}(x, ..., n = Inf, warn_incomplete = TRUE)
}
\arguments{
\item{x}{A \code{tbl_sql}}

\item{...}{other parameters passed to methods.}

\item{name}{Table name in remote database.}

\item{temporary}{Should the table be temporary (\code{TRUE}, the default\code{) or persistent (}FALSE`)?}

\item{unique_indexes}{a list of character vectors. Each element of the list
will create a new unique index over the specified column(s). Duplicate rows
will result in failure.}

\item{indexes}{a list of character vectors. Each element of the list
will create a new index.}

\item{analyze}{if \code{TRUE} (the default), will automatically ANALYZE the
new table so that the query optimiser has useful information.}

\item{n}{Number of rows to fetch. Defaults to \code{Inf}, meaning all rows.}

\item{warn_incomplete}{Warn if \code{n} is less than the number of result rows?}
}
\description{
\code{collapse()} creates a subquery; \code{compute()} stores the results in a
remote table; \code{collect()} downloads the results into the current
R session.
}
