% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutpointr.R
\name{multi_cutpointr}
\alias{multi_cutpointr}
\title{Calculate optimal cutpoints and further statistics for multiple predictors}
\usage{
multi_cutpointr(data, x = NULL, class, subgroup = NULL, silent = FALSE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{x}{Character vector of predictor variables. If NULL all numeric columns.}

\item{class}{The name of the outcome / independent variable.}

\item{subgroup}{An additional covariate that identifies subgroups. Separate
optimal cutpoints will be determined per group.}

\item{silent}{Whether to suppress messages.}

\item{...}{Further arguments to be passed to cutpointr_ (Use a quoted variable
name for subgroup).}
}
\value{
A data frame.
}
\description{
Runs \code{cutpointr} over multiple predictor variables. Tidyeval via
\code{!!} is supported for \code{class} and \code{subgroup}. If
\code{x = NULL}, \code{cutpointr} will be run using all numeric columns
in the data set as predictors except for the
variable in \code{class} and, if given, \code{subgroup}.
}
\details{
The automatic determination of positive / negative classes and \code{direction}
will be carried out separately for every predictor variable. That way, if
\code{direction} and the classes are not specified, the reported AUC for every
variable will be >= 0.5. AUC may be < 0.5 if subgroups are specified as
\code{direction} is equal within every subgroup.
}
\examples{
library(cutpointr)

multi_cutpointr(suicide, x = c("age", "dsi"), class = suicide,
                pos_class = "yes")

mcp <- multi_cutpointr(suicide, x = c("age", "dsi"), class = suicide,
                       subgroup = gender, pos_class = "yes")
mcp

(scp <- summary(mcp))
\dontrun{
## The result is a data frame
tibble:::print.tbl(scp)
}

}
\seealso{
Other main cutpointr functions: 
\code{\link{add_metric}()},
\code{\link{boot_ci}()},
\code{\link{boot_test}()},
\code{\link{cutpointr}()},
\code{\link{predict.cutpointr}()},
\code{\link{roc}()}
}
\concept{main cutpointr functions}
