% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{posixt-formatting}
\alias{posixt-formatting}
\alias{date_format.POSIXt}
\title{Formatting: date-time}
\usage{
\method{date_format}{POSIXt}(
  x,
  ...,
  format = NULL,
  locale = clock_locale(),
  abbreviate_zone = FALSE
)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{format}{\verb{[character(1) / NULL]}

If \code{NULL}, a default format is used, which depends on the type of the
input.

Otherwise, a format string which is a combination of:

\strong{Year}
\itemize{
\item \verb{\%C}: The year divided by 100 using floored division. If the result
is a single decimal digit, it is prefixed with \code{0}.
\item \verb{\%y}: The last two decimal digits of the year. If the result is a single
digit it is prefixed by \code{0}.
\item \verb{\%Y}: The year as a decimal number. If the result is less than four
digits it is left-padded with \code{0} to four digits.
}

\strong{Month}
\itemize{
\item \verb{\%b}, \verb{\%h}: The \code{locale}'s abbreviated month name.
\item \verb{\%B}: The \code{locale}'s full month name.
\item \verb{\%m}: The month as a decimal number. January is \code{01}. If the result is a
single digit, it is prefixed with \code{0}.
}

\strong{Day}
\itemize{
\item \verb{\%d}: The day of month as a decimal number. If the result is a single
decimal digit, it is prefixed with \code{0}.
}

\strong{Day of the week}
\itemize{
\item \verb{\%a}: The \code{locale}'s abbreviated weekday name.
\item \verb{\%A}: The \code{locale}'s full weekday name.
\item \verb{\%w}: The weekday as a decimal number (\code{0-6}), where Sunday is \code{0}.
}

\strong{ISO 8601 week-based year}
\itemize{
\item \verb{\%g}: The last two decimal digits of the ISO week-based year. If the
result is a single digit it is prefixed by \code{0}.
\item \verb{\%G}: The ISO week-based year as a decimal number. If the result is less
than four digits it is left-padded with \code{0} to four digits.
\item \verb{\%V}: The ISO week-based week number as a decimal number. If the result
is a single digit, it is prefixed with \code{0}.
\item \verb{\%u}: The ISO weekday as a decimal number (\code{1-7}), where Monday is \code{1}.
}

\strong{Week of the year}
\itemize{
\item \verb{\%U}: The week number of the year as a decimal number. The first Sunday
of the year is the first day of week \code{01}. Days of the same year prior to
that are in week \code{00}. If the result is a single digit, it is prefixed with
\code{0}.
\item \verb{\%W}: The week number of the year as a decimal number. The first Monday
of the year is the first day of week \code{01}. Days of the same year prior to
that are in week \code{00}. If the result is a single digit, it is prefixed with
\code{0}.
}

\strong{Day of the year}
\itemize{
\item \verb{\%j}: The day of the year as a decimal number. January 1 is \code{001}. If the
result is less than three digits, it is left-padded with \code{0} to three
digits.
}

\strong{Date}
\itemize{
\item \verb{\%D}, \verb{\%x}: Equivalent to \verb{\%m/\%d/\%y}.
\item \verb{\%F}: Equivalent to \verb{\%Y-\%m-\%d}.
}

\strong{Time of day}
\itemize{
\item \verb{\%H}: The hour (24-hour clock) as a decimal number. If the result is a
single digit, it is prefixed with \code{0}.
\item \verb{\%I}: The hour (12-hour clock) as a decimal number. If the result is a
single digit, it is prefixed with \code{0}.
\item \verb{\%M}: The minute as a decimal number. If the result is a single digit, it
is prefixed with \code{0}.
\item \verb{\%S}: Seconds as a decimal number. Fractional seconds are printed at the
precision of the input. The character for the decimal point is localized
according to \code{locale}.
\item \verb{\%p}: The \code{locale}'s equivalent of the AM/PM designations associated with
a 12-hour clock.
\item \verb{\%R}: Equivalent to \verb{\%H:\%M}.
\item \verb{\%T}, \verb{\%X}: Equivalent to \verb{\%H:\%M:\%S}.
\item \verb{\%r}: Nearly equivalent to \verb{\%I:\%M:\%S \%p}, but seconds are always printed
at second precision.
}

\strong{Time zone}
\itemize{
\item \verb{\%z}: The offset from UTC in the ISO 8601 format. For example \code{-0430}
refers to 4 hours 30 minutes behind UTC. If the offset is zero, \code{+0000} is
used. The modified command \verb{\%Ez} inserts a \code{:} between the hour and
minutes, like \code{-04:30}.
\item \verb{\%Z}: The full time zone name. If \code{abbreviate_zone} is \code{TRUE}, the time
zone abbreviation.
}

\strong{Miscellaneous}
\itemize{
\item \verb{\%c}: A date and time representation. Similar to, but not exactly the
same as, \verb{\%a \%b \%d \%H:\%M:\%S \%Y}.
\item \code{\%\%}: A \verb{\%} character.
\item \verb{\%n}: A newline character.
\item \verb{\%t}: A horizontal-tab character.
}}

\item{locale}{\verb{[clock_locale]}

A locale object created from \code{\link[=clock_locale]{clock_locale()}}.}

\item{abbreviate_zone}{\verb{[logical(1)]}

If \code{TRUE}, \verb{\%Z} returns an abbreviated time zone name.

If \code{FALSE}, \verb{\%Z} returns the full time zone name.}
}
\value{
A character vector of the formatted input.
}
\description{
This is a POSIXct method for the \code{\link[=date_format]{date_format()}} generic.

\code{date_format()} formats a date-time (POSIXct) using a \code{format} string.

If \code{format} is \code{NULL}, a default format of \code{"\%Y-\%m-\%dT\%H:\%M:\%S\%Ez[\%Z]"} is
used. This matches the default format that \code{\link[=date_time_parse_complete]{date_time_parse_complete()}}
parses. Additionally, this format matches the de-facto standard extension to
RFC 3339 for creating completely unambiguous date-times.
}
\examples{
x <- date_time_parse(
  c("1970-04-26 01:30:00", "1970-04-26 03:30:00"),
  zone = "America/New_York"
)

# Default
date_format(x)

# Which is parseable by `date_time_parse_complete()`
date_time_parse_complete(date_format(x))

date_format(x, format = "\%B \%d, \%Y \%H:\%M:\%S")

# By default, `\%Z` uses the full zone name, but you can switch to the
# abbreviated name
date_format(x, format = "\%z \%Z")
date_format(x, format = "\%z \%Z", abbreviate_zone = TRUE)
}
