% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schema.R
\name{ExampleData}
\alias{ExampleData}
\title{Example AIRR data}
\format{
\itemize{
  \item  \code{extdata/rearrangement-example.tsv.gz}: Rearrangement TSV file.
  \item  \code{extdata/repertoire-example.yaml}: Repertoire YAML file.
  \item  \code{extdata/germline-example.json}: GermlineSet and GenotypeSet JSON file.
}
}
\description{
Example data files compliant with the the AIRR Data Representation standards.
}
\examples{
# Load Rearrangement example
file <- system.file("extdata", "rearrangement-example.tsv.gz", package="airr")
rearrangement <- read_rearrangement(file)

# Load Repertoire example
file <- system.file("extdata", "repertoire-example.yaml", package="airr")
repertoire <- read_airr(file)

# Load GermlineSet and GenotypeSet examples
file <- system.file("extdata", "germline-example.json", package="airr")
germline <- read_airr(file)

}
