% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{makeCountsFromAbundance}
\alias{makeCountsFromAbundance}
\title{Low-level function to make counts from abundance using matrices}
\usage{
makeCountsFromAbundance(countsMat, abundanceMat, lengthMat,
  countsFromAbundance = c("scaledTPM", "lengthScaledTPM"))
}
\arguments{
\item{countsMat}{a matrix of original counts}

\item{abundanceMat}{a matrix of abundances (typically TPM)}

\item{lengthMat}{a matrix of effective lengths}

\item{countsFromAbundance}{the desired type of count-from-abundance output}
}
\value{
a matrix of count-scale data generated from abundances.
for details on the calculation see \link{tximport}.
}
\description{
Simple low-level function used within \link{tximport} to generate
\code{scaledTPM} or \code{lengthScaledTPM} counts, taking as input
the original counts, abundance and length matrices.
NOTE: This is a low-level function exported in case it is needed for some reason,
but the recommended way to generate counts-from-abundance is using
\link{tximport} with the \code{countsFromAbundance} argument.
}
