% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumCountsAcrossFeatures.R
\name{sumCountsAcrossFeatures}
\alias{sumCountsAcrossFeatures}
\alias{sumCountsAcrossFeatures,ANY-method}
\alias{sumCountsAcrossFeatures,SummarizedExperiment-method}
\title{Sum counts across feature sets}
\usage{
sumCountsAcrossFeatures(x, ...)

\S4method{sumCountsAcrossFeatures}{ANY}(
  x,
  ids,
  subset.row = NULL,
  subset.col = NULL,
  average = FALSE,
  BPPARAM = SerialParam(),
  subset_row = NULL,
  subset_col = NULL
)

\S4method{sumCountsAcrossFeatures}{SummarizedExperiment}(x, ..., assay.type = "counts", exprs_values = NULL)
}
\arguments{
\item{x}{A numeric matrix of counts containing features in rows and cells in columns.
Alternatively, a \linkS4class{SummarizedExperiment} object containing such a count matrix.}

\item{...}{For the \code{sumCountsAcrossFeatures} generic, further arguments to be passed to specific methods.

For the SummarizedExperiment method, further arguments to be passed to the ANY method.}

\item{ids}{A factor of length \code{nrow(x)}, specifying the set to which each feature in \code{x} belongs.

Alternatively, a list of integer or character vectors, where each vector specifies the indices or names of features in a set.
Logical vectors are also supported.}

\item{subset.row}{An integer, logical or character vector specifying the features to use.
Defaults to all features.}

\item{subset.col}{An integer, logical or character vector specifying the cells to use.
Defaults to all cells with non-\code{NA} entries of \code{ids}.}

\item{average}{Logical scalar indicating whether the average should be computed instead of the sum.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether summation should be parallelized.}

\item{subset_row, subset_col, exprs_values}{Soft-deprecated equivalents of the arguments described above.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the matrix of counts
(or any other expression quantity that can be meaningfully summed).}
}
\value{
A count matrix is returned with one row per level of \code{ids}.
In each cell, counts for all features in the same set are summed together (or averaged, if \code{average=TRUE}).
Rows are ordered according to \code{levels(ids)}.
}
\description{
Sum together expression values (by default, counts) for each feature set in each cell.
}
\details{
This function provides a convenient method for aggregating counts across multiple rows for each cell.
Several possible applications are listed below:
\itemize{
\item Using a list of genes in \code{ids}, we can obtain a summary expression value for all genes in one or more gene sets.
This allows the activity of various pathways to be compared across cells.
\item Genes with multiple mapping locations in the reference will often manifest as multiple rows with distinct Ensembl/Entrez IDs.
These counts can be aggregated into a single feature by setting the shared identifier (usually the gene symbol) as \code{ids}.
\item It is theoretically possible to aggregate transcript-level counts to gene-level counts with this function.
However, it is often better to do so with dedicated functions (e.g., from the \pkg{tximport} or \pkg{tximeta} packages) that account for differences in length across isoforms.
}

The behaviour of this function is equivalent to that of \code{\link{rowsum}}.
However, this function can operate on any matrix representation in \code{object},
and can do so in a parallelized manner for large matrices without resorting to block processing.

If \code{ids} is a factor, any \code{NA} values are implicitly ignored and will not be considered or reported.
This may be useful, e.g., to remove undesirable feature sets by setting their entries in \code{ids} to \code{NA}.

Setting \code{average=TRUE} will compute the average in each set rather than the sum.
This is particularly useful if \code{x} contains expression values that have already been normalized in some manner,
as computing the average avoids another round of normalization to account for differences in the size of each set.
}
\examples{
example_sce <- mockSCE()
ids <- sample(LETTERS, nrow(example_sce), replace=TRUE)
out <- sumCountsAcrossFeatures(example_sce, ids)
str(out)
}
\seealso{
\code{\link{aggregateAcrossFeatures}}, to perform additional aggregation of row-level metadata.

\code{\link{numDetectedAcrossFeatures}}, to compute the number of detected features per cell.
}
\author{
Aaron Lun
}
