% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVarianceExplained.R
\name{getVarianceExplained}
\alias{getVarianceExplained}
\alias{getVarianceExplained,ANY-method}
\alias{getVarianceExplained,SummarizedExperiment-method}
\title{Per-gene variance explained by a variable}
\usage{
getVarianceExplained(x, ...)

\S4method{getVarianceExplained}{ANY}(x, variables, subset_row = NULL, BPPARAM = SerialParam())

\S4method{getVarianceExplained}{SummarizedExperiment}(x, variables = NULL, ..., exprs_values = "logcounts")
}
\arguments{
\item{x}{A numeric matrix of expression values, usually log-transformed and normalized.

Alternatively, a \linkS4class{SummarizedExperiment} containing such a matrix.}

\item{...}{For the generic, arguments to be passed to specific methods.
For the SummarizedExperiment method, arguments to be passed to the ANY method.}

\item{variables}{A \linkS4class{DataFrame} or data.frame containing one or more variables of interest.
This should have number of rows equal to the number of columns in \code{x}.

For the SummarizedExperiment method, this can also be a character vector specifying column names of \code{colData(x)} to use;
or \code{NULL}, in which case all columns in \code{colData(x)} are used.}

\item{subset_row}{A vector specifying the subset of rows of \code{x} for which to return a result.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether the calculations should be parallelized.}

\item{exprs_values}{String or integer scalar specifying the expression values for which to compute the variance.}
}
\value{
A numeric matrix containing the percentage of variance explained by each factor (column) and for each gene (row).
}
\description{
Compute, for each gene, the percentage of variance that is explained by one or more variables of interest.
}
\details{
This function computes the percentage of variance in gene expression that is explained by variables in the sample-level metadata.
It allows problematic factors to be quickly identified, as well as the genes that are most affected.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

r2mat <- getVarianceExplained(example_sce)
}
\seealso{
\code{\link{getExplanatoryPCs}}, which calls this function.

\code{\link{plotExplanatoryVariables}}, to plot the results.
}
\author{
Aaron Lun
}
