% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BlusterParam.R
\name{.defaultScalarArguments}
\alias{.defaultScalarArguments}
\alias{.defaultScalarArguments,BlusterParam-method}
\alias{.showScalarArguments}
\alias{.extractScalarArguments}
\title{Define the default arguments}
\usage{
.defaultScalarArguments(x)

.showScalarArguments(object)

.extractScalarArguments(x)
}
\arguments{
\item{x, object}{A \linkS4class{BlusterParam} object.}
}
\value{
For \code{.defaultScalarArguments}, a named character vector is returned.
Each entry corresponds to an argument to the clustering function - the name is the argument name, and the value is the argument type.

For \code{.extractScalarArguments}, a named list of non-default scalar arguments is returned.
Any arguments set to their default values are omitted from the list.

For \code{.showScalarArguments}, the values of the arguments are printed to screen.
Default values are marked with \code{[default]}.
}
\description{
Provide a consistent mechanism to handle specification of default arguments to the underlying clustering functions.
}
\details{
The idea is to simplify the derivation of new \linkS4class{BlusterParam} objects,
by allowing developers to indicate that the underlying function default should be used for particular arguments.
This avoids duplication of the default arguments in the object constructor;
instead, default arguments can be indicated as such by setting them to \code{NULL},
in which case they will not be explicitly passed to the underlying clustering function.
}
\examples{
.defaultScalarArguments(PamParam(10))
.extractScalarArguments(PamParam(10))
.extractScalarArguments(PamParam(10, variant="faster"))

}
\author{
Aaron Lun
}
