# PySNMP SMI module. Autogenerated from smidump -f python NAT-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:22 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifCounterDiscontinuityGroup, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifCounterDiscontinuityGroup", "ifIndex")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention")

# Types

class NatAddrMapId(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,4294967295)
    
class NatAssociationType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,)
    namedValues = NamedValues(("static", 1), ("dynamic", 2), )
    
class NatBindId(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,4294967295)
    
class NatBindIdOrZero(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,4294967295)
    
class NatBindMode(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,)
    namedValues = NamedValues(("addressBind", 1), ("addressPortBind", 2), )
    
class NatProtocolMap(Bits):
    namedValues = NamedValues(("other", 0), ("icmp", 1), ("udp", 2), ("tcp", 3), )
    
class NatProtocolType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,2,3,4,5,)
    namedValues = NamedValues(("none", 1), ("other", 2), ("icmp", 3), ("udp", 4), ("tcp", 5), )
    
class NatSessionId(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,4294967295)
    
class NatTranslationEntity(Bits):
    namedValues = NamedValues(("inboundSrcEndPoint", 0), ("outboundDstEndPoint", 1), ("inboundDstEndPoint", 2), ("outboundSrcEndPoint", 3), )
    

# Objects

natMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 123)).setRevisions(("2005-03-21 00:00",))
if mibBuilder.loadTexts: natMIB.setOrganization("IETF Transport Area")
if mibBuilder.loadTexts: natMIB.setContactInfo("\nRohit\nMascon Global Limited\n#59/2 100 ft Ring Road\nBanashankari II Stage\nBangalore 560 070\nIndia\nPhone: +91 80 2679 6227\nEmail: rrohit74@hotmail.com\n\nP. Srisuresh\nCaymas Systems, Inc.\n1179-A North McDowell Blvd.\nPetaluma, CA 94954\nTel: (707) 283-5063\nEmail: srisuresh@yahoo.com\n\nRajiv Raghunarayan\nCisco Systems Inc.\n170 West Tasman Drive\nSan Jose, CA 95134\nPhone: +1 408 853 9612\nEmail: raraghun@cisco.com\n\nNalinaksh Pai\nCisco Systems, Inc.\nPrestige Waterford\nNo. 9, Brunton Road\nBangalore - 560 025\n\n\n\nIndia\nPhone: +91 80 532 1300\nEmail: npai@cisco.com\n\nCliff Wang\nInformation Security\nBank One Corp\n1111 Polaris Pkwy\nColumbus, OH 43240\nPhone: +1 614 213 6117\nEmail: cliffwang2000@yahoo.com")
if mibBuilder.loadTexts: natMIB.setDescription("This MIB module defines the generic managed objects\nfor NAT.\n\nCopyright (C) The Internet Society (2005).  This version\nof this MIB module is part of RFC 4008;  see the RFC\nitself for full legal notices.")
natMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 0))
natMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 1))
natDefTimeouts = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 1, 1))
natBindDefIdleTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295)).clone(0)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natBindDefIdleTimeout.setDescription("The default Bind (Address Bind or Port Bind) idle\ntimeout parameter.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natUdpDefIdleTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(300)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natUdpDefIdleTimeout.setDescription("The default UDP idle timeout parameter.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natIcmpDefIdleTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(300)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natIcmpDefIdleTimeout.setDescription("The default ICMP idle timeout parameter.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natOtherDefIdleTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(60)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natOtherDefIdleTimeout.setDescription("The default idle timeout parameter for protocols\nrepresented by the value other (2) in\nNatProtocolType.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natTcpDefIdleTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(86400)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natTcpDefIdleTimeout.setDescription("The default time interval that a NAT session for an\nestablished TCP connection is allowed to remain\nvalid without any activity on the TCP connection.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natTcpDefNegTimeout = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295)).clone(60)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natTcpDefNegTimeout.setDescription("The default time interval that a NAT session for a TCP\nconnection that is not in the established state\nis allowed to remain valid without any activity on\nthe TCP connection.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
natNotifCtrl = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 1, 2))
natNotifThrottlingInterval = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 2, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(5,3600),)).clone(0)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: natNotifThrottlingInterval.setDescription("This object controls the generation of the\nnatPacketDiscard notification.\n\nIf this object has a value of zero, then no\nnatPacketDiscard notifications will be transmitted by the\nagent.\n\nIf this object has a non-zero value, then the agent must\nnot generate more than one natPacketDiscard\n'notification-event' in the indicated period, where a\n'notification-event' is the generation of a single\nnotification PDU type to a list of notification\ndestinations.  If additional NAT packets are discarded\nwithin the throttling period, then notification-events\nfor these changes must be suppressed by the agent until\nthe current throttling period expires.\n\nIf natNotifThrottlingInterval notification generation\nis enabled, the suggested default throttling period is\n60 seconds, but generation of the natPacketDiscard\nnotification should be disabled by default.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.\n\nThe actual transmission of notifications is controlled\nvia the MIB modules in RFC 3413.")
natInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 3))
if mibBuilder.loadTexts: natInterfaceTable.setDescription("This table specifies the attributes for interfaces on a\ndevice supporting NAT function.")
natInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: natInterfaceEntry.setDescription("Each entry in the natInterfaceTable holds a set of\nparameters for an interface, instantiated by\nifIndex.  Therefore, the interface index must have been\nassigned, according to the applicable procedures,\nbefore it can be meaningfully used.\nGenerally, this means that the interface must exist.\n\nWhen natStorageType is of type nonVolatile, however,\nthis may reflect the configuration for an interface whose\nifIndex has been assigned but for which the supporting\nimplementation is not currently present.")
natInterfaceRealm = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("private", 1), ("public", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natInterfaceRealm.setDescription("This object identifies whether this interface is\nconnected to the private or the public realm.")
natInterfaceServiceType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 2), Bits().subtype(namedValues=NamedValues(("basicNat", 0), ("napt", 1), ("bidirectionalNat", 2), ("twiceNat", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natInterfaceServiceType.setDescription("An indication of the direction in which new sessions\nare permitted and the extent of translation done within\nthe IP and transport headers.")
natInterfaceInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natInterfaceInTranslates.setDescription("Number of packets received on this interface that\nwere translated.\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natInterfaceOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natInterfaceOutTranslates.setDescription("Number of translated packets that were sent out this\ninterface.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes as indicated by the value of\n\n\n\nifCounterDiscontinuityTime on the relevant interface.")
natInterfaceDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natInterfaceDiscards.setDescription("Number of packets that had to be rejected/dropped due to\na lack of resources for this interface.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natInterfaceStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natInterfaceStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent'\nneed not allow write-access to any columnar objects\nin the row.")
natInterfaceRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 3, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natInterfaceRowStatus.setDescription("The status of this conceptual row.\n\nUntil instances of all corresponding columns are\nappropriately configured, the value of the\ncorresponding instance of the natInterfaceRowStatus\ncolumn is 'notReady'.\n\n\nIn particular, a newly created row cannot be made\nactive until the corresponding instance of\nnatInterfaceServiceType has been set.\n\n\n\n\nNone of the objects in this row may be modified\nwhile the value of this object is active(1).")
natAddrMapTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 4))
if mibBuilder.loadTexts: natAddrMapTable.setDescription("This table lists address map parameters for NAT.")
natAddrMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "NAT-MIB", "natAddrMapIndex"))
if mibBuilder.loadTexts: natAddrMapEntry.setDescription("This entry represents an address map to be used for\nNAT and contributes to the dynamic and/or static\naddress mapping tables of the NAT device.")
natAddrMapIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 1), NatAddrMapId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrMapIndex.setDescription("Along with ifIndex, this object uniquely\nidentifies an entry in the natAddrMapTable.\nAddress map entries are applied in the order\nspecified by natAddrMapIndex.")
natAddrMapName = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapName.setDescription("Name identifying all map entries in the table associated\nwith the same interface.  All map entries with the same\nifIndex MUST have the same map name.")
natAddrMapEntryType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 3), NatAssociationType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapEntryType.setDescription("This parameter can be used to set up static\nor dynamic address maps.")
natAddrMapTranslationEntity = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 4), NatTranslationEntity()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapTranslationEntity.setDescription("The end-point entity (source or destination) in\ninbound or outbound sessions (i.e., first packets) that\nmay be translated by an address map entry.\n\nSession direction (inbound or outbound) is\nderived from the direction of the first packet\nof a session traversing a NAT interface.\nNAT address (and Transport-ID) maps may be defined\n\n\n\nto effect inbound or outbound sessions.\n\nTraditionally, address maps for Basic NAT and NAPT are\nconfigured on a public interface for outbound sessions,\neffecting translation of source end-point.  The value of\nthis object must be set to outboundSrcEndPoint for\nthose interfaces.\n\nAlternately, if address maps for Basic NAT and NAPT were\nto be configured on a private interface, the desired\nvalue for this object for the map entries\nwould be inboundSrcEndPoint (i.e., effecting translation\nof source end-point for inbound sessions).\n\nIf TwiceNAT were to be configured on a private interface,\nthe desired value for this object for the map entries\nwould be a bitmask of inboundSrcEndPoint and\ninboundDstEndPoint.")
natAddrMapLocalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 5), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapLocalAddrType.setDescription("This object specifies the address type used for\nnatAddrMapLocalAddrFrom and natAddrMapLocalAddrTo.")
natAddrMapLocalAddrFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 6), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapLocalAddrFrom.setDescription("This object specifies the first IP address of the range\nof IP addresses mapped by this translation entry.  The\nvalue of this object must be less than or equal to the\nvalue of the natAddrMapLocalAddrTo object.\n\nThe type of this address is determined by the value of\nthe natAddrMapLocalAddrType object.")
natAddrMapLocalAddrTo = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 7), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapLocalAddrTo.setDescription("This object specifies the last IP address of the range of\nIP addresses mapped by this translation entry.  If only\na single address is being mapped, the value of this object\nis equal to the value of natAddrMapLocalAddrFrom.  For a\nstatic NAT, the number of addresses in the range defined\nby natAddrMapLocalAddrFrom and natAddrMapLocalAddrTo must\nbe equal to the number of addresses in the range defined by\nnatAddrMapGlobalAddrFrom and natAddrMapGlobalAddrTo.\nThe value of this object must be greater than or equal to\nthe value of the natAddrMapLocalAddrFrom object.\n\nThe type of this address is determined by the value of\nthe natAddrMapLocalAddrType object.")
natAddrMapLocalPortFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 8), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapLocalPortFrom.setDescription("If this conceptual row describes a Basic NAT address\nmapping, then the value of this object must be zero.  If\nthis conceptual row describes NAPT, then the value of\nthis object specifies the first port number in the range\nof ports being mapped.\n\nThe value of this object must be less than or equal to the\nvalue of the natAddrMapLocalPortTo object.  If the\ntranslation specifies a single port, then the value of this\nobject is equal to the value of natAddrMapLocalPortTo.")
natAddrMapLocalPortTo = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 9), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapLocalPortTo.setDescription("If this conceptual row describes a Basic NAT address\nmapping, then the value of this object must be zero.  If\nthis conceptual row describes NAPT, then the value of\nthis object specifies the last port number in the range\nof ports being mapped.\n\nThe value of this object must be greater than or equal to\nthe value of the natAddrMapLocalPortFrom object.  If the\ntranslation specifies a single port, then the value of this\nobject is equal to the value of natAddrMapLocalPortFrom.")
natAddrMapGlobalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 10), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapGlobalAddrType.setDescription("This object specifies the address type used for\nnatAddrMapGlobalAddrFrom and natAddrMapGlobalAddrTo.")
natAddrMapGlobalAddrFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 11), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapGlobalAddrFrom.setDescription("This object specifies the first IP address of the range of\nIP addresses being mapped to.  The value of this object\nmust be less than or equal to the value of the\nnatAddrMapGlobalAddrTo object.\n\nThe type of this address is determined by the value of\nthe natAddrMapGlobalAddrType object.")
natAddrMapGlobalAddrTo = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 12), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapGlobalAddrTo.setDescription("This object specifies the last IP address of the range of\nIP addresses being mapped to.  If only a single address is\nbeing mapped to, the value of this object is equal to the\nvalue of natAddrMapGlobalAddrFrom.  For a static NAT, the\nnumber of addresses in the range defined by\nnatAddrMapGlobalAddrFrom and natAddrMapGlobalAddrTo must be\nequal to the number of addresses in the range defined by\nnatAddrMapLocalAddrFrom and natAddrMapLocalAddrTo.\nThe value of this object must be greater than or equal to\nthe value of the natAddrMapGlobalAddrFrom object.\n\nThe type of this address is determined by the value of\nthe natAddrMapGlobalAddrType object.")
natAddrMapGlobalPortFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 13), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapGlobalPortFrom.setDescription("If this conceptual row describes a Basic NAT address\nmapping, then the value of this object must be zero.  If\nthis conceptual row describes NAPT, then the value of\nthis object specifies the first port number in the range\nof ports being mapped to.\n\n\nThe value of this object must be less than or equal to the\nvalue of the natAddrMapGlobalPortTo object.  If the\ntranslation specifies a single port, then the value of this\nobject is equal to the value natAddrMapGlobalPortTo.")
natAddrMapGlobalPortTo = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 14), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapGlobalPortTo.setDescription("If this conceptual row describes a Basic NAT address\nmapping, then the value of this object must be zero.  If\nthis conceptual row describes NAPT, then the value of this\nobject specifies the last port number in the range of\nports being mapped to.\n\nThe value of this object must be greater than or equal to\nthe value of the natAddrMapGlobalPortFrom object.  If the\ntranslation specifies a single port, then the value of this\nobject is equal to the value of natAddrMapGlobalPortFrom.")
natAddrMapProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 15), NatProtocolMap()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapProtocol.setDescription("This object specifies a bitmap of protocol identifiers.")
natAddrMapInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 16), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrMapInTranslates.setDescription("The number of inbound packets pertaining to this address\nmap entry that were translated.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natAddrMapOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 17), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrMapOutTranslates.setDescription("The number of outbound packets pertaining to this\naddress map entry that were translated.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natAddrMapDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 18), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrMapDiscards.setDescription("The number of packets pertaining to this address map\nentry that were dropped due to lack of addresses in the\naddress pool identified by this address map.  The value of\nthis object must always be zero in case of static\naddress map.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natAddrMapAddrUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 19), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrMapAddrUsed.setDescription("The number of addresses pertaining to this address map\nthat are currently being used from the NAT pool.\nThe value of this object must always be zero in the case\n\n\n\nof a static address map.")
natAddrMapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 20), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent'\nneed not allow write-access to any columnar objects\nin the row.")
natAddrMapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 4, 1, 21), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: natAddrMapRowStatus.setDescription("The status of this conceptual row.\n\nUntil instances of all corresponding columns are\nappropriately configured, the value of the\ncorresponding instance of the natAddrMapRowStatus\ncolumn is 'notReady'.\n\nNone of the objects in this row may be modified\nwhile the value of this object is active(1).")
natAddrBindNumberOfEntries = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindNumberOfEntries.setDescription("This object maintains a count of the number of entries\nthat currently exist in the natAddrBindTable.")
natAddrBindTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 6))
if mibBuilder.loadTexts: natAddrBindTable.setDescription("This table holds information about the currently\nactive NAT BINDs.")
natAddrBindEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "NAT-MIB", "natAddrBindLocalAddrType"), (0, "NAT-MIB", "natAddrBindLocalAddr"))
if mibBuilder.loadTexts: natAddrBindEntry.setDescription("Each entry in this table holds information about\nan active address BIND.  These entries are lost\nupon agent restart.\n\nThis row has indexing which may create variables with\nmore than 128 subidentifiers.  Implementers of this table\nmust be careful not to create entries that would result\nin OIDs which exceed the 128 subidentifier limit.\nOtherwise, the information cannot be accessed using\nSNMPv1, SNMPv2c or SNMPv3.")
natAddrBindLocalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrBindLocalAddrType.setDescription("This object specifies the address type used for\nnatAddrBindLocalAddr.")
natAddrBindLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrBindLocalAddr.setDescription("This object represents the private-realm specific network\nlayer address, which maps to the public-realm address\nrepresented by natAddrBindGlobalAddr.\n\nThe type of this address is determined by the value of\nthe natAddrBindLocalAddrType object.")
natAddrBindGlobalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindGlobalAddrType.setDescription("This object specifies the address type used for\nnatAddrBindGlobalAddr.")
natAddrBindGlobalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 4), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindGlobalAddr.setDescription("This object represents the public-realm network layer\naddress that maps to the private-realm network layer\naddress represented by natAddrBindLocalAddr.\n\nThe type of this address is determined by the value of\nthe natAddrBindGlobalAddrType object.")
natAddrBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 5), NatBindId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindId.setDescription("This object represents a bind id that is dynamically\nassigned to each bind by a NAT enabled device.  Each\nbind is represented by a bind id that is\nunique across both, the natAddrBindTable and the\nnatAddrPortBindTable.")
natAddrBindTranslationEntity = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 6), NatTranslationEntity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindTranslationEntity.setDescription("This object represents the direction of sessions\nfor which this bind is applicable and the endpoint entity\n(source or destination) within the sessions that is\nsubject to translation using the BIND.\n\nOrientation of the bind can be a superset of\ntranslationEntity of the address map entry which\nforms the basis for this bind.\n\nFor example, if the translationEntity of an\naddress map entry is outboundSrcEndPoint, the\ntranslationEntity of a bind derived from this\nmap entry may either be outboundSrcEndPoint or\nit may be bidirectional (a bitmask of\noutboundSrcEndPoint and inboundDstEndPoint).")
natAddrBindType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 7), NatAssociationType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindType.setDescription("This object indicates whether the bind is static or\ndynamic.")
natAddrBindMapIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 8), NatAddrMapId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindMapIndex.setDescription("This object is a pointer to the natAddrMapTable entry\n(and the parameters of that entry) which was used in\ncreating this BIND.  This object, in conjunction with the\nifIndex (which identifies a unique addrMapName) points to\n\n\n\na unique entry in the natAddrMapTable.")
natAddrBindSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindSessions.setDescription("Number of sessions currently using this BIND.")
natAddrBindMaxIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 10), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindMaxIdleTime.setDescription("This object indicates the maximum time for\nwhich this bind can be idle with no sessions\nattached to it.\n\nThe value of this object is of relevance only for\ndynamic NAT.")
natAddrBindCurrentIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindCurrentIdleTime.setDescription("At any given instance, this object indicates the\ntime that this bind has been idle without any sessions\nattached to it.\n\nThe value of this object is of relevance only for\ndynamic NAT.")
natAddrBindInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindInTranslates.setDescription("The number of inbound packets that were successfully\ntranslated by using this bind entry.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\n\n\n\nifCounterDiscontinuityTime on the relevant interface.")
natAddrBindOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 6, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrBindOutTranslates.setDescription("The number of outbound packets that were successfully\ntranslated using this bind entry.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natAddrPortBindNumberOfEntries = MibScalar((1, 3, 6, 1, 2, 1, 123, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindNumberOfEntries.setDescription("This object maintains a count of the number of entries\nthat currently exist in the natAddrPortBindTable.")
natAddrPortBindTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 8))
if mibBuilder.loadTexts: natAddrPortBindTable.setDescription("This table holds information about the currently\nactive NAPT BINDs.")
natAddrPortBindEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 8, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "NAT-MIB", "natAddrPortBindLocalAddrType"), (0, "NAT-MIB", "natAddrPortBindLocalAddr"), (0, "NAT-MIB", "natAddrPortBindLocalPort"), (0, "NAT-MIB", "natAddrPortBindProtocol"))
if mibBuilder.loadTexts: natAddrPortBindEntry.setDescription("Each entry in the this table holds information\nabout a NAPT bind that is currently active.\nThese entries are lost upon agent restart.\n\nThis row has indexing which may create variables with\nmore than 128 subidentifiers.  Implementers of this table\nmust be careful not to create entries which would result\nin OIDs that exceed the 128 subidentifier limit.\nOtherwise, the information cannot be accessed using\nSNMPv1, SNMPv2c or SNMPv3.")
natAddrPortBindLocalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrPortBindLocalAddrType.setDescription("This object specifies the address type used for\nnatAddrPortBindLocalAddr.")
natAddrPortBindLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrPortBindLocalAddr.setDescription("This object represents the private-realm specific network\nlayer address which, in conjunction with\nnatAddrPortBindLocalPort, maps to the public-realm\nnetwork layer address and transport id represented by\nnatAddrPortBindGlobalAddr and natAddrPortBindGlobalPort\nrespectively.\n\n\nThe type of this address is determined by the value of\nthe natAddrPortBindLocalAddrType object.")
natAddrPortBindLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 3), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrPortBindLocalPort.setDescription("For a protocol value TCP or UDP, this object represents\nthe private-realm specific port number.  On the other\nhand, for ICMP a bind is created only for query/response\ntype ICMP messages such as ICMP echo, Timestamp, and\nInformation request messages, and this object represents\nthe private-realm specific identifier in the ICMP\nmessage, as defined in RFC 792 for ICMPv4 and in RFC\n2463 for ICMPv6.\n\nThis object, together with natAddrPortBindProtocol,\nnatAddrPortBindLocalAddrType, and natAddrPortBindLocalAddr,\nconstitutes a session endpoint in the private realm.  A\nbind entry binds a private realm specific endpoint to a\npublic realm specific endpoint, as represented by the\ntuple of (natAddrPortBindGlobalPort,\nnatAddrPortBindProtocol, natAddrPortBindGlobalAddrType,\nand natAddrPortBindGlobalAddr).")
natAddrPortBindProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 4), NatProtocolType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natAddrPortBindProtocol.setDescription("This object specifies a protocol identifier.  If the\nvalue of this object is none(1), then this bind entry\napplies to all IP traffic.  Any other value of this object\nspecifies the class of IP traffic to which this BIND\napplies.")
natAddrPortBindGlobalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindGlobalAddrType.setDescription("This object specifies the address type used for\nnatAddrPortBindGlobalAddr.")
natAddrPortBindGlobalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindGlobalAddr.setDescription("This object represents the public-realm specific network\nlayer address that, in conjunction with\nnatAddrPortBindGlobalPort, maps to the private-realm\n\nnetwork layer address and transport id represented by\nnatAddrPortBindLocalAddr and natAddrPortBindLocalPort,\nrespectively.\n\nThe type of this address is determined by the value of\nthe natAddrPortBindGlobalAddrType object.")
natAddrPortBindGlobalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 7), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindGlobalPort.setDescription("For a protocol value TCP or UDP, this object represents\nthe public-realm specific port number.  On the other\nhand, for ICMP a bind is created only for query/response\ntype ICMP messages such as ICMP echo, Timestamp, and\nInformation request messages, and this object represents\nthe public-realm specific identifier in the ICMP message,\nas defined in RFC 792 for ICMPv4 and in RFC 2463 for\nICMPv6.\n\nThis object, together with natAddrPortBindProtocol,\nnatAddrPortBindGlobalAddrType, and\nnatAddrPortBindGlobalAddr, constitutes a session endpoint\nin the public realm.  A bind entry binds a public realm\nspecific endpoint to a private realm specific endpoint,\nas represented by the tuple of\n (natAddrPortBindLocalPort, natAddrPortBindProtocol,\n  natAddrPortBindLocalAddrType, and\n\n\n\n  natAddrPortBindLocalAddr).")
natAddrPortBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 8), NatBindId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindId.setDescription("This object represents a bind id that is dynamically\nassigned to each bind by a NAT enabled device.  Each\nbind is represented by a unique bind id across both\nthe natAddrBindTable and the natAddrPortBindTable.")
natAddrPortBindTranslationEntity = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 9), NatTranslationEntity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindTranslationEntity.setDescription("This object represents the direction of sessions\nfor which this bind is applicable and the entity\n(source or destination) within the sessions that is\nsubject to translation with the BIND.\n\nOrientation of the bind can be a superset of the\ntranslationEntity of the address map entry that\nforms the basis for this bind.\n\nFor example, if the translationEntity of an\naddress map entry is outboundSrcEndPoint, the\ntranslationEntity of a bind derived from this\nmap entry may either be outboundSrcEndPoint or\nmay be bidirectional (a bitmask of\noutboundSrcEndPoint and inboundDstEndPoint).")
natAddrPortBindType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 10), NatAssociationType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindType.setDescription("This object indicates whether the bind is static or\ndynamic.")
natAddrPortBindMapIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 11), NatAddrMapId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindMapIndex.setDescription("This object is a pointer to the natAddrMapTable entry\n(and the parameters of that entry) used in\ncreating this BIND.  This object, in conjunction with the\nifIndex (which identifies a unique addrMapName), points\nto a unique entry in the natAddrMapTable.")
natAddrPortBindSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindSessions.setDescription("Number of sessions currently using this BIND.")
natAddrPortBindMaxIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 13), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindMaxIdleTime.setDescription("This object indicates the maximum time for\nwhich this bind can be idle without any sessions\nattached to it.\nThe value of this object is of relevance\nonly for dynamic NAT.")
natAddrPortBindCurrentIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 14), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindCurrentIdleTime.setDescription("At any given instance, this object indicates the\ntime that this bind has been idle without any sessions\nattached to it.\n\nThe value of this object is of relevance\nonly for dynamic NAT.")
natAddrPortBindInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 15), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindInTranslates.setDescription("The number of inbound packets that were translated as per\nthis bind entry.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natAddrPortBindOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 8, 1, 16), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natAddrPortBindOutTranslates.setDescription("The number of outbound packets that were translated as per\nthis bind entry.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natSessionTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 9))
if mibBuilder.loadTexts: natSessionTable.setDescription("The (conceptual) table containing one entry for each\nNAT session currently active on this NAT device.")
natSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 9, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "NAT-MIB", "natSessionIndex"))
if mibBuilder.loadTexts: natSessionEntry.setDescription("An entry (conceptual row) containing information\nabout an active NAT session on this NAT device.\nThese entries are lost upon agent restart.")
natSessionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 1), NatSessionId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natSessionIndex.setDescription("The session ID for this NAT session.")
natSessionPrivateSrcEPBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 2), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateSrcEPBindId.setDescription("The bind id associated between private and public\nsource end points.  In the case of Symmetric-NAT,\nthis should be set to zero.")
natSessionPrivateSrcEPBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 3), NatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateSrcEPBindMode.setDescription("This object indicates whether the bind indicated\nby the object natSessionPrivateSrcEPBindId\nis an address bind or an address port bind.")
natSessionPrivateDstEPBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 4), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateDstEPBindId.setDescription("The bind id associated between private and public\ndestination end points.")
natSessionPrivateDstEPBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 5), NatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateDstEPBindMode.setDescription("This object indicates whether the bind indicated\nby the object natSessionPrivateDstEPBindId\nis an address bind or an address port bind.")
natSessionDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("inbound", 1), ("outbound", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionDirection.setDescription("The direction of this session with respect to the\nlocal network.  'inbound' indicates that this session\nwas initiated from the public network into the private\nnetwork.  'outbound' indicates that this session was\ninitiated from the private network into the public\nnetwork.")
natSessionUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionUpTime.setDescription("The up time of this session in one-hundredths of a\nsecond.")
natSessionAddrMapIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 8), NatAddrMapId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionAddrMapIndex.setDescription("This object is a pointer to the natAddrMapTable entry\n(and the parameters of that entry) used in\ncreating this session.  This object, in conjunction with\nthe ifIndex (which identifies a unique addrMapName), points\nto a unique entry in the natAddrMapTable.")
natSessionProtocolType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 9), NatProtocolType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionProtocolType.setDescription("The protocol type of this session.")
natSessionPrivateAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 10), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateAddrType.setDescription("This object specifies the address type used for\nnatSessionPrivateSrcAddr and natSessionPrivateDstAddr.")
natSessionPrivateSrcAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 11), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateSrcAddr.setDescription("The source IP address of the session endpoint that\nlies in the private network.\n\nThe value of this object must be zero only when the\nnatSessionPrivateSrcEPBindId object has a zero value.\nWhen the value of this object is zero, the NAT session\nlookup will match any IP address to this field.\n\nThe type of this address is determined by the value of\nthe natSessionPrivateAddrType object.")
natSessionPrivateSrcPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 12), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateSrcPort.setDescription("When the value of protocol is TCP or UDP, this object\nrepresents the source port in the first packet of session\nwhile in private-realm.  On the other hand, when the\nprotocol is ICMP, a NAT session is created only for\nquery/response type ICMP messages such as ICMP echo,\nTimestamp, and Information request messages, and this\nobject represents the private-realm specific identifier\nin the ICMP message, as defined in RFC 792 for ICMPv4\nand in RFC 2463 for ICMPv6.\n\nThe value of this object must be zero when the\nnatSessionPrivateSrcEPBindId object has zero value\nand value of natSessionPrivateSrcEPBindMode is\naddressPortBind(2).  In such a case, the NAT session\nlookup will match any port number to this field.\n\nThe value of this object must be zero when the object\nis not a representative field (SrcPort, DstPort, or\nICMP identifier) of the session tuple in either the\npublic realm or the private realm.")
natSessionPrivateDstAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 13), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateDstAddr.setDescription("The destination IP address of the session endpoint that\nlies in the private network.\n\nThe value of this object must be zero when the\nnatSessionPrivateDstEPBindId object has a zero value.\nIn such a scenario, the NAT session lookup will match\nany IP address to this field.\n\nThe type of this address is determined by the value of\nthe natSessionPrivateAddrType object.")
natSessionPrivateDstPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 14), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPrivateDstPort.setDescription("When the value of protocol is TCP or UDP, this object\nrepresents the destination port in the first packet\nof session while in private-realm.  On the other hand,\nwhen the protocol is ICMP, this object is not relevant\nand should be set to zero.\n\nThe value of this object must be zero when the\nnatSessionPrivateDstEPBindId object has a zero\nvalue and natSessionPrivateDstEPBindMode is set to\naddressPortBind(2).  In such a case, the NAT session\nlookup will match any port number to this field.\n\nThe value of this object must be zero when the object\nis not a representative field (SrcPort, DstPort, or\nICMP identifier) of the session tuple in either the\npublic realm or the private realm.")
natSessionPublicAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 15), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPublicAddrType.setDescription("This object specifies the address type used for\nnatSessionPublicSrcAddr and natSessionPublicDstAddr.")
natSessionPublicSrcAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 16), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPublicSrcAddr.setDescription("The source IP address of the session endpoint that\nlies in the public network.\n\nThe value of this object must be zero when the\nnatSessionPrivateSrcEPBindId object has a zero value.\nIn such a scenario, the NAT session lookup will match\nany IP address to this field.\n\nThe type of this address is determined by the value of\nthe natSessionPublicAddrType object.")
natSessionPublicSrcPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 17), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPublicSrcPort.setDescription("When the value of protocol is TCP or UDP, this object\nrepresents the source port in the first packet of\nsession while in public-realm.  On the other hand, when\nprotocol is ICMP, a NAT session is created only for\nquery/response type ICMP messages such as ICMP echo,\nTimestamp, and Information request messages, and this\nobject represents the public-realm specific identifier\nin the ICMP message, as defined in RFC 792 for ICMPv4\nand in RFC 2463 for ICMPv6.\n\nThe value of this object must be zero when the\nnatSessionPrivateSrcEPBindId object has a zero value\nand natSessionPrivateSrcEPBindMode is set to\naddressPortBind(2).  In such a scenario, the NAT\nsession lookup will match any port number to this\nfield.\n\nThe value of this object must be zero when the object\nis not a representative field (SrcPort, DstPort or\nICMP identifier) of the session tuple in either the\npublic realm or the private realm.")
natSessionPublicDstAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 18), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPublicDstAddr.setDescription("The destination IP address of the session endpoint that\nlies in the public network.\n\nThe value of this object must be non-zero when the\nnatSessionPrivateDstEPBindId object has a non-zero\nvalue.  If the value of this object and the\ncorresponding natSessionPrivateDstEPBindId object value\nis zero, then the NAT session lookup will match any IP\naddress to this field.\n\nThe type of this address is determined by the value of\nthe natSessionPublicAddrType object.")
natSessionPublicDstPort = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 19), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionPublicDstPort.setDescription("When the value of protocol is TCP or UDP, this object\nrepresents the destination port in the first packet of\nsession while in public-realm.  On the other hand, when\nthe protocol is ICMP, this object is not relevant for\ntranslation and should be zero.\n\nThe value of this object must be zero when the\nnatSessionPrivateDstEPBindId object has a zero value\nand natSessionPrivateDstEPBindMode is\naddressPortBind(2).  In such a scenario, the NAT\nsession lookup will match any port number to this\nfield.\n\nThe value of this object must be zero when the object\nis not a representative field (SrcPort, DstPort, or\nICMP identifier) of the session tuple in either the\npublic realm or the private realm.")
natSessionMaxIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 20), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionMaxIdleTime.setDescription("The max time for which this session can be idle\nwithout detecting a packet.")
natSessionCurrentIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 21), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionCurrentIdleTime.setDescription("The time since a packet belonging to this session was\nlast detected.")
natSessionInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 22), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionInTranslates.setDescription("The number of inbound packets that were translated for\nthis session.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\n\n\n\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natSessionOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 9, 1, 23), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natSessionOutTranslates.setDescription("The number of outbound packets that were translated for\nthis session.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natProtocolTable = MibTable((1, 3, 6, 1, 2, 1, 123, 1, 10))
if mibBuilder.loadTexts: natProtocolTable.setDescription("The (conceptual) table containing per protocol NAT\nstatistics.")
natProtocolEntry = MibTableRow((1, 3, 6, 1, 2, 1, 123, 1, 10, 1)).setIndexNames((0, "NAT-MIB", "natProtocol"))
if mibBuilder.loadTexts: natProtocolEntry.setDescription("An entry (conceptual row) containing NAT statistics\npertaining to a particular protocol.")
natProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 10, 1, 1), NatProtocolType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: natProtocol.setDescription("This object represents the protocol pertaining to which\nparameters are reported.")
natProtocolInTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 10, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natProtocolInTranslates.setDescription("The number of inbound packets pertaining to the protocol\nidentified by natProtocol that underwent NAT.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natProtocolOutTranslates = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 10, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natProtocolOutTranslates.setDescription("The number of outbound packets pertaining to the protocol\nidentified by natProtocol that underwent NAT.\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natProtocolDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 123, 1, 10, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: natProtocolDiscards.setDescription("The number of packets pertaining to the protocol\nidentified by natProtocol that had to be\nrejected/dropped due to lack of resources.  These\nrejections could be due to session timeout, resource\nunavailability, lack of address space, etc.\n\n\n\n\nDiscontinuities in the value of this counter can occur at\nreinitialization of the management system and at other\ntimes, as indicated by the value of\nifCounterDiscontinuityTime on the relevant interface.")
natMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 2))
natMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 2, 1))
natMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 123, 2, 2))

# Augmentions

# Notifications

natPacketDiscard = NotificationType((1, 3, 6, 1, 2, 1, 123, 0, 1)).setObjects(*(("IF-MIB", "ifIndex"), ) )
if mibBuilder.loadTexts: natPacketDiscard.setDescription("This notification is generated when IP packets are\ndiscarded by the NAT function; e.g., due to lack of\nmapping space when NAT is out of addresses or ports.\n\nNote that the generation of natPacketDiscard\nnotifications is throttled by the agent, as specified\nby the 'natNotifThrottlingInterval' object.")

# Groups

natConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 1)).setObjects(*(("NAT-MIB", "natInterfaceRowStatus"), ("NAT-MIB", "natAddrMapLocalAddrFrom"), ("NAT-MIB", "natInterfaceStorageType"), ("NAT-MIB", "natUdpDefIdleTimeout"), ("NAT-MIB", "natAddrMapGlobalAddrTo"), ("NAT-MIB", "natOtherDefIdleTimeout"), ("NAT-MIB", "natAddrMapEntryType"), ("NAT-MIB", "natInterfaceRealm"), ("NAT-MIB", "natTcpDefNegTimeout"), ("NAT-MIB", "natAddrMapLocalPortFrom"), ("NAT-MIB", "natAddrMapName"), ("NAT-MIB", "natTcpDefIdleTimeout"), ("NAT-MIB", "natAddrMapLocalAddrType"), ("NAT-MIB", "natAddrMapGlobalPortFrom"), ("NAT-MIB", "natAddrMapLocalAddrTo"), ("NAT-MIB", "natAddrMapStorageType"), ("NAT-MIB", "natAddrMapRowStatus"), ("NAT-MIB", "natInterfaceServiceType"), ("NAT-MIB", "natAddrMapGlobalAddrFrom"), ("NAT-MIB", "natNotifThrottlingInterval"), ("NAT-MIB", "natAddrMapGlobalPortTo"), ("NAT-MIB", "natAddrMapGlobalAddrType"), ("NAT-MIB", "natAddrMapLocalPortTo"), ("NAT-MIB", "natAddrMapProtocol"), ("NAT-MIB", "natBindDefIdleTimeout"), ("NAT-MIB", "natAddrMapTranslationEntity"), ("NAT-MIB", "natIcmpDefIdleTimeout"), ) )
if mibBuilder.loadTexts: natConfigGroup.setDescription("A collection of configuration-related information\nrequired to support management of devices supporting\nNAT.")
natTranslationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 2)).setObjects(*(("NAT-MIB", "natSessionPrivateDstEPBindId"), ("NAT-MIB", "natAddrPortBindGlobalAddr"), ("NAT-MIB", "natSessionPrivateSrcEPBindId"), ("NAT-MIB", "natAddrPortBindTranslationEntity"), ("NAT-MIB", "natSessionCurrentIdleTime"), ("NAT-MIB", "natAddrBindNumberOfEntries"), ("NAT-MIB", "natAddrBindMaxIdleTime"), ("NAT-MIB", "natSessionDirection"), ("NAT-MIB", "natAddrPortBindSessions"), ("NAT-MIB", "natAddrBindInTranslates"), ("NAT-MIB", "natSessionPrivateSrcEPBindMode"), ("NAT-MIB", "natAddrBindId"), ("NAT-MIB", "natAddrPortBindId"), ("NAT-MIB", "natSessionUpTime"), ("NAT-MIB", "natAddrPortBindGlobalAddrType"), ("NAT-MIB", "natAddrBindSessions"), ("NAT-MIB", "natAddrBindOutTranslates"), ("NAT-MIB", "natSessionPrivateDstPort"), ("NAT-MIB", "natSessionOutTranslates"), ("NAT-MIB", "natSessionPublicAddrType"), ("NAT-MIB", "natAddrBindGlobalAddr"), ("NAT-MIB", "natSessionPrivateSrcPort"), ("NAT-MIB", "natSessionProtocolType"), ("NAT-MIB", "natAddrPortBindInTranslates"), ("NAT-MIB", "natSessionPublicSrcAddr"), ("NAT-MIB", "natSessionPrivateSrcAddr"), ("NAT-MIB", "natAddrBindGlobalAddrType"), ("NAT-MIB", "natAddrPortBindMapIndex"), ("NAT-MIB", "natSessionPrivateDstAddr"), ("NAT-MIB", "natAddrBindCurrentIdleTime"), ("NAT-MIB", "natSessionPrivateAddrType"), ("NAT-MIB", "natSessionAddrMapIndex"), ("NAT-MIB", "natAddrBindMapIndex"), ("NAT-MIB", "natAddrPortBindMaxIdleTime"), ("NAT-MIB", "natSessionPrivateDstEPBindMode"), ("NAT-MIB", "natSessionMaxIdleTime"), ("NAT-MIB", "natSessionPublicDstAddr"), ("NAT-MIB", "natSessionPublicSrcPort"), ("NAT-MIB", "natAddrPortBindGlobalPort"), ("NAT-MIB", "natAddrBindType"), ("NAT-MIB", "natSessionPublicDstPort"), ("NAT-MIB", "natAddrPortBindNumberOfEntries"), ("NAT-MIB", "natAddrPortBindCurrentIdleTime"), ("NAT-MIB", "natAddrPortBindOutTranslates"), ("NAT-MIB", "natAddrBindTranslationEntity"), ("NAT-MIB", "natSessionInTranslates"), ("NAT-MIB", "natAddrPortBindType"), ) )
if mibBuilder.loadTexts: natTranslationGroup.setDescription("A collection of BIND-related objects required to support\nmanagement of devices supporting NAT.")
natStatsInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 3)).setObjects(*(("NAT-MIB", "natInterfaceInTranslates"), ("NAT-MIB", "natInterfaceOutTranslates"), ("NAT-MIB", "natInterfaceDiscards"), ) )
if mibBuilder.loadTexts: natStatsInterfaceGroup.setDescription("A collection of NAT statistics associated with the\ninterface on which NAT is configured, to aid\ntroubleshooting/monitoring of the NAT operation.")
natStatsProtocolGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 4)).setObjects(*(("NAT-MIB", "natProtocolInTranslates"), ("NAT-MIB", "natProtocolOutTranslates"), ("NAT-MIB", "natProtocolDiscards"), ) )
if mibBuilder.loadTexts: natStatsProtocolGroup.setDescription("A collection of protocol specific NAT statistics,\nto aid troubleshooting/monitoring of NAT operation.")
natStatsAddrMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 5)).setObjects(*(("NAT-MIB", "natAddrMapOutTranslates"), ("NAT-MIB", "natAddrMapAddrUsed"), ("NAT-MIB", "natAddrMapInTranslates"), ("NAT-MIB", "natAddrMapDiscards"), ) )
if mibBuilder.loadTexts: natStatsAddrMapGroup.setDescription("A collection of address map specific NAT statistics,\nto aid troubleshooting/monitoring of NAT operation.")
natMIBNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 123, 2, 1, 6)).setObjects(*(("NAT-MIB", "natPacketDiscard"), ) )
if mibBuilder.loadTexts: natMIBNotificationGroup.setDescription("A collection of notifications generated by\ndevices supporting this MIB.")

# Compliances

natMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 123, 2, 2, 1)).setObjects(*(("NAT-MIB", "natTranslationGroup"), ("NAT-MIB", "natConfigGroup"), ("NAT-MIB", "natStatsAddrMapGroup"), ("NAT-MIB", "natMIBNotificationGroup"), ("IF-MIB", "ifCounterDiscontinuityGroup"), ("NAT-MIB", "natStatsProtocolGroup"), ("NAT-MIB", "natStatsInterfaceGroup"), ) )
if mibBuilder.loadTexts: natMIBFullCompliance.setDescription("When this MIB is implemented with support for\nread-create, then such an implementation can claim\nfull compliance.  Such devices can then be both\nmonitored and configured with this MIB.\n\nThe following index objects cannot be added as OBJECT\nclauses but nevertheless have the compliance\nrequirements:\n    ")
natMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 123, 2, 2, 2)).setObjects(*(("NAT-MIB", "natTranslationGroup"), ("NAT-MIB", "natConfigGroup"), ("NAT-MIB", "natStatsAddrMapGroup"), ("NAT-MIB", "natMIBNotificationGroup"), ("IF-MIB", "ifCounterDiscontinuityGroup"), ("NAT-MIB", "natStatsProtocolGroup"), ("NAT-MIB", "natStatsInterfaceGroup"), ) )
if mibBuilder.loadTexts: natMIBReadOnlyCompliance.setDescription("When this MIB is implemented without support for\nread-create (i.e., in read-only mode), then such an\nimplementation can claim read-only compliance.\nSuch a device can then be monitored but cannot be\nconfigured with this MIB.\n\nThe following index objects cannot be added as OBJECT\nclauses but nevertheless have the compliance\nrequirements:")

# Exports

# Module identity
mibBuilder.exportSymbols("NAT-MIB", PYSNMP_MODULE_ID=natMIB)

# Types
mibBuilder.exportSymbols("NAT-MIB", NatAddrMapId=NatAddrMapId, NatAssociationType=NatAssociationType, NatBindId=NatBindId, NatBindIdOrZero=NatBindIdOrZero, NatBindMode=NatBindMode, NatProtocolMap=NatProtocolMap, NatProtocolType=NatProtocolType, NatSessionId=NatSessionId, NatTranslationEntity=NatTranslationEntity)

# Objects
mibBuilder.exportSymbols("NAT-MIB", natMIB=natMIB, natMIBNotifications=natMIBNotifications, natMIBObjects=natMIBObjects, natDefTimeouts=natDefTimeouts, natBindDefIdleTimeout=natBindDefIdleTimeout, natUdpDefIdleTimeout=natUdpDefIdleTimeout, natIcmpDefIdleTimeout=natIcmpDefIdleTimeout, natOtherDefIdleTimeout=natOtherDefIdleTimeout, natTcpDefIdleTimeout=natTcpDefIdleTimeout, natTcpDefNegTimeout=natTcpDefNegTimeout, natNotifCtrl=natNotifCtrl, natNotifThrottlingInterval=natNotifThrottlingInterval, natInterfaceTable=natInterfaceTable, natInterfaceEntry=natInterfaceEntry, natInterfaceRealm=natInterfaceRealm, natInterfaceServiceType=natInterfaceServiceType, natInterfaceInTranslates=natInterfaceInTranslates, natInterfaceOutTranslates=natInterfaceOutTranslates, natInterfaceDiscards=natInterfaceDiscards, natInterfaceStorageType=natInterfaceStorageType, natInterfaceRowStatus=natInterfaceRowStatus, natAddrMapTable=natAddrMapTable, natAddrMapEntry=natAddrMapEntry, natAddrMapIndex=natAddrMapIndex, natAddrMapName=natAddrMapName, natAddrMapEntryType=natAddrMapEntryType, natAddrMapTranslationEntity=natAddrMapTranslationEntity, natAddrMapLocalAddrType=natAddrMapLocalAddrType, natAddrMapLocalAddrFrom=natAddrMapLocalAddrFrom, natAddrMapLocalAddrTo=natAddrMapLocalAddrTo, natAddrMapLocalPortFrom=natAddrMapLocalPortFrom, natAddrMapLocalPortTo=natAddrMapLocalPortTo, natAddrMapGlobalAddrType=natAddrMapGlobalAddrType, natAddrMapGlobalAddrFrom=natAddrMapGlobalAddrFrom, natAddrMapGlobalAddrTo=natAddrMapGlobalAddrTo, natAddrMapGlobalPortFrom=natAddrMapGlobalPortFrom, natAddrMapGlobalPortTo=natAddrMapGlobalPortTo, natAddrMapProtocol=natAddrMapProtocol, natAddrMapInTranslates=natAddrMapInTranslates, natAddrMapOutTranslates=natAddrMapOutTranslates, natAddrMapDiscards=natAddrMapDiscards, natAddrMapAddrUsed=natAddrMapAddrUsed, natAddrMapStorageType=natAddrMapStorageType, natAddrMapRowStatus=natAddrMapRowStatus, natAddrBindNumberOfEntries=natAddrBindNumberOfEntries, natAddrBindTable=natAddrBindTable, natAddrBindEntry=natAddrBindEntry, natAddrBindLocalAddrType=natAddrBindLocalAddrType, natAddrBindLocalAddr=natAddrBindLocalAddr, natAddrBindGlobalAddrType=natAddrBindGlobalAddrType, natAddrBindGlobalAddr=natAddrBindGlobalAddr, natAddrBindId=natAddrBindId, natAddrBindTranslationEntity=natAddrBindTranslationEntity, natAddrBindType=natAddrBindType, natAddrBindMapIndex=natAddrBindMapIndex, natAddrBindSessions=natAddrBindSessions, natAddrBindMaxIdleTime=natAddrBindMaxIdleTime, natAddrBindCurrentIdleTime=natAddrBindCurrentIdleTime, natAddrBindInTranslates=natAddrBindInTranslates, natAddrBindOutTranslates=natAddrBindOutTranslates, natAddrPortBindNumberOfEntries=natAddrPortBindNumberOfEntries, natAddrPortBindTable=natAddrPortBindTable, natAddrPortBindEntry=natAddrPortBindEntry, natAddrPortBindLocalAddrType=natAddrPortBindLocalAddrType, natAddrPortBindLocalAddr=natAddrPortBindLocalAddr, natAddrPortBindLocalPort=natAddrPortBindLocalPort, natAddrPortBindProtocol=natAddrPortBindProtocol, natAddrPortBindGlobalAddrType=natAddrPortBindGlobalAddrType, natAddrPortBindGlobalAddr=natAddrPortBindGlobalAddr, natAddrPortBindGlobalPort=natAddrPortBindGlobalPort, natAddrPortBindId=natAddrPortBindId, natAddrPortBindTranslationEntity=natAddrPortBindTranslationEntity, natAddrPortBindType=natAddrPortBindType, natAddrPortBindMapIndex=natAddrPortBindMapIndex, natAddrPortBindSessions=natAddrPortBindSessions, natAddrPortBindMaxIdleTime=natAddrPortBindMaxIdleTime, natAddrPortBindCurrentIdleTime=natAddrPortBindCurrentIdleTime, natAddrPortBindInTranslates=natAddrPortBindInTranslates, natAddrPortBindOutTranslates=natAddrPortBindOutTranslates, natSessionTable=natSessionTable, natSessionEntry=natSessionEntry, natSessionIndex=natSessionIndex, natSessionPrivateSrcEPBindId=natSessionPrivateSrcEPBindId, natSessionPrivateSrcEPBindMode=natSessionPrivateSrcEPBindMode, natSessionPrivateDstEPBindId=natSessionPrivateDstEPBindId, natSessionPrivateDstEPBindMode=natSessionPrivateDstEPBindMode, natSessionDirection=natSessionDirection, natSessionUpTime=natSessionUpTime, natSessionAddrMapIndex=natSessionAddrMapIndex, natSessionProtocolType=natSessionProtocolType, natSessionPrivateAddrType=natSessionPrivateAddrType, natSessionPrivateSrcAddr=natSessionPrivateSrcAddr, natSessionPrivateSrcPort=natSessionPrivateSrcPort, natSessionPrivateDstAddr=natSessionPrivateDstAddr, natSessionPrivateDstPort=natSessionPrivateDstPort, natSessionPublicAddrType=natSessionPublicAddrType, natSessionPublicSrcAddr=natSessionPublicSrcAddr, natSessionPublicSrcPort=natSessionPublicSrcPort, natSessionPublicDstAddr=natSessionPublicDstAddr, natSessionPublicDstPort=natSessionPublicDstPort, natSessionMaxIdleTime=natSessionMaxIdleTime, natSessionCurrentIdleTime=natSessionCurrentIdleTime, natSessionInTranslates=natSessionInTranslates, natSessionOutTranslates=natSessionOutTranslates, natProtocolTable=natProtocolTable, natProtocolEntry=natProtocolEntry, natProtocol=natProtocol, natProtocolInTranslates=natProtocolInTranslates, natProtocolOutTranslates=natProtocolOutTranslates, natProtocolDiscards=natProtocolDiscards, natMIBConformance=natMIBConformance, natMIBGroups=natMIBGroups, natMIBCompliances=natMIBCompliances)

# Notifications
mibBuilder.exportSymbols("NAT-MIB", natPacketDiscard=natPacketDiscard)

# Groups
mibBuilder.exportSymbols("NAT-MIB", natConfigGroup=natConfigGroup, natTranslationGroup=natTranslationGroup, natStatsInterfaceGroup=natStatsInterfaceGroup, natStatsProtocolGroup=natStatsProtocolGroup, natStatsAddrMapGroup=natStatsAddrMapGroup, natMIBNotificationGroup=natMIBNotificationGroup)

# Compliances
mibBuilder.exportSymbols("NAT-MIB", natMIBFullCompliance=natMIBFullCompliance, natMIBReadOnlyCompliance=natMIBReadOnlyCompliance)
