from __future__ import annotations

import datetime
import enum
import pathlib
import types
from collections.abc import Callable, Generator
from typing import Self

class Compression(enum.Enum):
    none: Self
    zstd: Self

class Hint(enum.Enum):
    COMPRESS: Self
    FRONT_ARTICLE: Self

class Blob:
    def __init__(self, content: str | bytes) -> None: ...
    def size(self) -> int: ...
    ref_content: bytes

class ContentProvider:
    def feed(self) -> Blob: ...
    def get_size(self) -> int: ...
    def gen_blob(self) -> Generator[Blob, None, None]: ...

    generator: Generator[Blob, None, None]

class StringProvider(ContentProvider):
    def __init__(self, content: str | bytes) -> None: ...

class FileProvider(ContentProvider):
    def __init__(self, filepath: pathlib.Path | str) -> None: ...

class Item:
    def get_path(self) -> str: ...
    def get_title(self) -> str: ...
    def get_mimetype(self) -> str: ...
    def get_contentprovider(self) -> ContentProvider: ...
    def get_hints(self) -> dict[Hint, int]: ...
    def __repr__(self) -> str: ...

    get_indexdata: Callable[[], IndexData | None] | None
    _blob: Blob

class IndexData:
    def has_indexdata(self) -> bool: ...
    def get_title(self) -> str: ...
    def get_content(self) -> str: ...
    def get_keywords(self) -> str: ...
    def get_wordcount(self) -> int: ...
    def get_geoposition(self) -> tuple[float, float] | None: ...

class Creator:
    def __init__(self, filename: pathlib.Path) -> None: ...
    def config_verbose(self, verbose: bool) -> Self: ...
    def config_compression(self, compression: Compression | str) -> Self: ...
    def config_clustersize(self, size: int) -> Self: ...
    def config_indexing(self, indexing: bool, language: str) -> Self: ...
    def config_nbworkers(self, nbWorkers: int) -> Self: ...  # noqa: N803
    def set_mainpath(self, mainPath: str) -> Self: ...  # noqa: N803
    def add_illustration(self, size: int, content: bytes) -> None: ...
    def add_item(self, writer_item: Item) -> None: ...
    def add_metadata(
        self,
        name: str,
        content: str | bytes | datetime.date | datetime.datetime,
        mimetype: str = "text/plain;charset=UTF-8",
    ) -> None: ...
    def add_redirection(
        self,
        path: str,
        title: str,
        targetPath: str,  # noqa: N803
        hints: dict[Hint, int],
    ) -> None: ...
    def add_alias(
        self,
        path: str,
        title: str,
        targetPath: str,  # noqa: N803
        hints: dict[Hint, int],
    ) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_val: BaseException | None,
        exc_tb: types.TracebackType | None,
    ) -> None: ...
    @property
    def filename(self) -> pathlib.Path: ...
    def __repr__(self) -> str: ...

    _filename: pathlib.Path
    _started: bool
