# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .secret_base_py3 import SecretBase


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param store: Required. The Azure Key Vault linked service reference.
    :type store: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param secret_name: Required. The name of the secret in Azure Key Vault.
     Type: string (or Expression with resultType string).
    :type secret_name: object
    :param secret_version: The version of the secret in Azure Key Vault. The
     default value is the latest version of the secret. Type: string (or
     Expression with resultType string).
    :type secret_version: object
    """

    _validation = {
        'type': {'required': True},
        'store': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(self, *, store, secret_name, secret_version=None, **kwargs) -> None:
        super(AzureKeyVaultSecretReference, self).__init__(**kwargs)
        self.store = store
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.type = 'AzureKeyVaultSecret'
