# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FieldDefinition(Model):
    """Definition of the connection fields.

    All required parameters must be populated in order to send to Azure.

    :param is_encrypted: Gets or sets the isEncrypted flag of the connection
     field definition.
    :type is_encrypted: bool
    :param is_optional: Gets or sets the isOptional flag of the connection
     field definition.
    :type is_optional: bool
    :param type: Required. Gets or sets the type of the connection field
     definition.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'is_encrypted': {'key': 'isEncrypted', 'type': 'bool'},
        'is_optional': {'key': 'isOptional', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FieldDefinition, self).__init__(**kwargs)
        self.is_encrypted = kwargs.get('is_encrypted', None)
        self.is_optional = kwargs.get('is_optional', None)
        self.type = kwargs.get('type', None)
