#!/usr/bin/python

"""Helper to save and restore power domains."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import cPickle as pickle
import socket
import os

# Search for power cap data files in these locations:
# ./pwrkap_$HOSTNAME.bin
# /etc/pwrkap_$HOSTNAME.bin
# /etc/pwrkap.bin
def find_data_file_name():
	"""Construct the name of the saved data file."""
	hostname = socket.gethostname()
	files = []

	files.append("./pwrkap_%s.bin" % hostname)
	files.append("/etc/pwrkap_%s.bin" % hostname)
	files.append("/etc/pwrkap.bin")

	for file in files:
		if os.path.exists(file):
			return file

def default_data_file_name():
	"""Default location for saved data."""
	hostname = socket.gethostname()
	files = []

	files.append("/etc/pwrkap_%s.bin" % hostname)
	files.append("./pwrkap_%s.bin" % hostname)
	for file in files:
		try:
			fp = open(file, "wb")
			fp.close()
			return file
		except:
			continue
	return None

def save_domains(domains):
	"""Save domain data to a file."""
	file = open(default_data_file_name(), "wb")
	pickle.dump(domains, file, pickle.HIGHEST_PROTOCOL)
	file.close()

def load_domains(domains):
	"""Load domain data from a file and return it if the inventory of
the restored domains match the inventory of the given domains."""
	inventories = []

	fname = find_data_file_name()
	if fname == None:
		return None

	file = open(fname, "rb")
	try:
		loaded = pickle.load(file)
	except:
		file.close()
		return None
	file.close()

	for pd in loaded:
		inventories.append(pd.inventory())

	for pd in domains:
		inventory = pd.inventory()
		if inventory not in inventories:
			print "Configuration change, discarding old data."
			return None
		inventories.remove(pd.inventory())

	if len(inventories) > 0:
		print "err2"
		return None

	return loaded
