macro(set_libint_compiler_flags)
  set(CMAKE_CXX_FLAGS         " ")
  set(CMAKE_CXX_FLAGS_DEBUG   " ")
  set(CMAKE_CXX_FLAGS_RELEASE " ")
  set(CMAKE_CXX_FLAGS_PROFILE " ")

  if(CMAKE_CXX_COMPILER_ID MATCHES GNU)
     set(CMAKE_CXX_FLAGS "-DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG   "-O0 -g3 -DDEBUG")
     set(CMAKE_CXX_FLAGS_RELEASE "-O3 -DNDEBUG -Wno-unused")
     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE} -g -pg")

     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()
     if(ENABLE_CODE_COVERAGE)
        set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fprofile-arcs -ftest-coverage")
        set (CMAKE_CXX_LINK_FLAGS "-fprofile-arcs -ftest-coverage")
     endif()
  elseif(CMAKE_CXX_COMPILER_ID MATCHES Intel)
     set(CMAKE_CXX_FLAGS "-restrict -DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG   "-O0 -debug -DDEBUG")
     # Check if xHost flag is available and add it CMAKE_CXX_FLAGS_RELEASE
     set(xHost "")
     if(ENABLE_XHOST)
        check_cxx_compiler_flag("-xHost" has_xHost)
        if(has_xHost)
           set(xHost "-xHost")
        endif()
     endif()
     set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -O3 -DNDEBUG ${xHost}")
     if(ENABLE_STATIC_LINKING)
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -static-libstdc++ -static-libgcc -static-intel -wd10237")
     else()
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -shared-intel")
     endif()
      if(DEFINED MKL_FLAG)
         set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${MKL_FLAG}")
      endif()
     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()

     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE} -g -pg")
     if(ENABLE_STATIC_LINKING)
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -static-libstdc++ -static-libgcc -static-intel -wd10237")
     else()
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -shared-intel")
     endif()
  elseif(CMAKE_CXX_COMPILER_ID MATCHES Clang)
     set(CMAKE_CXX_FLAGS "-DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG    "-O0 -g -DDEBUG")
     set(CMAKE_CXX_FLAGS_RELEASE  "-O3 -DNDEBUG -Wno-unused")

     # clang does not use gprof
     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE}")

     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()
     if(ENABLE_CODE_COVERAGE)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fprofile-arcs -ftest-coverage")
        set(CMAKE_CXX_LINK_FLAGS "-fprofile-arcs -ftest-coverage")
     endif()
  endif()

endmacro(set_libint_compiler_flags)

macro(set_libderiv_compiler_flags)
  set(CMAKE_CXX_FLAGS         " ")
  set(CMAKE_CXX_FLAGS_DEBUG   " ")
  set(CMAKE_CXX_FLAGS_RELEASE " ")
  set(CMAKE_CXX_FLAGS_PROFILE " ")

  if(CMAKE_CXX_COMPILER_ID MATCHES GNU)
     set(CMAKE_CXX_FLAGS "-DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG   "-O0 -g3 -DDEBUG")
     set(CMAKE_CXX_FLAGS_RELEASE "-O3 -DNDEBUG -Wno-unused")
     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE} -g -pg")

     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()
     if(ENABLE_CODE_COVERAGE)
        set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fprofile-arcs -ftest-coverage")
        set (CMAKE_CXX_LINK_FLAGS "-fprofile-arcs -ftest-coverage")
     endif()
  elseif(CMAKE_CXX_COMPILER_ID MATCHES Intel)
     set(CMAKE_CXX_FLAGS "-restrict -DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG   "-O0 -debug -DDEBUG")
     # Check if xHost flag is available and add it CMAKE_CXX_FLAGS_RELEASE
     set(xHost "")
     if(ENABLE_XHOST)
        check_cxx_compiler_flag("-xHost" has_xHost)
        if(has_xHost)
           set(xHost "-xHost")
        endif()
     endif()
     set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -O3 -DNDEBUG ${xHost}")
     if(ENABLE_STATIC_LINKING)
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -static-libstdc++ -static-libgcc -static-intel -wd10237")
     else()
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -shared-intel")
     endif()
      if(DEFINED MKL_FLAG)
         set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${MKL_FLAG}")
      endif()
     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()

     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE} -g -pg")
     if(ENABLE_STATIC_LINKING)
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -static-libstdc++ -static-libgcc -static-intel -wd10237")
     else()
        set(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -shared-intel")
     endif()
  elseif(CMAKE_CXX_COMPILER_ID MATCHES Clang)
     set(CMAKE_CXX_FLAGS "-DRESTRICT=${restrict}")
     if(HAS_CXX11_SUPPORT)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC ${CXX11_COMPILER_FLAGS}")
     else()
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC -std=gnu++98")
     endif()
     set(CMAKE_CXX_FLAGS_DEBUG    "-O0 -g -DDEBUG")
     set(CMAKE_CXX_FLAGS_RELEASE  "-O3 -DNDEBUG -Wno-unused")

     # clang does not use gprof
     set(CMAKE_CXX_FLAGS_PROFILE "${CMAKE_CXX_FLAGS_RELEASE}")

     if(ENABLE_VECTORIZATION)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CXX_ARCHITECTURE_FLAGS} ${DEFINITIONS}")
     endif()
     if(ENABLE_CODE_COVERAGE)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fprofile-arcs -ftest-coverage")
        set(CMAKE_CXX_LINK_FLAGS "-fprofile-arcs -ftest-coverage")
     endif()
  endif()

endmacro(set_libderiv_compiler_flags)
