/* $Cambridge: hermes/src/prayer/lib/raven_wls_response.h,v 1.2 2008/09/16 09:59:57 dpc22 Exp $ */

/* Support for Ucam Web single sign on environment "Raven". Of no interest
 * to anyone else.
 *
 * Raven WLS response tokens are thirteen fields glued together using !.
 * First eleven parameters are RSA signed by last two
 */

/* Names below match mod_ucam_webauth. Some of the fields will be
   small integers and can be verified as such */

struct raven_wls_response {
    /* Raw components */
    char *ver;           /* 1 or 2 allowed, currently 2 */
    char *status;        /* http_response: 200 if correct */
    char *msg;           /* Error message to display if problem */
    char *issue;         /* Timestamp of form: 20080804T134807Z */
    char *id;            /* issue+id guaranteed unique */
    char *url;           /* Target URL */
    char *principal;     /* Username */
    char *auth;          /* Means of authentication */
    char *sso;           /* If using previous authentication */
    char *life;          /* Lifespan of this session, in seconds */
    char *params;        /* Parameters from request */
    char *kid;           /* Key identifier: small integer */
    char *sig;           /* RSA signature, based on key */

    /* Allocated memory to free at the end */
    char *data;          /* Data block shared by all the above */
    char *lhs;           /* First half of WLS response signed by kid, sig */
};

char *
raven_wls_response_status_message(struct raven_wls_response *wls);

struct raven_wls_response *
raven_wls_response_parse(char *s, char *sig_path, char **error);

void
raven_wls_response_free(struct raven_wls_response *wls);

time_t
raven_wls_response_timestamp(struct raven_wls_response *wls);

int
raven_wls_response_check_timestamp(struct raven_wls_response *wls,
                                   int maxskew, int timeout);

char *
raven_wls_response_now();

#define RAVEN_WLS_TICKET_MAXSKEW    (5)         /*  5 secs */
#define RAVEN_WLS_TICKET_TIMEOUT    (20)        /* 20 secs */
#define RAVEN_WLS_TICKET_LIFETIME   (12*60*60)  /* 12 hours */
