# Announcement: Release of PlotPy V2 📊

PlotPy V2 distinguishes itself in the realm of plotting libraries. Designed for Python/Qt applications, this library offers a blend of superior performance and enhanced interactive features. Its image display features, driven by a C++ transform engine, include real-time high-quality interpolation, LUT, and geometric transformations, elevating data interaction.

PlotPy is part of the PlotPyStack project (<https://github.com/PlotPyStack>), dedicated to delivering a comprehensive toolkit for crafting scientific and technical data visualization applications.

The development efforts for PlotPy V2 were financed by the CEA (<https://www.cea.fr/>).

What's New in PlotPy V2 🌟:

🔍 Major Updates:

Refined and unified API for curve and image plotting features (widget, dialog, window). Introduction of a new window for synchronized multi-plot displays 🔄.

🎨 Enhancements:

Expanded Image Lookup Table functionalities.
Integration of SVG-based shapes.

📖 Documentation:
Comprehensive Sphinx-based documentation enriched with API links, examples, and tutorials.

⚙️ Development Features:
Black code formatting, robust `pytest`-based automated test suite, and a 70% test coverage milestone ✅.

We invite the community to explore PlotPy V2's capabilities.

Explore PlotPy V2 on PyPI: <https://pypi.org/project/PlotPy/>.
View the project on GitHub: <https://github.com/PlotPyStack/plotpy/>.
Review the documentation: <https://plotpy.readthedocs.io/en/latest/>.
