#ifndef _PIDGIN_TWITTER_TWITTER_API_H_
#define _PIDGIN_TWITTER_TWITTER_API_H_

#include <cipher.h> /* from libpurple */
#include <request.h>
#include <math.h>

/* twitter API specific macros */
#define TWITTER_BASE_URL  "http://twitter.com"
#define TWITTER_API_BASE_URL "http://api.twitter.com"
#define REQUEST_TOKEN_URL "http://twitter.com/oauth/request_token"
#define ACCESS_TOKEN_URL  "http://twitter.com/oauth/access_token"
#define AUTHORIZE_URL     "http://twitter.com/oauth/authorize"

#define TWITTER_STATUS_GET "GET /1/statuses/home_timeline.xml?%s HTTP/1.1\r\n" \
    "Host: api.twitter.com\r\n"                                          \
    "User-Agent: pidgin-twitter\r\n"

#define TWITTER_STATUS_POST "POST /1/statuses/update.xml HTTP/1.1\r\n" \
    "Host: api.twitter.com\r\n"                                          \
    "User-Agent: pidgin-twitter\r\n"                                 \
    "Content-Length: %d\r\n"

#define TWITTER_FAV_POST "POST /1/favorites/create/%llu.xml HTTP/1.1\r\n" \
    "Host: api.twitter.com\r\n"                                          \
    "User-Agent: pidgin-twitter\r\n" \
    "Content-Length: %d\r\n"

#define TWITTER_RETWEET_POST "POST /1/statuses/retweet/%llu.xml HTTP/1.1\r\n" \
    "Host: api.twitter.com\r\n"                                          \
    "User-Agent: pidgin-twitter\r\n" \
    "Content-Length: %d\r\n"

#define TWITTER_STATUS_FORMAT "&source=pidgintwitter&status=%s"

#define TWITTER_DEFAULT_INTERVAL (60)
#define TWITTER_OLD_DEFAULT_ICON_URL "http://static.twitter.com/images/default_profile_bigger.png"
#define TWITTER_DEFAULT_ICON_URL "http://s.twimg.com/images/default_profile_3_bigger.png"

#define TWITTER_DEFAULT_RETRIEVE_COUNT (20)


/* prototypes */
void post_status_with_api(PurpleAccount *account, char **buffer);
gboolean get_status_with_api(gpointer data);
void fav_with_api(guint64 id);
void retweet_with_api(guint64 id);
void signed_on_cb(PurpleConnection *gc);

#endif
