DROP DATABASE IF EXISTS upper_oob;
CREATE DATABASE upper_oob;
USE upper_oob;

CREATE TABLE t (
  id int not null auto_increment primary key,
  c  varchar(64)
) engine=innodb;

insert into t values
(1, 'Afghanistan'),
(2, 'Algeria'),
(3, 'American Samoa'),
(4, 'Angola'),
(5, 'Anguilla'),
(6, 'Argentina'),
(7, 'Armenia'),
(8, 'Australia'),
(9, 'Austria'),
(10, 'Azerbaijan'),
(11, 'Bahrain'),
(12, 'Bangladesh'),
(13, 'Belarus'),
(14, 'Bolivia'),
(15, 'Brazil'),
(16, 'Brunei'),
(17, 'Bulgaria'),
(18, 'Cambodia'),
(19, 'Cameroon'),
(20, 'Canada'),
(21, 'Chad'),
(22, 'Chile'),
(23, 'China'),
(24, 'Colombia'),
(25, 'Congo, The Democratic Republic of the'),
(26, 'Czech Republic'),
(27, 'Dominican Republic'),
(28, 'Ecuador'),
(29, 'Egypt'),
(30, 'Estonia'),
(31, 'Ethiopia'),
(32, 'Faroe Islands'),
(33, 'Finland'),
(34, 'France'),
(35, 'French Guiana'),
(36, 'French Polynesia'),
(37, 'Gambia'),
(38, 'Germany'),
(39, 'Greece'),
(40, 'Greenland'),
(41, 'Holy See (Vatican City State)'),
(42, 'Hong Kong'),
(43, 'Hungary'),
(44, 'India'),
(45, 'Indonesia'),
(46, 'Iran'),
(47, 'Iraq'),
(48, 'Israel'),
(49, 'Italy'),
(50, 'Japan'),
(51, 'Kazakstan'),
(52, 'Kenya'),
(53, 'Kuwait'),
(54, 'Latvia'),
(55, 'Liechtenstein'),
(56, 'Lithuania'),
(57, 'Madagascar'),
(58, 'Malawi'),
(59, 'Malaysia'),
(60, 'Mexico'),
(61, 'Moldova'),
(62, 'Morocco'),
(63, 'Mozambique'),
(64, 'Myanmar'),
(65, 'Nauru'),
(66, 'Nepal'),
(67, 'Netherlands'),
(68, 'New Zealand'),
(69, 'Nigeria'),
(70, 'North Korea'),
(71, 'Oman'),
(72, 'Pakistan'),
(73, 'Paraguay'),
(74, 'Peru'),
(75, 'Philippines'),
(76, 'Poland'),
(77, 'Puerto Rico'),
(78, 'Romania'),
(79, 'Runion'),
(80, 'Russian Federation'),
(81, 'Saint Vincent and the Grenadines'),
(82, 'Saudi Arabia'),
(83, 'Senegal'),
(84, 'Slovakia'),
(85, 'South Africa'),
(86, 'South Korea'),
(87, 'Spain'),
(88, 'Sri Lanka'),
(89, 'Sudan'),
(90, 'Sweden'),
(91, 'Switzerland'),
(92, 'Taiwan'),
(93, 'Tanzania'),
(94, 'Thailand'),
(95, 'Tonga'),
(96, 'Tunisia'),
(97, 'Turkey'),
(98, 'Turkmenistan'),
(99, 'Tuvalu'),
(100, 'Ukraine'),
(101, 'United Arab Emirates'),
(102, 'United Kingdom'),
(103, 'United States'),
(104, 'Venezuela'),
(105, 'Vietnam'),
(106, 'Virgin Islands, U.S.'),
(107, 'Yemen'),
(108, 'Yugoslavia'),
(109, 'Zambia');

CREATE DATABASE IF NOT EXISTS percona;
USE percona;
DROP TABLE IF EXISTS checksums;
CREATE TABLE `checksums` (
  `db` char(64) NOT NULL,
  `tbl` char(64) NOT NULL,
  `chunk` int(11) NOT NULL,
  `chunk_time` float DEFAULT NULL,
  `chunk_index` varchar(200) DEFAULT NULL,
  `lower_boundary` text,
  `upper_boundary` text,
  `this_crc` char(40) NOT NULL,
  `this_cnt` int(11) NOT NULL,
  `master_crc` char(40) DEFAULT NULL,
  `master_cnt` int(11) DEFAULT NULL,
  `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`db`,`tbl`,`chunk`),
  KEY `ts_db_tbl` (`ts`,`db`,`tbl`)
) ENGINE=InnoDB;

SET SQL_LOG_BIN=0;
DELETE FROM upper_oob.t where id > 99;
INSERT INTO percona.checksums VALUES
  ('upper_oob','t',1,0.001144,'PRIMARY','1','50','398f3270',50,'398f3270',50,'2013-01-23 17:36:56'),
  ('upper_oob','t',2,0.000878,'PRIMARY','51','99','bd9a892d',49,'bd9a892d',49,'2013-01-23 17:36:56'),
  ('upper_oob','t',3,0.000763,'PRIMARY',NULL,'1','0',0,'0',0,'2013-01-23 17:36:56'),
  ('upper_oob','t',4,0.000877,'PRIMARY','99',NULL,'0',0,'0',0,'2013-01-23 17:36:56');
SET SQL_LOG_BIN=1;
