This code fuzzes ed25519-donna (and optionally ed25519-donna-sse2) against the ref10 implementations of
[curve25519](https://github.com/floodyberry/supercop/tree/master/crypto_scalarmult/curve25519/ref10) and 
[ed25519](https://github.com/floodyberry/supercop/tree/master/crypto_sign/ed25519/ref10).

Curve25519 tests that generating a public key from a secret key

# Building

## *nix + PHP

`php build-nix.php (required parameters) (optional parameters)`

Required parameters:

* `--function=[curve25519,ed25519]`
* `--bits=[32,64]`

Optional parameters:

* `--with-sse2`

    Also fuzz against ed25519-donna-sse2
* `--with-openssl`

    Build with OpenSSL's SHA-512.

    Default: Reference SHA-512 implementation (slow!)

* `--compiler=[gcc,clang,icc]`

    Default: gcc

* `--no-asm`

    Do not use platform specific assembler


example:
    
    php build-nix.php --bits=64 --function=ed25519 --with-sse2 --compiler=icc 

## Windows

Create a project with access to the ed25519 files.

If you are not using OpenSSL, add the `ED25519_REFHASH` define to the projects 
"Properties/Preprocessor/Preprocessor Definitions" option

Add the following files to the project:

* `fuzz/curve25519-ref10.c`
* `fuzz/ed25519-ref10.c`
* `fuzz/ed25519-donna.c`
* `fuzz/ed25519-donna-sse2.c` (optional)
* `fuzz-[curve25519/ed25519].c` (depending on which you want to fuzz)

If you are also fuzzing against ed25519-donna-sse2, add the `ED25519_SSE2` define for `fuzz-[curve25519/ed25519].c` under 
its "Properties/Preprocessor/Preprocessor Definitions" option.

# Running

If everything agrees, the program will only output occasional status dots (every 0x1000 passes) 
and a 64bit progress count (every 0x20000 passes):

    fuzzing:  ref10 curved25519 curved25519-sse2
    
    ................................ [0000000000020000]
    ................................ [0000000000040000]
    ................................ [0000000000060000]
    ................................ [0000000000080000]
    ................................ [00000000000a0000]
    ................................ [00000000000c0000]
 
If any of the implementations do not agree with the ref10 implementation, the program will dump
the random data that was used, the data generated by the ref10 implementation, and diffs of the 
ed25519-donna data against the ref10 data.

## Example errors

These are example error dumps (with intentionally introduced errors).

### Ed25519

Random data:

* sk, or Secret Key
* m, or Message

Generated data:

* pk, or Public Key
* sig, or Signature
* valid, or if the signature of the message is valid with the public key

Dump:

    sk:
    0x3b,0xb7,0x17,0x7a,0x66,0xdc,0xb7,0x9a,0x90,0x25,0x07,0x99,0x96,0xf3,0x92,0xef,
    0x78,0xf8,0xad,0x6c,0x35,0x87,0x81,0x67,0x03,0xe6,0x95,0xba,0x06,0x18,0x7c,0x9c,
    
    m:
    0x7c,0x8d,0x3d,0xe1,0x92,0xee,0x7a,0xb8,0x4d,0xc9,0xfb,0x02,0x34,0x1e,0x5a,0x91,
    0xee,0x01,0xa6,0xb8,0xab,0x37,0x3f,0x3d,0x6d,0xa2,0x47,0xe3,0x27,0x93,0x7c,0xb7,
    0x77,0x07,0xb6,0x88,0x41,0x22,0xf3,0x3f,0xce,0xcb,0x6b,0x3e,0x2b,0x23,0x68,0x7f,
    0x5b,0xb9,0xda,0x04,0xbb,0xae,0x42,0x50,0xf5,0xe9,0xc5,0x11,0xbd,0x52,0x76,0x98,
    0xf1,0x87,0x09,0xb9,0x89,0x0a,0x52,0x69,0x01,0xce,0xe0,0x4a,0xa6,0x46,0x5a,0xe1,
    0x63,0x14,0xe0,0x81,0x52,0xec,0xcd,0xcf,0x70,0x54,0x7d,0xa3,0x49,0x8b,0xf0,0x89,
    0x70,0x07,0x12,0x2a,0xd9,0xaa,0x16,0x01,0xb2,0x16,0x3a,0xbb,0xfc,0xfa,0x13,0x5b,
    0x69,0x83,0x92,0x70,0x95,0x76,0xa0,0x8e,0x16,0x79,0xcc,0xaa,0xb5,0x7c,0xf8,0x7a,
    
    ref10:
    pk:
    0x71,0xb0,0x5e,0x62,0x1b,0xe3,0xe7,0x36,0x91,0x8b,0xc0,0x13,0x36,0x0c,0xc9,0x04,
    0x16,0xf5,0xff,0x48,0x0c,0x83,0x6b,0x88,0x53,0xa2,0xc6,0x0f,0xf7,0xac,0x42,0x04,
    
    sig:
    0x3e,0x05,0xc5,0x37,0x16,0x0b,0x29,0x30,0x89,0xa3,0xe7,0x83,0x08,0x16,0xdd,0x96,
    0x02,0xfa,0x0d,0x44,0x2c,0x43,0xaa,0x80,0x93,0x04,0x58,0x22,0x09,0xbf,0x11,0xa5,
    0xcc,0xa5,0x3c,0x9f,0xa0,0xa4,0x64,0x5a,0x4a,0xdb,0x20,0xfb,0xc7,0x9b,0xfd,0x3f,
    0x08,0xae,0xc4,0x3c,0x1e,0xd8,0xb6,0xb4,0xd2,0x6d,0x80,0x92,0xcb,0x71,0xf3,0x02,
    
    valid: yes
    
    ed25519-donna:
    pk diff:
    ____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,
    ____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,
    
    sig diff:
    0x2c,0xb9,0x25,0x14,0xd0,0x94,0xeb,0xfe,0x46,0x02,0xc2,0xe8,0xa3,0xeb,0xbf,0xb5,
    0x72,0x84,0xbf,0xc1,0x8a,0x32,0x30,0x99,0xf7,0x58,0xfe,0x06,0xa8,0xdc,0xdc,0xab,
    0xb5,0x57,0x03,0x33,0x87,0xce,0x54,0x55,0x6a,0x69,0x8a,0xc4,0xb7,0x2a,0xed,0x97,
    0xb4,0x68,0xe7,0x52,0x7a,0x07,0x55,0x3b,0xa2,0x94,0xd6,0x5e,0xa1,0x61,0x80,0x08,
    
    valid: no

In this case, the generated public key matches, but the generated signature is completely 
different and does not validate.

### Curve25519

Random data:

* sk, or Secret Key

Generated data:

* pk, or Public Key

Dump:

    sk:
    0x44,0xec,0x0b,0x0e,0xa2,0x0e,0x9c,0x5b,0x8c,0xce,0x7b,0x1d,0x68,0xae,0x0f,0x9e,
    0x81,0xe2,0x04,0x76,0xda,0x87,0xa4,0x9e,0xc9,0x4f,0x3b,0xf9,0xc3,0x89,0x63,0x70,
    
    
    ref10:
    0x24,0x55,0x55,0xc0,0xf9,0x80,0xaf,0x02,0x43,0xee,0x8c,0x7f,0xc1,0xad,0x90,0x95,
    0x57,0x91,0x14,0x2e,0xf2,0x14,0x22,0x80,0xdd,0x4e,0x3c,0x85,0x71,0x84,0x8c,0x62,
    
    
    curved25519 diff:
    0x12,0xd1,0x61,0x2b,0x16,0xb3,0xd8,0x29,0xf8,0xa3,0xba,0x70,0x4e,0x49,0x4f,0x43,
    0xa1,0x3c,0x6b,0x42,0x11,0x61,0xcc,0x30,0x87,0x73,0x46,0xfb,0x85,0xc7,0x9a,0x35,
    
    
    curved25519-sse2 diff:
    ____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,
    ____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,____,


In this case, curved25519 is totally wrong, while curved25519-sse2 matches the reference 
implementation.