/* This file is part of the Palabos library.
 *
 * Copyright (C) 2011-2015 FlowKit Sarl
 * Route d'Oron 2
 * 1010 Lausanne, Switzerland
 * E-mail contact: contact@flowkit.com
 *
 * The most recent release of Palabos can be downloaded at 
 * <http://www.palabos.org/>
 *
 * The library Palabos is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "atomicBlock/atomicContainerBlock3D.h"

namespace plb {

AtomicContainerBlock3D::AtomicContainerBlock3D(plint nx_, plint ny_, plint nz_)
    : AtomicBlock3D(nx_,ny_,nz_),
      data(0)
{ }

AtomicContainerBlock3D::~AtomicContainerBlock3D() {
    delete data;
}

AtomicContainerBlock3D& AtomicContainerBlock3D::operator=(AtomicContainerBlock3D const& rhs) {
    AtomicContainerBlock3D tmp(rhs);
    swap(tmp);
    return *this;
}

AtomicContainerBlock3D::AtomicContainerBlock3D(AtomicContainerBlock3D const& rhs)
    : AtomicBlock3D(rhs),
      data(rhs.data ? rhs.data->clone() : 0)
{ }

void AtomicContainerBlock3D::swap(AtomicContainerBlock3D& rhs) {
    std::swap(data, rhs.data);
    AtomicBlock3D::swap(rhs);
}

void AtomicContainerBlock3D::setData(ContainerBlockData* data_) {
    delete data;
    data = data_;
}

ContainerBlockData* AtomicContainerBlock3D::getData() {
    return data;
}

ContainerBlockData const* AtomicContainerBlock3D::getData() const {
    return data;
}

identifiers::BlockId AtomicContainerBlock3D::getBlockId() const {
    return identifiers::getContainerId();
}

}  // namespace plb
