//=======================================================================
// packagetab.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_PACKAGE_TAB_H
#define GPACO_PACKAGE_TAB_H

#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/comboboxtext.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/filechooserbutton.h>
#include "util.h"

namespace Gpaco
{

class Pkg;

class PackageTab : public Gtk::VBox
{
	public:

	PackageTab(Pkg&);
	~PackageTab();

	typedef struct {
		std::string	folder;
		int			prog;
		int			level;
		bool		test;
	} Last;
		
	private:

	enum { GZIP, BZIP2 };

	static Last sLast;

	Pkg&					mPkg;
	Gtk::Label				mLabel;
	Gtk::Label				mLabelTarball;
	Gtk::ComboBoxText		mComboProg;
	Gtk::ComboBoxText		mComboLevel;
	Gtk::FileChooserButton	mFileChooserButton;
	Button					mButtonCreate;
	Button					mButtonClose;
	Button					mButtonStop;
	Gtk::CheckButton		mButtonTest;
	bool					mStop;
	Gtk::ProgressBar		mProgressBar;

	void onChangeProg();
	void onCreate();
	void onStop();
	void setSensitive(bool set = true);
	bool spawnAsync(std::vector<std::string>&);

};

} // namespace Gpaco


#endif  // GPACO_PACKAGE_TAB_H
