# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012-2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

from ubuntuuitoolkit import emulators as uitk


class NotesApp(uitk.MainView):

    """An emulator class that makes it easy to interact with the notes app."""

    def get_notes(self):
        notes = self.select_many("NoteItem")
        notes.sort(key=lambda note: note.y)
        return notes

    def get_header(self):
        return self.select_single("Header")

    def get_note_content(self, note_item):
        return note_item.select_single("MixedEdit")

    def get_note_parts(self, note_item):
        edit = self.get_note_content(note_item)
        parts = edit.select_single(
            "QQuickColumn").get_children_by_type("QQuickLoader")
        parts.sort(key=lambda part: part.y)
        return parts

    def get_note_listitem(self, note_item):
        return note_item.select_single(uitk.Empty)

    def get_keyboard_rectangle(self):
        return self.select_single("KeyboardRectangle")
