/**
 * @author Toru Nagashima
 * See LICENSE file in root directory for full license.
 */
"use strict"

const { merge } = require("../utils")
const tsConfig = require("./_ts")
const vueConfig = require("./_vue")
const mochaConfig = require("./_mocha")
const specialConfig = require("./_special")

module.exports = merge(
    {
        root: true,
        plugins: ["@mysticatea"],
        parserOptions: {
            ecmaVersion: 5,
            sourceType: "script",
        },
        globals: {
            Intl: false,
            clearInterval: false,
            clearTimeout: false,
            console: false,
            setInterval: false,
            setTimeout: false,
        },
        rules: {
            // Enabled rules
            "accessor-pairs": "error",
            "array-callback-return": "error",
            camelcase: "error",
            "consistent-return": "error",
            curly: "error",
            "default-case": "error",
            "dot-notation": "error",
            eqeqeq: ["error", "always", { null: "ignore" }],
            "for-direction": "error",
            "func-style": ["error", "declaration"],
            "getter-return": "error",
            "init-declarations": "error",
            "linebreak-style": ["error", "unix"],
            "lines-between-class-members": "error",
            "max-statements-per-line": ["error", { max: 1 }],
            "multiline-comment-style": ["error", "separate-lines"],
            "new-cap": "error",
            "no-alert": "error",
            "no-array-constructor": "error",
            "no-async-promise-executor": "error",
            "no-caller": "error",
            "no-case-declarations": "error",
            "no-compare-neg-zero": "error",
            "no-cond-assign": "error",
            "no-constant-condition": "error",
            "no-control-regex": "error",
            "no-debugger": "error",
            "no-delete-var": "error",
            "no-div-regex": "error",
            "no-dupe-args": "error",
            "no-dupe-keys": "error",
            "no-duplicate-case": "error",
            "no-else-return": "error",
            "no-empty": "error",
            "no-empty-character-class": "error",
            "no-empty-function": "error",
            "no-empty-pattern": "error",
            "no-eval": "error",
            "no-ex-assign": "error",
            "no-extend-native": "error",
            "no-extra-bind": "error",
            "no-extra-boolean-cast": "error",
            "no-extra-label": "error",
            "no-fallthrough": "error",
            "no-func-assign": "error",
            "no-global-assign": "error",
            "no-implicit-coercion": "error",
            "no-implicit-globals": "error",
            "no-implied-eval": "error",
            "no-inner-declarations": ["error", "functions"],
            "no-invalid-regexp": "error",
            "no-invalid-this": "error",
            "no-irregular-whitespace": [
                "error",
                {
                    skipComments: false,
                    skipRegExps: false,
                    skipStrings: false,
                    skipTemplates: false,
                },
            ],
            "no-iterator": "error",
            "no-label-var": "error",
            "no-lone-blocks": "error",
            "no-lonely-if": "error",
            "no-loop-func": "error",
            "no-misleading-character-class": "error",
            "no-mixed-operators": [
                "error",
                {
                    groups: [
                        ["&", "|", "^", "~", "<<", ">>", ">>>"],
                        ["&&", "||"],
                    ],
                },
            ],
            "no-new": "error",
            "no-new-object": "error",
            "no-new-require": "error",
            "no-new-wrappers": "error",
            "no-obj-calls": "error",
            "no-octal": "error",
            "no-octal-escape": "error",
            "no-param-reassign": ["error", { props: false }],
            "no-process-env": "error",
            "no-process-exit": "error",
            "no-prototype-builtins": "error",
            "no-regex-spaces": "error",
            "no-restricted-properties": [
                "error",
                { property: "__count__" },
                { property: "__noSuchMethod__" },
                { property: "__parent__" },
                { property: "__defineGetter__" },
                { property: "__defineSetter__" },
                { property: "__lookupGetter__" },
                { property: "__lookupSetter__" },
            ],
            "no-return-assign": "error",
            "no-return-await": "error",
            "no-script-url": "error",
            "no-self-assign": ["error", { props: true }],
            "no-self-compare": "error",
            "no-sequences": "error",
            "no-shadow": ["error", { builtinGlobals: true }],
            "no-shadow-restricted-names": "error",
            "no-sparse-arrays": "error",
            "no-tabs": "error",
            "no-throw-literal": "error",
            "no-undef": ["error", { typeof: true }],
            "no-unexpected-multiline": "error",
            "no-unmodified-loop-condition": "error",
            "no-unneeded-ternary": "error",
            "no-unreachable": "error",
            "no-unsafe-finally": "error",
            "no-unsafe-negation": "error",
            "no-unused-expressions": "error",
            "no-unused-labels": "error",
            "no-unused-vars": [
                "error",
                {
                    args: "all",
                    argsIgnorePattern: "^_(?:[^_].*)?$",
                    caughtErrors: "all",
                    vars: "all",
                    varsIgnorePattern: "^_(?:[^_].*)?$",
                },
            ],
            "no-use-before-define": ["error", "nofunc"],
            "no-useless-call": "error",
            "no-useless-catch": "error",
            "no-useless-concat": "error",
            "no-useless-escape": "error",
            "no-useless-return": "error",
            "no-void": "error",
            "no-with": "error",
            "one-var": [
                "error",
                {
                    initialized: "never",
                    uninitialized: "always",
                },
            ],
            "padding-line-between-statements": [
                "error",
                { blankLine: "always", next: "*", prev: "directive" },
                { blankLine: "always", next: "function", prev: "*" },
                { blankLine: "always", next: "*", prev: "function" },
            ],
            "prefer-promise-reject-errors": "error",
            quotes: ["error", "double", { avoidEscape: true }],
            radix: "error",
            "require-atomic-updates": "error",
            "require-await": "error",
            "spaced-comment": [
                "error",
                "always",
                {
                    block: {
                        balanced: true,
                        markers: [
                            "eslint",
                            "eslint-env",
                            "eslint-disable",
                            "eslint-enable",
                            "exported",
                            "globals",
                            "istanbul",
                        ],
                    },
                    line: {
                        exceptions: ["-", "="],
                        markers: [
                            "eslint-disable-line",
                            "eslint-disable-next-line",
                            "istanbul",
                            "TODO:",
                            "FIXME:",
                        ],
                    },
                },
            ],
            strict: ["error", "global"],
            "use-isnan": "error",
            "valid-typeof": ["error", { requireStringLiterals: true }],
            yoda: ["error", "never", { exceptRange: true }],

            // Enabled rules as warnings.
            complexity: ["warn", { max: 16 }],
            "max-nested-callbacks": ["warn", { max: 4 }],
            "max-params": ["warn", { max: 8 }],
            "no-console": ["warn", { allow: ["assert", "error"] }],

            // Disabled rules as favor of Prettier.
            "array-bracket-newline": "off",
            "array-bracket-spacing": "off",
            "array-element-newline": "off",
            "arrow-parens": "off",
            "arrow-spacing": "off",
            "block-spacing": "off",
            "brace-style": "off",
            "comma-dangle": "off",
            "comma-spacing": "off",
            "comma-style": "off",
            "computed-property-spacing": "off",
            "dot-location": "off",
            "eol-last": "off",
            "func-call-spacing": "off",
            "function-paren-newline": "off",
            "generator-star-spacing": "off",
            "implicit-arrow-linebreak": "off",
            indent: "off",
            "jsx-quotes": "off",
            "key-spacing": "off",
            "keyword-spacing": "off",
            "multiline-ternary": "off",
            "new-parens": "off",
            "newline-per-chained-call": "off",
            "no-extra-parens": "off",
            "no-extra-semi": "off",
            "no-floating-decimal": "off",
            "no-mixed-spaces-and-tabs": "off",
            "no-multi-spaces": "off",
            "no-multiple-empty-lines": "off",
            "no-trailing-spaces": "off",
            "no-whitespace-before-property": "off",
            "nonblock-statement-body-position": "off",
            "object-curly-newline": "off",
            "object-curly-spacing": "off",
            "object-property-newline": "off",
            "one-var-declaration-per-line": "off",
            "operator-linebreak": "off",
            "padded-blocks": "off",
            "quote-props": "off",
            "rest-spread-spacing": "off",
            semi: "off",
            "semi-spacing": "off",
            "semi-style": "off",
            "space-before-blocks": "off",
            "space-before-function-paren": "off",
            "space-in-parens": "off",
            "space-infix-ops": "off",
            "space-unary-ops": "off",
            "switch-colon-spacing": "off",
            "template-curly-spacing": "off",
            "template-tag-spacing": "off",
            "unicode-bom": "off",
            "wrap-iife": "off",
            "wrap-regex": "off",
            "yield-star-spacing": "off",

            // Disabled rules
            "arrow-body-style": "off",
            "block-scoped-var": "off",
            "callback-return": "off",
            "capitalized-comments": "off",
            "class-methods-use-this": "off",
            "consistent-this": "off",
            "constructor-super": "off",
            "func-name-matching": "off",
            "func-names": "off",
            "global-require": "off",
            "guard-for-in": "off",
            "handle-callback-err": "off",
            "id-blacklist": "off",
            "id-length": "off",
            "id-match": "off",
            "line-comment-position": "off",
            "lines-around-comment": "off",
            "max-classes-per-file": "off",
            "max-depth": "off",
            "max-len": "off",
            "max-lines": "off",
            "max-lines-per-function": "off",
            "max-statements": "off",
            "no-await-in-loop": "off",
            "no-bitwise": "off",
            "no-buffer-constructor": "off",
            "no-class-assign": "off",
            "no-confusing-arrow": "off",
            "no-const-assign": "off",
            "no-continue": "off",
            "no-dupe-class-members": "off",
            "no-duplicate-imports": "off",
            "no-eq-null": "off",
            "no-inline-comments": "off",
            "no-labels": "off",
            "no-magic-numbers": "off",
            "no-mixed-requires": "off",
            "no-multi-assign": "off",
            "no-multi-str": "off",
            "no-negated-condition": "off",
            "no-nested-ternary": "off",
            "no-new-func": "off",
            "no-new-symbol": "off",
            "no-path-concat": "off",
            "no-plusplus": "off",
            "no-proto": "off",
            "no-redeclare": "off",
            "no-restricted-globals": "off",
            "no-restricted-imports": "off",
            "no-restricted-modules": "off",
            "no-restricted-syntax": "off",
            "no-sync": "off",
            "no-template-curly-in-string": "off",
            "no-ternary": "off",
            "no-this-before-super": "off",
            "no-undef-init": "off",
            "no-undefined": "off",
            "no-underscore-dangle": "off",
            "no-useless-computed-key": "off",
            "no-useless-constructor": "off",
            "no-useless-rename": "off",
            "no-var": "off",
            "no-warning-comments": "off",
            "object-shorthand": "off",
            "operator-assignment": "off",
            "prefer-arrow-callback": "off",
            "prefer-const": "off",
            "prefer-destructuring": "off",
            "prefer-named-capture-group": "off",
            "prefer-numeric-literals": "off",
            "prefer-rest-params": "off",
            "prefer-object-spread": "off",
            "prefer-spread": "off",
            "prefer-template": "off",
            "require-yield": "off",
            "require-unicode-regexp": "off",
            "sort-imports": "off",
            "sort-keys": "off",
            "sort-vars": "off",
            "symbol-description": "off",
            "vars-on-top": "off",

            //
            // Plugins
            //

            // eslint-comments
            "@mysticatea/eslint-comments/disable-enable-pair": "error",
            "@mysticatea/eslint-comments/no-aggregating-enable": "error",
            "@mysticatea/eslint-comments/no-duplicate-disable": "error",
            "@mysticatea/eslint-comments/no-restricted-disable": "off",
            "@mysticatea/eslint-comments/no-unlimited-disable": "error",
            "@mysticatea/eslint-comments/no-unused-disable": "error",
            "@mysticatea/eslint-comments/no-unused-enable": "error",
            "@mysticatea/eslint-comments/no-use": [
                "error",
                {
                    allow: [
                        "eslint-disable",
                        "eslint-disable-line",
                        "eslint-disable-next-line",
                        "eslint-enable",
                        "eslint-env",
                        "globals",
                    ],
                },
            ],

            // prettier
            "@mysticatea/prettier": [
                "error",
                {
                    tabWidth: 4,
                    semi: false,
                    trailingComma: "es5",
                },
                {
                    usePrettierrc: false,
                },
            ],

            // my own
            "@mysticatea/arrow-parens": "off",
            "@mysticatea/block-scoped-var": "error",
            "@mysticatea/no-instanceof-array": "error",
            "@mysticatea/no-instanceof-wrapper": "error",
            "@mysticatea/no-literal-call": "error",
            "@mysticatea/no-this-in-static": "off",
            "@mysticatea/no-use-ignored-vars": ["error", "^_(?:[^_].*)?$"],
            "@mysticatea/no-useless-rest-spread": "off",
            "@mysticatea/prefer-for-of": "off",
        },
    },
    tsConfig,
    vueConfig,
    mochaConfig,
    specialConfig
)
