# Security Policy

## Supported versions

The following table describes the versions of this project that are currently
supported with security updates:

| Version | Supported          |
| ------- | ------------------ |
| 4.x   | :white_check_mark:   |
| 3.x   | :x:                  |
| 2.x   | :x:                  |
| 1.x   | :x:                  |

## Threat Model

To better understand which classes of vulnerabilities are considered in-scope or out-of-scope for Lodash, please review the [Lodash Threat Model](./threat-model.md).

The threat model defines Lodash’s trust boundaries and clarifies how security issues are assessed for triage and disclosure.

## Responsible disclosure security policy

A responsible disclosure policy helps protect users of the project from publicly
disclosed security vulnerabilities without a fix by employing a process where
vulnerabilities are first triaged in a private manner, and only publicly disclosed
after a reasonable time period that allows patching the vulnerability and provides
an upgrade path for users.

We kindly ask you to refrain from malicious acts that put our users, the project,
or any of the project’s team members at risk.

## Reporting a security issue

We consider the security of Lodash a top priority. But no matter how much effort
we put into security, there can still be vulnerabilities present.

If you discover a security vulnerability, please report the security issue
directly to the Lodash maintainers through the [Security tab](https://github.com/lodash/lodash/security) of the Lodash
repository.

Your efforts to responsibly disclose your findings are sincerely appreciated.

## Escalation

If you do not receive an acknowledgement of your report within 6 business days, or if you cannot find a private security contact for the project, you may escalate to the OpenJS Foundation CNA at `security@lists.openjsf.org`.

If the project acknowledges your report but does not provide any further response or engagement within 14 days, escalation is also appropriate.
