.\"
.\" %nmhwarning%
.\"
.TH INSTALL-MH %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
install-mh \- initialize the nmh environment
.SH SYNOPSIS
.HP 5
.na
.B %libdir%/install\-mh
.RB [ \-auto ]
.RB [ \-check ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Install\-mh
is the
.B nmh
program to create the initial setup
for a first\-time
.B nmh
user.
.B Install\-mh
lives in two places for historical reasons.
.PP
The \fB\-auto\fP option does things as automatically as possible and
makes \fBinstall\-mh\fP less chatty.
.PP
The user is asked
for the name of the directory that will be designated as the user's
.B nmh
directory.  If this directory does not exist, the user is
asked if it should be created.  Normally, this directory should be
under the user's home directory, and has the default name of
\fI``Mail''\fP.
.B Install\-mh
writes an initial
.I \&.mh\(ruprofile
for the user.
.PP
As with all
.B nmh
commands,
.B install\-mh
first checks for the existence of the \fB$MH\fP environment variable
since that gives the profile path if set.
If it isn't set, the
.B $HOME
environment variable is consulted to determine the user's home directory.
If
.B $HOME
is not set, then the
.I /etc/passwd
file is consulted.
.PP
When creating the users initial
.IR \&.mh\(ruprofile ,
.B install\-mh
will check for the existence of a global profile
.IR %etcdir%/mh.profile .
If found, this will be used to initialize the new
.IR \&.mh\(ruprofile .
.PP
The \fB\-check\fP option can be used to check whether or not nmh has
been installed.
This can be used by other programs to determine whether or not nmh has
been installed without their having to know the internals of nmh.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mh.profile~^Used to initialize user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To set the user's nmh directory
.fi

.SH CONTEXT
With
.BR \-auto ,
the current folder is changed to
.RI \*(lq inbox \*(rq.
