/**
 * \file input/sage/sagefilereader.h
 * \date 11/10/2024
 * \author Olivier Langella
 * \brief read data files from Sage output containin multiple samples
 */

/*******************************************************************************
 * Copyright (c) 2024 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once
#include "pappsomspp/core/fasta/fastahandlerinterface.h"
#include "pappsomspp/core/processing/uimonitor/uimonitorinterface.h"
#include <QJsonDocument>
#include "pappsomspp/core/processing/cbor/cborstreamwriter.h"
#include <QFileInfo>

namespace pappso
{
namespace cbor
{
namespace psm
{

/**
 * @todo write docs
 */
class SageFileReader
{
  public:
  /**
   * Default constructor
   */
  SageFileReader(pappso::UiMonitorInterface *p_monitor,
                 pappso::cbor::CborStreamWriter *p_output,
                 const QFileInfo &sage_json_file);

  /**
   * Destructor
   */
  virtual ~SageFileReader();

  const QJsonDocument &getJsonDocument() const;
  QString getMsRunSpWithFileName(const QString &msrun_filename) const;

  private:
  void readJson();

  private:
  const QFileInfo m_sageJsonFile;
  QJsonDocument m_jsonData;

  std::map<QString, QString> m_mapFilePath2MsRunSp;
  QString m_sageVersion;
  pappso::cbor::CborStreamWriter *mp_cborWriter;
  QString m_decoyTag;
  bool m_generateDecoy = false;
  QStringList m_targetFastaFile;
};

} // namespace psm
} // namespace cbor
} // namespace pappso
