# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=ampere1b -instruction-tables < %s | FileCheck %s

abs	w1, w2
abs	x2, x3
cnt	w3, w4
cnt	x4, x5
ctz	w5, w6
ctz	x6, x7
smax	w7, w8, w9
smax	x8, x9, x10
umax	w9, w10, w11
umax	x10, x11, x12
smin	w11, w12, w13
smin	w12, w13, w14
umin	w13, w14, w15
umin	x14, x15, x16

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        abs	w1, w2
# CHECK-NEXT:  1      1     0.25                        abs	x2, x3
# CHECK-NEXT:  1      3     1.00                        cnt	w3, w4
# CHECK-NEXT:  1      3     1.00                        cnt	x4, x5
# CHECK-NEXT:  1      1     0.50                        ctz	w5, w6
# CHECK-NEXT:  1      1     0.50                        ctz	x6, x7
# CHECK-NEXT:  2      1     0.50                        smax	w7, w8, w9
# CHECK-NEXT:  2      1     0.50                        smax	x8, x9, x10
# CHECK-NEXT:  2      1     0.50                        umax	w9, w10, w11
# CHECK-NEXT:  2      1     0.50                        umax	x10, x11, x12
# CHECK-NEXT:  2      1     0.50                        smin	w11, w12, w13
# CHECK-NEXT:  2      1     0.50                        smin	w12, w13, w14
# CHECK-NEXT:  2      1     0.50                        umin	w13, w14, w15
# CHECK-NEXT:  2      1     0.50                        umin	x14, x15, x16

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - Ampere1BUnitA
# CHECK-NEXT: [0.1] - Ampere1BUnitA
# CHECK-NEXT: [1.0] - Ampere1BUnitB
# CHECK-NEXT: [1.1] - Ampere1BUnitB
# CHECK-NEXT: [2]   - Ampere1BUnitBS
# CHECK-NEXT: [3.0] - Ampere1BUnitL
# CHECK-NEXT: [3.1] - Ampere1BUnitL
# CHECK-NEXT: [4.0] - Ampere1BUnitS
# CHECK-NEXT: [4.1] - Ampere1BUnitS
# CHECK-NEXT: [5]   - Ampere1BUnitX
# CHECK-NEXT: [6]   - Ampere1BUnitY
# CHECK-NEXT: [7]   - Ampere1BUnitZ

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]    [6]    [7]
# CHECK-NEXT: 6.50   6.50   3.50   3.50   2.00    -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]    [6]    [7]    Instructions:
# CHECK-NEXT: 0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -     abs	w1, w2
# CHECK-NEXT: 0.25   0.25   0.25   0.25    -      -      -      -      -      -      -      -     abs	x2, x3
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -     cnt	w3, w4
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -     cnt	x4, x5
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -      -      -     ctz	w5, w6
# CHECK-NEXT:  -      -     0.50   0.50    -      -      -      -      -      -      -      -     ctz	x6, x7
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     smax	w7, w8, w9
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     smax	x8, x9, x10
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     umax	w9, w10, w11
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     umax	x10, x11, x12
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     smin	w11, w12, w13
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     smin	w12, w13, w14
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     umin	w13, w14, w15
# CHECK-NEXT: 0.75   0.75   0.25   0.25    -      -      -      -      -      -      -      -     umin	x14, x15, x16
