; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=rewrite-statepoints-for-gc -S 2>&1 | FileCheck %s

declare ptr addrspace(1) @generate_obj() "gc-leaf-function"

declare void @use_obj(ptr addrspace(1)) "gc-leaf-function"

; The rewriting needs to make %obj loop variant by inserting a phi
; of the original value and it's relocation.
define void @test() gc "statepoint-example" {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[OBJ:%.*]] = call ptr addrspace(1) @generate_obj()
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[DOT0:%.*]] = phi ptr addrspace(1) [ [[OBJ]], [[ENTRY:%.*]] ], [ [[OBJ_RELOCATED:%.*]], [[LOOP]] ]
; CHECK-NEXT:    call void @use_obj(ptr addrspace(1) [[DOT0]])
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @do_safepoint, i32 0, i32 0, i32 0, i32 0) [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[DOT0]]) ]
; CHECK-NEXT:    [[OBJ_RELOCATED]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  %obj = call ptr addrspace(1) @generate_obj()
  br label %loop

loop:
  call void @use_obj(ptr addrspace(1) %obj)
  call void @do_safepoint() [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0) ]
  br label %loop
}

declare void @do_safepoint()

declare void @parse_point(ptr addrspace(1))

define ptr addrspace(1) @test1(i32 %caller, ptr addrspace(1) %a, ptr addrspace(1) %b, i32 %unknown, i1 %c) gc "statepoint-example" {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[LEFT:%.*]], label [[RIGHT:%.*]]
; CHECK:       left:
; CHECK-NEXT:    switch i32 [[UNKNOWN:%.*]], label [[RIGHT]] [
; CHECK-NEXT:      i32 0, label [[MERGE:%.*]]
; CHECK-NEXT:      i32 1, label [[MERGE]]
; CHECK-NEXT:      i32 5, label [[MERGE]]
; CHECK-NEXT:    ]
; CHECK:       right:
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[VALUE:%.*]] = phi ptr addrspace(1) [ [[A:%.*]], [[LEFT]] ], [ [[A]], [[LEFT]] ], [ [[A]], [[LEFT]] ], [ [[B:%.*]], [[RIGHT]] ]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void (ptr addrspace(1))) @parse_point, i32 1, i32 0, ptr addrspace(1) [[VALUE]], i32 0, i32 0) [ "deopt"(i32 0, i32 0, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[VALUE]]) ]
; CHECK-NEXT:    [[VALUE_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    ret ptr addrspace(1) [[VALUE_RELOCATED]]
;
entry:
  br i1 %c, label %left, label %right

left:
; Our safepoint placement pass calls removeUnreachableBlocks, which does a bunch
; of simplifications to branch instructions.  This bug is visible only when
; there are multiple branches into the same block from the same predecessor, and
; the following ceremony is to make that artefact survive a call to
; removeUnreachableBlocks.  As an example, "br i1 undef, label %merge, label %merge"
; will get simplified to "br label %merge" by removeUnreachableBlocks.
  switch i32 %unknown, label %right [
  i32 0, label %merge
  i32 1, label %merge
  i32 5, label %merge
  i32 3, label %right
  ]

right:
  br label %merge

merge:
  %value = phi ptr addrspace(1) [ %a, %left ], [ %a, %left ], [ %a, %left ], [ %b, %right ]
  call void @parse_point(ptr addrspace(1) %value) [ "deopt"(i32 0, i32 0, i32 0, i32 0, i32 0) ]
  ret ptr addrspace(1) %value
}

;; The purpose of this test is to ensure that when two live values share a
;;  base defining value with inherent conflicts, we end up with a *single*
;;  base phi/select per such node.  This is testing an optimization, not a
;;  fundemental correctness criteria
define void @test2(i1 %cnd, ptr addrspace(1) %base_obj, ptr addrspace(1) %base_arg2) gc "statepoint-example" {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[OBJ:%.*]] = getelementptr i64, ptr addrspace(1) [[BASE_OBJ:%.*]], i32 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[DOT0:%.*]] = phi ptr addrspace(1) [ [[BASE_ARG2:%.*]], [[ENTRY:%.*]] ], [ [[BASE_ARG2_RELOCATED:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[CURRENT_BASE:%.*]] = phi ptr addrspace(1) [ [[BASE_OBJ]], [[ENTRY]] ], [ [[NEXT_BASE_RELOCATED:%.*]], [[LOOP]] ], !is_base_value !0
; CHECK-NEXT:    [[CURRENT:%.*]] = phi ptr addrspace(1) [ [[OBJ]], [[ENTRY]] ], [ [[NEXT_RELOCATED:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[EXTRA:%.*]] = phi ptr addrspace(1) [ [[OBJ]], [[ENTRY]] ], [ [[EXTRA2_RELOCATED:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[NEXTA:%.*]] = getelementptr i64, ptr addrspace(1) [[CURRENT]], i32 1
; CHECK-NEXT:    [[NEXT_BASE:%.*]] = select i1 [[CND:%.*]], ptr addrspace(1) [[CURRENT_BASE]], ptr addrspace(1) [[DOT0]], !is_base_value !0
; CHECK-NEXT:    [[NEXT:%.*]] = select i1 [[CND]], ptr addrspace(1) [[NEXTA]], ptr addrspace(1) [[DOT0]]
; CHECK-NEXT:    [[EXTRA2_BASE:%.*]] = select i1 [[CND]], ptr addrspace(1) [[CURRENT_BASE]], ptr addrspace(1) [[DOT0]], !is_base_value !0
; CHECK-NEXT:    [[EXTRA2:%.*]] = select i1 [[CND]], ptr addrspace(1) [[NEXTA]], ptr addrspace(1) [[DOT0]]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[NEXT_BASE]], ptr addrspace(1) [[NEXT]], ptr addrspace(1) [[EXTRA2]], ptr addrspace(1) [[DOT0]], ptr addrspace(1) [[EXTRA2_BASE]]) ]
; CHECK-NEXT:    [[NEXT_BASE_RELOCATED]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    [[NEXT_RELOCATED]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 1)
; CHECK-NEXT:    [[EXTRA2_RELOCATED]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 4, i32 2)
; CHECK-NEXT:    [[BASE_ARG2_RELOCATED]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 3, i32 3)
; CHECK-NEXT:    [[EXTRA2_BASE_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 4, i32 4)
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  %obj = getelementptr i64, ptr addrspace(1) %base_obj, i32 1
  br label %loop

; Given the two selects are equivelent, so are their base phis - ideally,
; we'd have commoned these, but that's a missed optimization, not correctness.
;; Both 'next' and 'extra2' are live across the backedge safepoint...

loop:
  %current = phi ptr addrspace(1) [ %obj, %entry ], [ %next, %loop ]
  %extra = phi ptr addrspace(1) [ %obj, %entry ], [ %extra2, %loop ]
  %nexta = getelementptr i64, ptr addrspace(1) %current, i32 1
  %next = select i1 %cnd, ptr addrspace(1) %nexta, ptr addrspace(1) %base_arg2
  %extra2 = select i1 %cnd, ptr addrspace(1) %nexta, ptr addrspace(1) %base_arg2
  call void @foo() [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0) ]
  br label %loop
}

define ptr addrspace(1) @test3(i1 %cnd, ptr addrspace(1) %obj, ptr addrspace(1) %obj2) gc "statepoint-example" {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CND:%.*]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; CHECK:       taken:
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[BDV:%.*]] = phi ptr addrspace(1) [ [[OBJ:%.*]], [[ENTRY:%.*]] ], [ [[OBJ2:%.*]], [[TAKEN]] ]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[BDV]]) ]
; CHECK-NEXT:    [[BDV_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    ret ptr addrspace(1) [[BDV_RELOCATED]]
;
entry:
  br i1 %cnd, label %merge, label %taken

taken:
  br label %merge

merge:
  %bdv = phi ptr addrspace(1) [ %obj, %entry ], [ %obj2, %taken ]
  call void @foo() [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0) ]
  ret ptr addrspace(1) %bdv
}

define ptr addrspace(1) @test4(i1 %cnd, ptr addrspace(1) %obj, ptr addrspace(1) %obj2) gc "statepoint-example" {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CND:%.*]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; CHECK:       taken:
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[BDV:%.*]] = phi ptr addrspace(1) [ [[OBJ:%.*]], [[ENTRY:%.*]] ], [ [[OBJ]], [[TAKEN]] ]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[BDV]]) ]
; CHECK-NEXT:    [[BDV_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    ret ptr addrspace(1) [[BDV_RELOCATED]]
;
entry:
  br i1 %cnd, label %merge, label %taken

taken:
  br label %merge

merge:
  %bdv = phi ptr addrspace(1) [ %obj, %entry ], [ %obj, %taken ]
  call void @foo() [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0) ]
  ret ptr addrspace(1) %bdv
}

define ptr addrspace(1) @test5(i1 %cnd, ptr addrspace(1) %obj, ptr addrspace(1) %obj2) gc "statepoint-example" {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[MERGE:%.*]]
; CHECK:       merge:
; CHECK-NEXT:    [[BDV:%.*]] = phi ptr addrspace(1) [ [[OBJ:%.*]], [[ENTRY:%.*]] ], [ [[OBJ2:%.*]], [[MERGE]] ]
; CHECK-NEXT:    br i1 [[CND:%.*]], label [[MERGE]], label [[NEXT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0), "gc-live"(ptr addrspace(1) [[BDV]]) ]
; CHECK-NEXT:    [[BDV_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    ret ptr addrspace(1) [[BDV_RELOCATED]]
;
entry:
  br label %merge

merge:
  %bdv = phi ptr addrspace(1) [ %obj, %entry ], [ %obj2, %merge ]
  br i1 %cnd, label %merge, label %next

next:
  call void @foo() [ "deopt"(i32 0, i32 -1, i32 0, i32 0, i32 0) ]
  ret ptr addrspace(1) %bdv
}

; We know from the deopt use that %bdv must be a base value, and as
; result can avoid materializing the extra copy of the BDV phi node.
; (Even without a general forward analysis)
define ptr addrspace(1) @test6(i1 %cnd, ptr addrspace(1) %obj, ptr addrspace(1) %obj2) gc "statepoint-example" {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[MERGE:%.*]]
; CHECK:       merge:
; CHECK-NEXT:    [[BDV:%.*]] = phi ptr addrspace(1) [ [[OBJ:%.*]], [[ENTRY:%.*]] ], [ [[OBJ2:%.*]], [[MERGE]] ]
; CHECK-NEXT:    br i1 [[CND:%.*]], label [[MERGE]], label [[NEXT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(ptr addrspace(1) [[BDV]]), "gc-live"(ptr addrspace(1) [[BDV]]) ]
; CHECK-NEXT:    [[BDV_RELOCATED:%.*]] = call coldcc ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token [[STATEPOINT_TOKEN]], i32 0, i32 0)
; CHECK-NEXT:    ret ptr addrspace(1) [[BDV_RELOCATED]]
;
entry:
  br label %merge

merge:
  %bdv = phi ptr addrspace(1) [ %obj, %entry ], [ %obj2, %merge ]
  br i1 %cnd, label %merge, label %next

next:
  call void @foo() [ "deopt"(ptr addrspace(1) %bdv) ]
  ret ptr addrspace(1) %bdv
}

declare i32 @snork()

define void @test7() gc "statepoint-example" {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[GETELEMENTPTR:%.*]] = getelementptr i8, <2 x ptr addrspace(1)> zeroinitializer, <2 x i64> <i64 888, i64 908>
; CHECK-NEXT:    [[SHUFFLEVECTOR_BASE:%.*]] = shufflevector <2 x ptr addrspace(1)> zeroinitializer, <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>, !is_base_value !0
; CHECK-NEXT:    [[SHUFFLEVECTOR:%.*]] = shufflevector <2 x ptr addrspace(1)> [[GETELEMENTPTR]], <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SHUFFLEVECTOR1_BASE:%.*]] = shufflevector <2 x ptr addrspace(1)> zeroinitializer, <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>, !is_base_value !0
; CHECK-NEXT:    [[SHUFFLEVECTOR1:%.*]] = shufflevector <2 x ptr addrspace(1)> [[GETELEMENTPTR]], <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SELECT_BASE:%.*]] = select i1 false, <4 x ptr addrspace(1)> [[SHUFFLEVECTOR1_BASE]], <4 x ptr addrspace(1)> [[SHUFFLEVECTOR_BASE]], !is_base_value !0
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 false, <4 x ptr addrspace(1)> [[SHUFFLEVECTOR1]], <4 x ptr addrspace(1)> [[SHUFFLEVECTOR]]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 2882400000, i32 0, ptr elementtype(i32 ()) @snork, i32 0, i32 0, i32 0, i32 0) [ "gc-live"(<4 x ptr addrspace(1)> [[SELECT]], <4 x ptr addrspace(1)> [[SELECT_BASE]]) ]
; CHECK-NEXT:    [[SELECT_RELOCATED:%.*]] = call coldcc <4 x ptr addrspace(1)> @llvm.experimental.gc.relocate.v4p1(token [[STATEPOINT_TOKEN]], i32 1, i32 0)
; CHECK-NEXT:    [[SELECT_BASE_RELOCATED:%.*]] = call coldcc <4 x ptr addrspace(1)> @llvm.experimental.gc.relocate.v4p1(token [[STATEPOINT_TOKEN]], i32 1, i32 1)
; CHECK-NEXT:    [[EXTRACTELEMENT:%.*]] = extractelement <4 x ptr addrspace(1)> [[SELECT_RELOCATED]], i32 0
; CHECK-NEXT:    ret void
;
bb:
  %getelementptr = getelementptr i8, <2 x ptr addrspace(1)> zeroinitializer, <2 x i64> <i64 888, i64 908>
  %shufflevector = shufflevector <2 x ptr addrspace(1)> %getelementptr, <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shufflevector1 = shufflevector <2 x ptr addrspace(1)> %getelementptr, <2 x ptr addrspace(1)> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %select = select i1 false, <4 x ptr addrspace(1)> %shufflevector1, <4 x ptr addrspace(1)> %shufflevector
  %call = call i32 @snork()
  %extractelement = extractelement <4 x ptr addrspace(1)> %select, i32 0
  ret void
}

declare void @foo()
