#ifndef __GTK_LOOPVIEW_H__
#define __GTK_LOOPVIEW_H__


#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <sys/time.h>
#include <time.h>
#include "../../common/peakview.h"
#include "looper.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_LOOPVIEW(obj)          GTK_CHECK_CAST (obj, gtk_loopview_get_type (), GtkLoopview)
#define GTK_LOOPVIEW_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_loopview_get_type (), GtkLoopviewClass)
#define GTK_IS_LOOPVIEW(obj)       GTK_CHECK_TYPE (obj, gtk_loopview_get_type ())


typedef struct _GtkLoopview        GtkLoopview;
typedef struct _GtkLoopviewClass   GtkLoopviewClass;

struct _GtkLoopview
{
  	GtkWidget widget;
	GdkPixmap *pixmap;

  	/* update policy (GTK_UPDATE_[CONTINUOUS/DELAYED/DISCONTINUOUS]) */
  	guint policy : 2;

  	/* Button currently pressed or 0 if none */
  	guint8 button;

  	/* ID of update timer, or 0 if none */
  	guint32 timer;

	/* number of last samples updated */
	guint32 lastnup;

  	/* our looper_data */
  	looper_data_t *looperdata;
	
	/* peakview */
	peakview_t *peakview;

	/* graphics active ? */
	gboolean suspended;

	/* pointer position */
	gint pointerX;
	gint pointerY;

  	/* peakdata L,R,min,max */
  	gint8 *Lmin;
  	gint8 *Rmin;
  	gint8 *Lmax;
  	gint8 *Rmax;
/*	gint8 *attac;*/

  	gint32 npeaks;
	gint32 width;
	gint32 height;
	gint32 Lmid;
        gint32 Rmid;
        gint32 Hmax;


	/* sample domain indices */
        guint32 zoomstart;
        guint32 zoomend;
	guint32	gridstart;
	guint32 gridwidth;
	guint32 gridoffset;

	/* 'graphical' indices */
	gint32 gloopstart;
	gint32 gloopend;
	gint32 grecstart;
	gint32 grecend;
	gint32 gzoomstart;
	gint32 gzoomend;
	gint32 gplaypos;
	gint32 grecpos;
	gint32 grabsel;
	gint32 lastmouseX;
	gint32 lastmouseY;
/*	gint32 ggridwidth; */
/*	gint32 ggridstart; */
	gdouble ggridwidth;
	gdouble ggridstart;
	gdouble bpm;
	gdouble bpb; /* beats per bar */
	struct timeval lastmousetime;	
	double speedbeforescratch;
	gboolean nearby;
	gboolean snap2grid;
	gboolean showgrid;
	gboolean showattac;

	/* colors  and GCs*/
	GdkGC  *bgc;
        GdkGC  *fgc;
	GdkColor bg_plain;
	GdkColor bg_play;
	GdkColor bg_rec;
	GdkColor bg_zoom;
	GdkColor bg_recplay;
	GdkColor bg_reczoom;
	GdkColor bg_playzoom;
	GdkColor bg_recplayzoom;
	GdkColor bg_grid;
	GdkColor bg_bar;
	GdkColor bg_beat;
	GdkColor fg_plain;
	GdkColor fg_lit;
	GdkColor playcursor;
	GdkColor reccursor;
};

struct _GtkLoopviewClass
{
  	GtkWidgetClass parent_class;

	void (*loopborders_changed)(GtkLoopviewClass *loop, long start, long end);
};

enum {
	SIG_LOOPBORDERS_CHANGED,
	SIG_RECBORDERS_CHANGED,
	SIG_ZOOMBORDERS_CHANGED,
	SIG_SPEED_CHANGED,
	LAST_SIGNAL
};

GtkWidget*     	gtk_loopview_new                 	(looper_data_t *looperdata);
GtkType        	gtk_loopview_get_type            	(void);
looper_data_t* 	gtk_loopview_get_looperdata     	(GtkLoopview *loopview);
void           	gtk_loopview_set_update_policy   	(GtkLoopview *loopview, GtkUpdateType  policy);
void           	gtk_loopview_set_looperdata     	(GtkLoopview *loopview, looper_data_t *looperdata);
void 		gtk_loopview_suspend_gui 		(GtkLoopview *loopview, int suspend);
void	       	gtk_loopview_set_play_pos		(GtkLoopview *loopview, gdouble playpos);
void           	gtk_loopview_set_rec_pos         	(GtkLoopview *loopview, gdouble recpos);
/*void 	       	gtk_loopview_calc_peaks	        	(GtkLoopview *loopview,guint32 startx, guint32 endx);*/
void		gtk_loopview_copy_peaks			(GtkLoopview *loopview, peakdata_t* pd);
void 	       	gtk_loopview_update_cursorposition 	(GtkLoopview *loopview);
void 		gtk_loopview_update_area		(GtkLoopview *loopview, gint32 startx, gint32 endx);

void 		gtk_loopview_zoom_to_playselection 	(GtkLoopview *loopview);
void 		gtk_loopview_zoom_to_recselection 	(GtkLoopview *loopview);
void		gtk_loopview_zoom_to_overview 		(GtkLoopview *loopview);

void		gtk_loopview_set_zoom			(GtkLoopview *loopview, gdouble zoomstart, gdouble zoomend);
long 		gtk_loopview_get_zoomstart 		(GtkLoopview *loopview);
long		gtk_loopview_get_zoomend		(GtkLoopview *loopview);

void 		gtk_loopview_update_loopstart 		(GtkLoopview *loopview);
void            gtk_loopview_update_loopend		(GtkLoopview *loopview);

void            gtk_loopview_update_recstart		(GtkLoopview *loopview);
void		gtk_loopview_update_recend		(GtkLoopview *loopview);
void		gtk_loopview_update_waveform		(GtkLoopview *loopview);

void 		gtk_loopview_set_snap2grid 		(GtkLoopview *loopview, gboolean snap);
gboolean 	gtk_loopview_getsnap2grid 		(GtkLoopview *loopview);
void            gtk_loopview_set_showgrid		(GtkLoopview *loopview, gboolean show);
gboolean	gtk_loopview_get_showgrid		(GtkLoopview *loopview);

void            gtk_loopview_set_bpm			(GtkLoopview *loopview, gdouble bpm);
gdouble		gtk_loopview_get_bpm			(GtkLoopview *loopview);
guint32         gtk_loopview_get_gridwidth		(GtkLoopview *loopview);
void		gtk_loopview_set_gridoffset		(GtkLoopview *loopview, guint32 offset);
guint32		gtk_loopview_get_gridoffset		(GtkLoopview *loopview);
void		gtk_loopview_set_bpb			(GtkLoopview *loopview, gdouble bpb);
gdouble		gtk_loopview_get_bpb			(GtkLoopview *loopview);
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_LOOPVIEW_H__ */

