
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQInputDevice.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QInputDevice>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QInputDevice

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QInputDevice::staticMetaObject);
}


// QRect QInputDevice::availableVirtualGeometry()


static void _init_f_availableVirtualGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_availableVirtualGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QInputDevice *)cls)->availableVirtualGeometry ());
}


// QFlags<QInputDevice::Capability> QInputDevice::capabilities()


static void _init_f_capabilities_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QInputDevice::Capability> > ();
}

static void _call_f_capabilities_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QInputDevice::Capability> > ((QFlags<QInputDevice::Capability>)((QInputDevice *)cls)->capabilities ());
}


// bool QInputDevice::hasCapability(QInputDevice::Capability cap)


static void _init_f_hasCapability_c2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cap");
  decl->add_arg<const qt_gsi::Converter<QInputDevice::Capability>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasCapability_c2779 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QInputDevice::Capability>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QInputDevice::Capability>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QInputDevice *)cls)->hasCapability (qt_gsi::QtToCppAdaptor<QInputDevice::Capability>(arg1).cref()));
}


// QString QInputDevice::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDevice *)cls)->name ());
}


// bool QInputDevice::operator==(const QInputDevice &other)


static void _init_f_operator_eq__eq__c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QInputDevice & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QInputDevice &arg1 = gsi::arg_reader<const QInputDevice & >() (args, heap);
  ret.write<bool > ((bool)((QInputDevice *)cls)->operator== (arg1));
}


// QString QInputDevice::seatName()


static void _init_f_seatName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_seatName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDevice *)cls)->seatName ());
}


// qint64 QInputDevice::systemId()


static void _init_f_systemId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_systemId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QInputDevice *)cls)->systemId ());
}


// QInputDevice::DeviceType QInputDevice::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QInputDevice::DeviceType>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QInputDevice::DeviceType>::target_type > ((qt_gsi::Converter<QInputDevice::DeviceType>::target_type)qt_gsi::CppToQtAdaptor<QInputDevice::DeviceType>(((QInputDevice *)cls)->type ()));
}


// static QList<const QInputDevice *> QInputDevice::devices()


static void _init_f_devices_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<const QInputDevice *> > ();
}

static void _call_f_devices_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<const QInputDevice *> > ((QList<const QInputDevice *>)QInputDevice::devices ());
}


// static const QInputDevice *QInputDevice::primaryKeyboard(const QString &seatName)


static void _init_f_primaryKeyboard_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seatName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<const QInputDevice * > ();
}

static void _call_f_primaryKeyboard_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<const QInputDevice * > ((const QInputDevice *)QInputDevice::primaryKeyboard (arg1));
}


// static QString QInputDevice::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QInputDevice::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QInputDevice () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":availableVirtualGeometry", "@brief Method QRect QInputDevice::availableVirtualGeometry()\n", true, &_init_f_availableVirtualGeometry_c0, &_call_f_availableVirtualGeometry_c0);
  methods += new qt_gsi::GenericMethod (":capabilities", "@brief Method QFlags<QInputDevice::Capability> QInputDevice::capabilities()\n", true, &_init_f_capabilities_c0, &_call_f_capabilities_c0);
  methods += new qt_gsi::GenericMethod ("hasCapability", "@brief Method bool QInputDevice::hasCapability(QInputDevice::Capability cap)\n", true, &_init_f_hasCapability_c2779, &_call_f_hasCapability_c2779);
  methods += new qt_gsi::GenericMethod (":name", "@brief Method QString QInputDevice::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QInputDevice::operator==(const QInputDevice &other)\n", true, &_init_f_operator_eq__eq__c2514, &_call_f_operator_eq__eq__c2514);
  methods += new qt_gsi::GenericMethod (":seatName", "@brief Method QString QInputDevice::seatName()\n", true, &_init_f_seatName_c0, &_call_f_seatName_c0);
  methods += new qt_gsi::GenericMethod (":systemId", "@brief Method qint64 QInputDevice::systemId()\n", true, &_init_f_systemId_c0, &_call_f_systemId_c0);
  methods += new qt_gsi::GenericMethod (":type", "@brief Method QInputDevice::DeviceType QInputDevice::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += gsi::qt_signal<QRect > ("availableVirtualGeometryChanged(QRect)", "availableVirtualGeometryChanged", gsi::arg("area"), "@brief Signal declaration for QInputDevice::availableVirtualGeometryChanged(QRect area)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QInputDevice::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QInputDevice::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("devices", "@brief Static method QList<const QInputDevice *> QInputDevice::devices()\nThis method is static and can be called without an instance.", &_init_f_devices_0, &_call_f_devices_0);
  methods += new qt_gsi::GenericStaticMethod ("primaryKeyboard", "@brief Static method const QInputDevice *QInputDevice::primaryKeyboard(const QString &seatName)\nThis method is static and can be called without an instance.", &_init_f_primaryKeyboard_2025, &_call_f_primaryKeyboard_2025);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputDevice::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QInputDevice> decl_QInputDevice (qtdecl_QObject (), "QtGui", "QInputDevice_Native",
  methods_QInputDevice (),
  "@hide\n@alias QInputDevice");

GSI_QTGUI_PUBLIC gsi::Class<QInputDevice> &qtdecl_QInputDevice () { return decl_QInputDevice; }

}


class QInputDevice_Adaptor : public QInputDevice, public qt_gsi::QtObjectBase
{
public:

  virtual ~QInputDevice_Adaptor();

  //  [adaptor ctor] QInputDevice::QInputDevice(QObject *parent)
  QInputDevice_Adaptor() : QInputDevice()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDevice::QInputDevice(QObject *parent)
  QInputDevice_Adaptor(QObject *parent) : QInputDevice(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDevice::QInputDevice(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent)
  QInputDevice_Adaptor(const QString &name, qint64 systemId, QInputDevice::DeviceType type) : QInputDevice(name, systemId, type)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDevice::QInputDevice(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent)
  QInputDevice_Adaptor(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName) : QInputDevice(name, systemId, type, seatName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDevice::QInputDevice(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent)
  QInputDevice_Adaptor(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent) : QInputDevice(name, systemId, type, seatName, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QInputDevice::isSignalConnected(const QMetaMethod &signal)
  bool fp_QInputDevice_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QInputDevice::isSignalConnected(signal);
  }

  //  [expose] int QInputDevice::receivers(const char *signal)
  int fp_QInputDevice_receivers_c1731 (const char *signal) const {
    return QInputDevice::receivers(signal);
  }

  //  [expose] QObject *QInputDevice::sender()
  QObject * fp_QInputDevice_sender_c0 () const {
    return QInputDevice::sender();
  }

  //  [expose] int QInputDevice::senderSignalIndex()
  int fp_QInputDevice_senderSignalIndex_c0 () const {
    return QInputDevice::senderSignalIndex();
  }

  //  [emitter impl] void QInputDevice::availableVirtualGeometryChanged(QRect area)
  void emitter_QInputDevice_availableVirtualGeometryChanged_915(QRect area)
  {
    emit QInputDevice::availableVirtualGeometryChanged(area);
  }

  //  [emitter impl] void QInputDevice::destroyed(QObject *)
  void emitter_QInputDevice_destroyed_1302(QObject *arg1)
  {
    emit QInputDevice::destroyed(arg1);
  }

  //  [adaptor impl] bool QInputDevice::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QInputDevice::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QInputDevice_Adaptor, bool, QEvent *>(&QInputDevice_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QInputDevice::event(_event);
    }
  }

  //  [adaptor impl] bool QInputDevice::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QInputDevice::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QInputDevice_Adaptor, bool, QObject *, QEvent *>(&QInputDevice_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QInputDevice::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QInputDevice::objectNameChanged(const QString &objectName)
  void emitter_QInputDevice_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QInputDevice::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QInputDevice::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QInputDevice::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QInputDevice_Adaptor, QChildEvent *>(&QInputDevice_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QInputDevice::childEvent(event);
    }
  }

  //  [adaptor impl] void QInputDevice::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QInputDevice::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QInputDevice_Adaptor, QEvent *>(&QInputDevice_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QInputDevice::customEvent(event);
    }
  }

  //  [adaptor impl] void QInputDevice::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QInputDevice::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QInputDevice_Adaptor, const QMetaMethod &>(&QInputDevice_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QInputDevice::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QInputDevice::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QInputDevice::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QInputDevice_Adaptor, QTimerEvent *>(&QInputDevice_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QInputDevice::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QInputDevice_Adaptor::~QInputDevice_Adaptor() { }

//  Constructor QInputDevice::QInputDevice(QObject *parent) (adaptor class)

static void _init_ctor_QInputDevice_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QInputDevice_Adaptor> ();
}

static void _call_ctor_QInputDevice_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QInputDevice_Adaptor *> (new QInputDevice_Adaptor (arg1));
}


//  Constructor QInputDevice::QInputDevice(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent) (adaptor class)

static void _init_ctor_QInputDevice_Adaptor_8669 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("systemId");
  decl->add_arg<qint64 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type");
  decl->add_arg<const qt_gsi::Converter<QInputDevice::DeviceType>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("seatName", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_4);
  decl->set_return_new<QInputDevice_Adaptor> ();
}

static void _call_ctor_QInputDevice_Adaptor_8669 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  qint64 arg2 = gsi::arg_reader<qint64 >() (args, heap);
  const qt_gsi::Converter<QInputDevice::DeviceType>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QInputDevice::DeviceType>::target_type & >() (args, heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QObject *arg5 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QInputDevice_Adaptor *> (new QInputDevice_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QInputDevice::DeviceType>(arg3).cref(), arg4, arg5));
}


// emitter void QInputDevice::availableVirtualGeometryChanged(QRect area)

static void _init_emitter_availableVirtualGeometryChanged_915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<QRect > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availableVirtualGeometryChanged_915 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRect arg1 = gsi::arg_reader<QRect >() (args, heap);
  ((QInputDevice_Adaptor *)cls)->emitter_QInputDevice_availableVirtualGeometryChanged_915 (arg1);
}


// void QInputDevice::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDevice_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QInputDevice::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDevice_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QInputDevice::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QInputDevice_Adaptor *)cls)->emitter_QInputDevice_destroyed_1302 (arg1);
}


// void QInputDevice::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDevice_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QInputDevice::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputDevice_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QInputDevice::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputDevice_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QInputDevice::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QInputDevice_Adaptor *)cls)->fp_QInputDevice_isSignalConnected_c2394 (arg1));
}


// emitter void QInputDevice::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QInputDevice_Adaptor *)cls)->emitter_QInputDevice_objectNameChanged_4567 (arg1);
}


// exposed int QInputDevice::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QInputDevice_Adaptor *)cls)->fp_QInputDevice_receivers_c1731 (arg1));
}


// exposed QObject *QInputDevice::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QInputDevice_Adaptor *)cls)->fp_QInputDevice_sender_c0 ());
}


// exposed int QInputDevice::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDevice_Adaptor *)cls)->fp_QInputDevice_senderSignalIndex_c0 ());
}


// void QInputDevice::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDevice_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDevice_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QInputDevice> &qtdecl_QInputDevice ();

static gsi::Methods methods_QInputDevice_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputDevice::QInputDevice(QObject *parent)\nThis method creates an object of class QInputDevice.", &_init_ctor_QInputDevice_Adaptor_1302, &_call_ctor_QInputDevice_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputDevice::QInputDevice(const QString &name, qint64 systemId, QInputDevice::DeviceType type, const QString &seatName, QObject *parent)\nThis method creates an object of class QInputDevice.", &_init_ctor_QInputDevice_Adaptor_8669, &_call_ctor_QInputDevice_Adaptor_8669);
  methods += new qt_gsi::GenericMethod ("emit_availableVirtualGeometryChanged", "@brief Emitter for signal void QInputDevice::availableVirtualGeometryChanged(QRect area)\nCall this method to emit this signal.", false, &_init_emitter_availableVirtualGeometryChanged_915, &_call_emitter_availableVirtualGeometryChanged_915);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QInputDevice::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QInputDevice::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QInputDevice::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QInputDevice::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QInputDevice::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QInputDevice::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QInputDevice::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QInputDevice::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QInputDevice::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QInputDevice::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QInputDevice::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QInputDevice::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QInputDevice_Adaptor> decl_QInputDevice_Adaptor (qtdecl_QInputDevice (), "QtGui", "QInputDevice",
  methods_QInputDevice_Adaptor (),
  "@qt\n@brief Binding of QInputDevice");

}


//  Implementation of the enum wrapper class for QInputDevice::Capability
namespace qt_gsi
{

static gsi::Enum<QInputDevice::Capability> decl_QInputDevice_Capability_Enum ("QtGui", "QInputDevice_Capability",
    gsi::enum_const ("None", QInputDevice::Capability::None, "@brief Enum constant QInputDevice::Capability::None") +
    gsi::enum_const ("Position", QInputDevice::Capability::Position, "@brief Enum constant QInputDevice::Capability::Position") +
    gsi::enum_const ("Area", QInputDevice::Capability::Area, "@brief Enum constant QInputDevice::Capability::Area") +
    gsi::enum_const ("Pressure", QInputDevice::Capability::Pressure, "@brief Enum constant QInputDevice::Capability::Pressure") +
    gsi::enum_const ("Velocity", QInputDevice::Capability::Velocity, "@brief Enum constant QInputDevice::Capability::Velocity") +
    gsi::enum_const ("NormalizedPosition", QInputDevice::Capability::NormalizedPosition, "@brief Enum constant QInputDevice::Capability::NormalizedPosition") +
    gsi::enum_const ("MouseEmulation", QInputDevice::Capability::MouseEmulation, "@brief Enum constant QInputDevice::Capability::MouseEmulation") +
    gsi::enum_const ("PixelScroll", QInputDevice::Capability::PixelScroll, "@brief Enum constant QInputDevice::Capability::PixelScroll") +
    gsi::enum_const ("Scroll", QInputDevice::Capability::Scroll, "@brief Enum constant QInputDevice::Capability::Scroll") +
    gsi::enum_const ("Hover", QInputDevice::Capability::Hover, "@brief Enum constant QInputDevice::Capability::Hover") +
    gsi::enum_const ("Rotation", QInputDevice::Capability::Rotation, "@brief Enum constant QInputDevice::Capability::Rotation") +
    gsi::enum_const ("XTilt", QInputDevice::Capability::XTilt, "@brief Enum constant QInputDevice::Capability::XTilt") +
    gsi::enum_const ("YTilt", QInputDevice::Capability::YTilt, "@brief Enum constant QInputDevice::Capability::YTilt") +
    gsi::enum_const ("TangentialPressure", QInputDevice::Capability::TangentialPressure, "@brief Enum constant QInputDevice::Capability::TangentialPressure") +
    gsi::enum_const ("ZPosition", QInputDevice::Capability::ZPosition, "@brief Enum constant QInputDevice::Capability::ZPosition") +
    gsi::enum_const ("All", QInputDevice::Capability::All, "@brief Enum constant QInputDevice::Capability::All"),
  "@qt\n@brief This class represents the QInputDevice::Capability enum");

static gsi::QFlagsClass<QInputDevice::Capability > decl_QInputDevice_Capability_Enums ("QtGui", "QInputDevice_QFlags_Capability",
  "@qt\n@brief This class represents the QFlags<QInputDevice::Capability> flag set");

static gsi::ClassExt<QInputDevice> decl_QInputDevice_Capability_Enum_as_child (decl_QInputDevice_Capability_Enum, "Capability");
static gsi::ClassExt<QInputDevice> decl_QInputDevice_Capability_Enums_as_child (decl_QInputDevice_Capability_Enums, "QFlags_Capability");

}


//  Implementation of the enum wrapper class for QInputDevice::DeviceType
namespace qt_gsi
{

static gsi::Enum<QInputDevice::DeviceType> decl_QInputDevice_DeviceType_Enum ("QtGui", "QInputDevice_DeviceType",
    gsi::enum_const ("Unknown", QInputDevice::DeviceType::Unknown, "@brief Enum constant QInputDevice::DeviceType::Unknown") +
    gsi::enum_const ("Mouse", QInputDevice::DeviceType::Mouse, "@brief Enum constant QInputDevice::DeviceType::Mouse") +
    gsi::enum_const ("TouchScreen", QInputDevice::DeviceType::TouchScreen, "@brief Enum constant QInputDevice::DeviceType::TouchScreen") +
    gsi::enum_const ("TouchPad", QInputDevice::DeviceType::TouchPad, "@brief Enum constant QInputDevice::DeviceType::TouchPad") +
    gsi::enum_const ("Puck", QInputDevice::DeviceType::Puck, "@brief Enum constant QInputDevice::DeviceType::Puck") +
    gsi::enum_const ("Stylus", QInputDevice::DeviceType::Stylus, "@brief Enum constant QInputDevice::DeviceType::Stylus") +
    gsi::enum_const ("Airbrush", QInputDevice::DeviceType::Airbrush, "@brief Enum constant QInputDevice::DeviceType::Airbrush") +
    gsi::enum_const ("Keyboard", QInputDevice::DeviceType::Keyboard, "@brief Enum constant QInputDevice::DeviceType::Keyboard") +
    gsi::enum_const ("AllDevices", QInputDevice::DeviceType::AllDevices, "@brief Enum constant QInputDevice::DeviceType::AllDevices"),
  "@qt\n@brief This class represents the QInputDevice::DeviceType enum");

static gsi::QFlagsClass<QInputDevice::DeviceType > decl_QInputDevice_DeviceType_Enums ("QtGui", "QInputDevice_QFlags_DeviceType",
  "@qt\n@brief This class represents the QFlags<QInputDevice::DeviceType> flag set");

static gsi::ClassExt<QInputDevice> decl_QInputDevice_DeviceType_Enum_as_child (decl_QInputDevice_DeviceType_Enum, "DeviceType");
static gsi::ClassExt<QInputDevice> decl_QInputDevice_DeviceType_Enums_as_child (decl_QInputDevice_DeviceType_Enums, "QFlags_DeviceType");

}

